functor HOL_LEX(structure Tokens : hol_TOKENS
                         structure Parse_support : Parse_support_sig
                         sharing
                           Tokens.Parse_support = Parse_support)=
   struct
    structure UserDeclarations =
      struct
structure Parse_support = Parse_support;
structure Tokens = Tokens;

type pos = int;
val line:pos = 0;
type svalue = Tokens.svalue;
type ('a,'b) token = ('a,'b) Tokens.token;
type lexresult = (svalue,pos) Tokens.token;


fun error(s,_,_) = output(std_out,"HOL lexer error: "^s^"\n");

fun eof (_:Tokens.Parse_support.Preterm.Term.term list ref) = Tokens.EOF(line,line);
val type_paren_count = ref 0;
val comment_paren_count = ref 0;
val string_list = ref ([]:string list);
exception AQ_ERR of string;
exception LEX_ERR of string;

fun has_tilde s =
   let val tilde = ord "~"
       val comma = ord ","
       val semicolon = ord ";"
       fun f i = let val oof = ordof(s,i)
                 in (oof = tilde) orelse (oof = comma) orelse 
                    (oof=semicolon) orelse f(i+1) end
   in f 0 handle _ => false
   end;

fun drop_dollar s =
   let val dollar = ord "$"
   in if (ordof(s,0) = dollar)
      then substring(s,1,String.size s - 1)
      else s
   end;

(*---------------------------------------------------------------------------
 * fun break s = snd
 *    (itlist (fn ch => fn (current_frag,seen) =>
 *              if (ch = "~")
 *              then if (null current_frag)
 *                   then ([],(ch::seen))
 *                   else ([],(ch::(implode current_frag)::seen))
 *              else ((ch::current_frag),seen))
 *            (""::explode s) ([],[]));
 *---------------------------------------------------------------------------*)


(*---------------------------------------------------------------------------
 * Confusion warning: symbolic_ident means roughly 
 *
 *       Maybe a $ followed by any sequence of symbols
 *---------------------------------------------------------------------------*)
end (* end of user routines *)
exception LexError (* raised if illegal leaf action tried *)
structure Internal =
	struct

datatype yyfinstate = N of int
type statedata = {fin : yyfinstate list, trans: string}
(* transition & final state table *)
val tab = let
val s0 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
val s1 =
"\011\011\011\011\011\011\011\011\011\032\034\011\032\011\011\011\
\\011\011\011\011\011\011\011\011\011\011\011\011\011\011\011\011\
\\032\015\031\015\028\015\015\011\026\025\015\015\024\015\023\015\
\\018\018\018\018\018\018\018\018\018\018\015\015\015\015\015\015\
\\015\018\018\018\018\018\018\018\018\018\018\018\018\018\018\018\
\\018\018\018\018\018\018\018\018\018\018\018\022\015\021\020\015\
\\011\018\018\018\018\018\018\018\018\018\018\018\018\018\018\018\
\\018\018\018\018\018\018\018\018\018\018\018\017\015\014\012\011\
\\011"
val s3 =
"\035\035\035\035\035\035\035\035\035\063\065\035\063\035\035\035\
\\035\035\035\035\035\035\035\035\035\035\035\035\035\035\035\035\
\\063\039\035\062\059\039\039\057\055\054\039\053\052\050\049\039\
\\042\042\042\042\042\042\042\042\042\042\039\039\039\047\039\039\
\\039\042\042\042\042\042\042\042\042\042\042\042\042\042\042\042\
\\042\042\042\042\042\042\042\042\042\042\042\046\039\045\044\039\
\\035\042\042\042\042\042\042\042\042\042\042\042\042\042\042\042\
\\042\042\042\042\042\042\042\042\042\042\042\041\039\038\036\035\
\\035"
val s5 =
"\066\066\066\066\066\066\066\066\066\066\071\066\066\066\066\066\
\\066\066\066\066\066\066\066\066\066\066\066\066\066\066\066\066\
\\066\066\066\066\066\066\066\066\069\066\067\066\066\066\066\066\
\\066\066\066\066\066\066\066\066\066\066\066\066\066\066\066\066\
\\066\066\066\066\066\066\066\066\066\066\066\066\066\066\066\066\
\\066\066\066\066\066\066\066\066\066\066\066\066\066\066\066\066\
\\066\066\066\066\066\066\066\066\066\066\066\066\066\066\066\066\
\\066\066\066\066\066\066\066\066\066\066\066\066\066\066\066\066\
\\066"
val s7 =
"\072\072\072\072\072\072\072\072\072\072\077\072\072\072\072\072\
\\072\072\072\072\072\072\072\072\072\072\072\072\072\072\072\072\
\\072\072\072\072\072\072\072\072\075\072\073\072\072\072\072\072\
\\072\072\072\072\072\072\072\072\072\072\072\072\072\072\072\072\
\\072\072\072\072\072\072\072\072\072\072\072\072\072\072\072\072\
\\072\072\072\072\072\072\072\072\072\072\072\072\072\072\072\072\
\\072\072\072\072\072\072\072\072\072\072\072\072\072\072\072\072\
\\072\072\072\072\072\072\072\072\072\072\072\072\072\072\072\072\
\\072"
val s9 =
"\078\078\078\078\078\078\078\078\078\078\082\078\078\078\078\078\
\\078\078\078\078\078\078\078\078\078\078\078\078\078\078\078\078\
\\078\078\081\078\078\078\078\078\078\078\078\078\078\078\078\078\
\\078\078\078\078\078\078\078\078\078\078\078\078\078\078\078\078\
\\078\078\078\078\078\078\078\078\078\078\078\078\078\078\078\078\
\\078\078\078\078\078\078\078\078\078\078\078\078\079\078\078\078\
\\078\078\078\078\078\078\078\078\078\078\078\078\078\078\078\078\
\\078\078\078\078\078\078\078\078\078\078\078\078\078\078\078\078\
\\078"
val s12 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\013\000\013\000\013\013\000\000\000\013\013\013\013\000\013\
\\000\000\000\000\000\000\000\000\000\000\013\013\013\013\013\013\
\\013\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\013\000\000\013\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\013\000\013\000\
\\000"
val s15 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\016\000\016\000\016\016\000\000\000\016\016\013\016\000\016\
\\000\000\000\000\000\000\000\000\000\000\016\016\016\016\016\016\
\\016\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\016\000\000\016\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\016\000\013\000\
\\000"
val s18 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\019\000\000\000\000\000\000\000\000\
\\019\019\019\019\019\019\019\019\019\019\000\000\000\000\000\000\
\\000\019\019\019\019\019\019\019\019\019\019\019\019\019\019\019\
\\019\019\019\019\019\019\019\019\019\019\019\000\000\000\000\019\
\\000\019\019\019\019\019\019\019\019\019\019\019\019\019\019\019\
\\019\019\019\019\019\019\019\019\019\019\019\000\000\000\000\000\
\\000"
val s26 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\027\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
val s28 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\016\000\016\000\016\016\000\000\000\016\016\030\016\000\016\
\\019\019\019\019\019\019\019\019\019\019\016\016\016\016\016\016\
\\016\019\019\019\019\019\019\019\019\019\019\019\019\019\019\019\
\\019\019\019\019\019\019\019\019\019\019\019\000\016\000\000\016\
\\000\019\019\019\019\019\019\019\019\019\019\019\019\019\019\019\
\\019\019\019\019\019\019\019\019\019\019\019\000\016\000\029\000\
\\000"
val s32 =
"\000\000\000\000\000\000\000\000\000\033\033\000\033\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\033\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
val s36 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\037\000\037\000\037\037\000\000\000\037\037\037\037\000\037\
\\000\000\000\000\000\000\000\000\000\000\037\037\037\037\037\037\
\\037\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\037\000\000\037\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\037\000\037\000\
\\000"
val s39 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\040\000\040\000\040\040\000\000\000\040\040\037\040\000\040\
\\000\000\000\000\000\000\000\000\000\000\040\040\040\040\040\040\
\\040\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\040\000\000\040\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\040\000\037\000\
\\000"
val s42 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\043\000\000\000\000\000\000\000\000\
\\043\043\043\043\043\043\043\043\043\043\000\000\000\000\000\000\
\\000\043\043\043\043\043\043\043\043\043\043\043\043\043\043\043\
\\043\043\043\043\043\043\043\043\043\043\043\000\000\000\000\043\
\\000\043\043\043\043\043\043\043\043\043\043\043\043\043\043\043\
\\043\043\043\043\043\043\043\043\043\043\043\000\000\000\000\000\
\\000"
val s47 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\040\000\040\000\040\040\000\000\000\040\040\037\040\000\040\
\\000\000\000\000\000\000\000\000\000\000\040\040\040\040\048\040\
\\040\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\040\000\000\040\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\040\000\037\000\
\\000"
val s50 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\040\000\040\000\040\040\000\000\000\040\040\037\040\000\040\
\\000\000\000\000\000\000\000\000\000\000\040\040\040\040\051\040\
\\040\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\040\000\000\040\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\040\000\037\000\
\\000"
val s55 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\056\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
val s57 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\058\058\058\058\058\058\058\058\058\058\058\058\058\058\058\
\\058\058\058\058\058\058\058\058\058\058\058\000\000\000\000\000\
\\000\058\058\058\058\058\058\058\058\058\058\058\058\058\058\058\
\\058\058\058\058\058\058\058\058\058\058\058\000\000\000\000\000\
\\000"
val s58 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\058\058\058\058\058\058\058\058\058\058\000\000\000\000\000\000\
\\000\058\058\058\058\058\058\058\058\058\058\058\058\058\058\058\
\\058\058\058\058\058\058\058\058\058\058\058\000\000\000\000\058\
\\000\058\058\058\058\058\058\058\058\058\058\058\058\058\058\058\
\\058\058\058\058\058\058\058\058\058\058\058\000\000\000\000\000\
\\000"
val s59 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\040\000\040\000\040\040\000\000\000\040\040\061\040\000\040\
\\043\043\043\043\043\043\043\043\043\043\040\040\040\040\040\040\
\\040\043\043\043\043\043\043\043\043\043\043\043\043\043\043\043\
\\043\043\043\043\043\043\043\043\043\043\043\000\040\000\000\040\
\\000\043\043\043\043\043\043\043\043\043\043\043\043\043\043\043\
\\043\043\043\043\043\043\043\043\043\043\043\000\040\000\060\000\
\\000"
val s63 =
"\000\000\000\000\000\000\000\000\000\064\064\000\064\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\064\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
val s67 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\068\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
val s69 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\070\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
val s73 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\074\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
val s75 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\076\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
val s79 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\080\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
in Vector.vector
[{fin = [], trans = s0},
{fin = [], trans = s1},
{fin = [], trans = s1},
{fin = [], trans = s3},
{fin = [], trans = s3},
{fin = [], trans = s5},
{fin = [], trans = s5},
{fin = [], trans = s7},
{fin = [], trans = s7},
{fin = [], trans = s9},
{fin = [], trans = s9},
{fin = [(N 49)], trans = s0},
{fin = [(N 33),(N 42),(N 49)], trans = s12},
{fin = [(N 33)], trans = s12},
{fin = [(N 19),(N 49)], trans = s0},
{fin = [(N 33),(N 37),(N 49)], trans = s15},
{fin = [(N 33),(N 37)], trans = s15},
{fin = [(N 17),(N 49)], trans = s0},
{fin = [(N 29),(N 49)], trans = s18},
{fin = [(N 29)], trans = s18},
{fin = [(N 25),(N 49)], trans = s0},
{fin = [(N 23),(N 49)], trans = s0},
{fin = [(N 21),(N 49)], trans = s0},
{fin = [(N 11),(N 49)], trans = s0},
{fin = [(N 33),(N 47),(N 49)], trans = s12},
{fin = [(N 15),(N 49)], trans = s0},
{fin = [(N 13),(N 49)], trans = s26},
{fin = [(N 7)], trans = s0},
{fin = [(N 49)], trans = s28},
{fin = [(N 33),(N 40)], trans = s12},
{fin = [(N 33),(N 45)], trans = s12},
{fin = [(N 9),(N 49)], trans = s0},
{fin = [(N 4),(N 49)], trans = s32},
{fin = [(N 4)], trans = s32},
{fin = [(N 1),(N 4)], trans = s32},
{fin = [(N 113)], trans = s0},
{fin = [(N 97),(N 106),(N 113)], trans = s36},
{fin = [(N 97)], trans = s36},
{fin = [(N 90),(N 113)], trans = s0},
{fin = [(N 97),(N 101),(N 113)], trans = s39},
{fin = [(N 97),(N 101)], trans = s39},
{fin = [(N 88),(N 113)], trans = s0},
{fin = [(N 65),(N 113)], trans = s42},
{fin = [(N 65)], trans = s42},
{fin = [(N 67),(N 113)], trans = s0},
{fin = [(N 86),(N 113)], trans = s0},
{fin = [(N 84),(N 113)], trans = s0},
{fin = [(N 97),(N 101),(N 113)], trans = s47},
{fin = [(N 93),(N 97),(N 101)], trans = s39},
{fin = [(N 78),(N 113)], trans = s0},
{fin = [(N 97),(N 101),(N 113)], trans = s50},
{fin = [(N 70),(N 97),(N 101)], trans = s39},
{fin = [(N 76),(N 97),(N 111),(N 113)], trans = s36},
{fin = [(N 72),(N 97),(N 101),(N 113)], trans = s39},
{fin = [(N 82),(N 113)], trans = s0},
{fin = [(N 80),(N 113)], trans = s55},
{fin = [(N 57)], trans = s0},
{fin = [(N 113)], trans = s57},
{fin = [(N 61)], trans = s58},
{fin = [(N 113)], trans = s59},
{fin = [(N 97),(N 104)], trans = s36},
{fin = [(N 97),(N 109)], trans = s36},
{fin = [(N 74),(N 97),(N 101),(N 113)], trans = s39},
{fin = [(N 54),(N 113)], trans = s63},
{fin = [(N 54)], trans = s63},
{fin = [(N 51),(N 54)], trans = s63},
{fin = [(N 123)], trans = s0},
{fin = [(N 123)], trans = s67},
{fin = [(N 121)], trans = s0},
{fin = [(N 123)], trans = s69},
{fin = [(N 118)], trans = s0},
{fin = [(N 115)], trans = s0},
{fin = [(N 133)], trans = s0},
{fin = [(N 133)], trans = s73},
{fin = [(N 131)], trans = s0},
{fin = [(N 133)], trans = s75},
{fin = [(N 128)], trans = s0},
{fin = [(N 125)], trans = s0},
{fin = [(N 142)], trans = s0},
{fin = [(N 142)], trans = s79},
{fin = [(N 138)], trans = s0},
{fin = [(N 140),(N 142)], trans = s0},
{fin = [(N 135)], trans = s0}]
end
structure StartStates =
	struct
	datatype yystartstate = STARTSTATE of int

(* start state definitions *)

val COMMENT = STARTSTATE 7;
val INITIAL = STARTSTATE 1;
val STRING = STARTSTATE 9;
val TYCOMMENT = STARTSTATE 5;
val TYPE = STARTSTATE 3;

end
type result = UserDeclarations.lexresult
	exception LexerError (* raised if illegal leaf action tried *)
end

fun makeLexer yyinput = 
let 
	val yyb = ref "\n" 		(* buffer *)
	val yybl = ref 1		(*buffer length *)
	val yybufpos = ref 1		(* location of next character to use *)
	val yygone = ref 1		(* position in file of beginning of buffer *)
	val yydone = ref false		(* eof found yet? *)
	val yybegin = ref 1		(*Current 'start state' for lexer *)

	val YYBEGIN = fn (Internal.StartStates.STARTSTATE x) =>
		 yybegin := x

fun lex (yyarg as (lala : Parse_support.Preterm.Term.term list ref)) =
let fun continue() : Internal.result = 
  let fun scan (s,AcceptingLeaves : Internal.yyfinstate list list,l,i0) =
	let fun action (i,nil) = raise LexError
	| action (i,nil::l) = action (i-1,l)
	| action (i,(node::acts)::l) =
		case node of
		    Internal.N yyk => 
			(let val yytext = substring(!yyb,i0,i-i0)
			     val yypos = i0+ !yygone
			fun REJECT() = action(i,acts::l)
			open UserDeclarations Internal.StartStates
 in (yybufpos := i; case yyk of 

			(* Application actions *)

  1 => (continue())
| 101 => ( YYBEGIN INITIAL;
          case yytext 
            of ";"  => Tokens.semi_colon(line,line)
             | "=>" => Tokens.eq_gt(line,line)
             | "="  => Tokens.eq(line,line)
             | "|"  => Tokens.bar(line,line)
             | "::" => Tokens.dcolon(line,line)
             |   _  => if (Parse_support.is_binder yytext)
                       then Tokens.binder(yytext,line,line)
                       else Tokens.symbolic_ident(yytext,line,line))
| 104 => (YYBEGIN INITIAL;Tokens.ident("~",line,line))
| 106 => (YYBEGIN INITIAL;Tokens.ident("~",line,line))
| 109 => (YYBEGIN INITIAL;Tokens.symbolic_ident("$,",line,line))
| 11 => (Tokens.dot(line,line))
| 111 => (YYBEGIN INITIAL;Tokens.symbolic_ident(",",line,line))
| 113 => (raise LEX_ERR "TYPE.catchall")
| 115 => (continue())
| 118 => (inc comment_paren_count; continue())
| 121 => (dec comment_paren_count;
                    if (!comment_paren_count = 0)
                    then YYBEGIN TYPE
                    else ();
                    continue())
| 123 => (continue())
| 125 => (continue())
| 128 => (inc comment_paren_count; continue())
| 13 => (Tokens.lparen(line,line))
| 131 => (dec comment_paren_count;
                  if (!comment_paren_count = 0)
                  then YYBEGIN INITIAL
                  else ();
                  continue())
| 133 => (continue())
| 135 => (string_list :=  yytext::(!string_list); continue())
| 138 => (string_list := yytext::(!string_list); continue())
| 140 => (YYBEGIN INITIAL; 
              Tokens.string_(implode(rev(yytext::(!string_list))),line,line))
| 142 => (string_list :=  yytext::(!string_list); continue())
| 15 => (Tokens.rparen(line,line))
| 17 => (Tokens.lbrace(line,line))
| 19 => (Tokens.rbrace(line,line))
| 21 => (Tokens.lbracket(line,line))
| 23 => (Tokens.rbracket(line,line))
| 25 => (let val (L as ref (x::t)) = lala
                     val _ = L := t
                 in Tokens.aq(x,line,line)
                 end
                 handle _ => raise AQ_ERR "lexer.INITIAL")
| 29 => (case yytext
         of "let" => Tokens.let_(line,line)
          | "in" => Tokens.in_(line,line)
          | "and" => Tokens.and_(line,line)
          | "of" => (case (!Globals.in_type_spec)
                       of NONE => raise LEX_ERR(quote "of"^" is a keyword.")
                        |(SOME"")=>raise LEX_ERR(quote "of"^" is a keyword.")
                        |(SOME _) => (YYBEGIN TYPE; type_paren_count := 0;
                                      Tokens.of_(line,line)))
          |    _ => if (Parse_support.is_binder yytext)
                    then Tokens.binder(yytext,line,line)
                    else Tokens.ident(yytext,line,line))
| 33 => ( if (has_tilde yytext
         andalso (mem (drop_dollar yytext) (!Globals.tilde_symbols)))
     then if (Parse_support.is_binder yytext)
          then Tokens.binder(yytext,line,line)
          else Tokens.symbolic_ident(yytext,line,line)
     else REJECT())
| 37 => ( case yytext 
         of ";" => Tokens.semi_colon(line,line)
          | "=>" => Tokens.eq_gt(line,line)
          | "="  => Tokens.eq(line,line)
          | "|"  => Tokens.bar(line,line)
          | "::" => Tokens.dcolon(line,line)
          | ":" => ((case(!Globals.in_type_spec)
                       of NONE => (YYBEGIN TYPE;  type_paren_count := 0)
                        | _ => ());
                    Tokens.colon(line,line))
          |   _  => if (Parse_support.is_binder yytext)
                    then Tokens.binder(yytext,line,line)
                    else Tokens.symbolic_ident(yytext,line,line))
| 4 => (continue())
| 40 => (Tokens.ident("~",line,line))
| 42 => (Tokens.ident("~",line,line))
| 45 => (Tokens.symbolic_ident("$,",line,line))
| 47 => (Tokens.symbolic_ident(",",line,line))
| 49 => (raise LEX_ERR "INITIAL.catchall")
| 51 => (continue())
| 54 => (continue())
| 57 => ( YYBEGIN TYCOMMENT; comment_paren_count := 1; continue())
| 61 => (Tokens.type_var_ident(yytext,line,line))
| 65 => (case yytext
                    of "let" => (YYBEGIN INITIAL; Tokens.let_(line,line))
                     | "in"  => (YYBEGIN INITIAL; Tokens.in_(line,line))
                     | "and" => (YYBEGIN INITIAL; Tokens.and_(line,line))
                     |    _ => Tokens.type_ident(yytext,line,line))
| 67 => (let val (L as ref (x::t)) = lala
                  val () = L := t
              in Tokens.aq(x,line,line)
              end
              handle _ => raise AQ_ERR "lexer.TYPE")
| 7 => ( YYBEGIN COMMENT; comment_paren_count := 1; continue())
| 70 => (Tokens.type_right_arrow(line,line))
| 72 => (Tokens.type_plus(line,line))
| 74 => (Tokens.type_hash(line,line))
| 76 => (if (!type_paren_count = 0)
              then (YYBEGIN INITIAL; Tokens.symbolic_ident(",",line,line))
              else Tokens.type_comma(line,line))
| 78 => (YYBEGIN INITIAL; Tokens.dot(line,line))
| 80 => (inc type_paren_count; Tokens.type_lparen(line,line))
| 82 => (if (!type_paren_count = 0)
               then (YYBEGIN INITIAL; Tokens.rparen(line,line))
               else (dec type_paren_count; Tokens.type_rparen(line,line)))
| 84 => (YYBEGIN INITIAL; Tokens.lbracket(line,line))
| 86 => (YYBEGIN INITIAL; Tokens.rbracket(line,line))
| 88 => (YYBEGIN INITIAL; Tokens.lbrace(line,line))
| 9 => ( YYBEGIN STRING; string_list := [yytext]; continue())
| 90 => (YYBEGIN INITIAL; Tokens.rbrace(line,line))
| 93 => ((case (!Globals.in_type_spec)
                  of (SOME _) => ()
                   | NONE => YYBEGIN INITIAL);
               Tokens.eq_gt(line,line))
| 97 => ( if (has_tilde yytext 
         andalso (mem (drop_dollar yytext) (!Globals.tilde_symbols)))
     then( YYBEGIN INITIAL;
           if (Parse_support.is_binder yytext)
           then Tokens.binder(yytext,line,line)
           else Tokens.symbolic_ident(yytext,line,line))
     else REJECT())
| _ => raise Internal.LexerError

		) end )

	val {fin,trans} = Vector.sub(Internal.tab, s)
	val NewAcceptingLeaves = fin::AcceptingLeaves
	in if l = !yybl then
	     if trans = #trans(Vector.sub(Internal.tab,0))
	       then action(l,NewAcceptingLeaves
) else	    let val newchars= if !yydone then "" else yyinput 1024
	    in if (size newchars)=0
		  then (yydone := true;
		        if (l=i0) then UserDeclarations.eof yyarg
		                  else action(l,NewAcceptingLeaves))
		  else (if i0=l then yyb := newchars
		     else yyb := substring(!yyb,i0,l-i0)^newchars;
		     yygone := !yygone+i0;
		     yybl := size (!yyb);
		     scan (s,AcceptingLeaves,l-i0,0))
	    end
	  else let val NewChar = ordof(!yyb,l)
		val NewState = if NewChar<128 then ordof(trans,NewChar) else ordof(trans,128)
		in if NewState=0 then action(l,NewAcceptingLeaves)
		else scan(NewState,NewAcceptingLeaves,l+1,i0)
	end
	end
(*
	val start= if substring(!yyb,!yybufpos-1,1)="\n"
then !yybegin+1 else !yybegin
*)
	in scan(!yybegin (* start *),nil,!yybufpos,!yybufpos)
    end
in continue end
  in lex
  end
end
