(*---------------------------------------------------------------------------
 * Pattern matching extensions.
 *---------------------------------------------------------------------------*)

new_theory"test2";

val def = function;

(*---------------------------------------------------------------------------
 * Normal patterns
 *---------------------------------------------------------------------------*)
def `(f(x,y) = x+y)`;

def `(f1 0 = 1) /\ 
     (f1 (SUC n) = 2)`;

(*---------------------------------------------------------------------------
 * Omitted patterns
 *---------------------------------------------------------------------------*)
def `(f2 0 = 1)`;

def `(f3 (CONS h t) = (h:'a))`;

def `(f4 [a;b] = (a:bool)) /\
     (f4 [b]   = b)`;

def `(f5 (0,0) = 0)`;

def `(f6 (0,0) = 0) /\
     (f6 (0,SUC x) = x) /\
     (f6 (SUC x, y) = y+x)`; 

def `(f7 (SUC 0, CONS h t) = 1) /\ 
     (f7 (SUC(SUC n), CONS h1 (CONS h2 t)) = (h1:num))`;

def `(f8 (SUC(SUC n),CONS h1 (CONS h2 t)) = (h1:num))`;

def `(f9 (CONS h1 (CONS h2 t)) = t) /\
     (f9 x = (x:'a list))`;

(*---------------------------------------------------------------------------
 * Overlapping patterns 
 *---------------------------------------------------------------------------*)
def `(g (x,0) = 1) /\
     (g (0,x) = 2)`; 

def `(g1 (0,x) = x) /\
     (g1 (x,0) = x)`; 

def `(g2 ([]:'a list, CONS a (CONS b x)) = 1) /\
     (g2 (CONS a (CONS b x),    y)       = 2) /\
     (g2 (z,          CONS a y)          = 3)`;	

def `(g3 (x,y,0) = 1) /\
     (g3 (x,0,y) = 2) /\
     (g3 (0,x,y) = 3)`;

def `(g4 (0,y,z) = 1) /\
     (g4 (x,0,z) = 2) /\
     (g4 (x,y,0) = 3)`;

def `(g5(0,x,y,z) = 1) /\
     (g5(w,0,y,z) = 2) /\
     (g5(w,x,0,z) = 3) /\
     (g5(w,x,y,0) = 4)`;

def `(g6 (0,w,x,y,z) = 1) /\
     (g6 (v,0,x,y,z) = 2) /\
     (g6 (v,w,0,y,z) = 3) /\
     (g6 (v,w,x,0,z) = 4) /\
     (g6 (v,w,x,y,0) = 5)`;

def `(g7 [x; 0] = x) /\
     (g7 [SUC v] = 1) /\
     (g7 z = 2)`;

def `(g8 (CONS h1 (CONS h2 (CONS h3 (CONS h4 (CONS h5 h6))))) = 
           CONS [h1;h2;h3;h4;h5] [h6]) /\ 
     (g8 x = [x:'a list])`;

(* Normal *)
def `(g9 (SUC(SUC x)) = 1) /\
     (g9 (SUC x) = 2) /\
     (g9 0 = 3)`;

(*---------------------------------------------------------------------------
 * Unaccessible patterns
 *---------------------------------------------------------------------------*)
def `(h (x:num) = 1) /\
     (h x = 2)`;

def `(h1 (x:num,0) = 1) /\
     (h1 (x,SUC y) = 2) /\
     (h1 (x,y) = 3) /\
     (h1 (x,y) = 3)`;

def `(h2 (x,0) = 1) /\
     (h2 (0,x) = 2) /\
     (h2 (0,0) = 3) /\ 
     (h2 (x,y) = 4)`; 
