(*---------------------------------------------------------------------------
 * Pattern matching extensions.
 *---------------------------------------------------------------------------*)

new_theory"test2";

val def = function;

(*---------------------------------------------------------------------------
 * Normal patterns
 *---------------------------------------------------------------------------*)
def `(f(x,y) = x+y)`;

def `(f1 0 = 1) /\ 
     (f1 (SUC n) = 2)`;

(*---------------------------------------------------------------------------
 * Omitted patterns
 *---------------------------------------------------------------------------*)
def `(f2 0 = 1)`;

def `(f3 (h::t) = (h:'a))`;

def `(f4 [a;b] = (a:bool)) /\
     (f4 [b]   = b)`;

def `(f5 (0,0) = 0)`;

def `(f6 (0,0) = 0) /\
     (f6 (0,SUC x) = x) /\
     (f6 (SUC x, y) = y+x)`; 

def `(f7 (SUC 0, h::t) = 1) /\ 
     (f7 (SUC(SUC n),h1::h2::t) = (h1:num))`;

def `(f8 (SUC(SUC n),h1::h2::t) = (h1:num))`;

(*---------------------------------------------------------------------------
 * Overlapping patterns 
 *---------------------------------------------------------------------------*)
def `(g (h1::h2::t) = t) /\
     (g x = (x:'a list))`;

def `(g0 (x,0) = 1) /\
     (g0 (0,x) = 2)`; 

def `(g1 (0,x) = x) /\
     (g1 (x,0) = x)`; 

def `(g2 ([]:'a list, a::b::x) = 1) /\
     (g2 (a::b::x,    y)       = 2) /\
     (g2 (z,          a::y)    = 3)`;	

def `(g3 (x,y,0) = 1) /\
     (g3 (x,0,y) = 2) /\
     (g3 (0,x,y) = 3)`;

def `(g4 (0,y,z) = 1) /\
     (g4 (x,0,z) = 2) /\
     (g4 (x,y,0) = 3)`;

def `(g5(0,x,y,z) = 1) /\
     (g5(w,0,y,z) = 2) /\
     (g5(w,x,0,z) = 3) /\
     (g5(w,x,y,0) = 4)`;

def `(g6 (0,w,x,y,z) = 1) /\
     (g6 (v,0,x,y,z) = 2) /\
     (g6 (v,w,0,y,z) = 3) /\
     (g6 (v,w,x,0,z) = 4) /\
     (g6 (v,w,x,y,0) = 5)`;

def `(g7 (0,v,w,x,y,z) = 1) /\
     (g7 (u,0,w,x,y,z) = 2) /\
     (g7 (u,v,0,x,y,z) = 3) /\
     (g7 (u,v,w,0,y,z) = 4) /\
     (g7 (u,v,w,x,0,z) = 5) /\
     (g7 (u,v,w,x,y,0) = 6)`;

def `(g8 [x; 0] = x) /\
     (g8 [SUC v] = 1) /\
     (g8 z = 2)`;

def `(g9 (h1::h2::h3::h4::h5::h6) = [h1;h2;h3;h4;h5]::[h6]) /\ 
     (g9 x = [x:'a list])`;

(* Normal *)
def `(g10 (SUC(SUC x)) = 1) /\
     (g10 (SUC x) = 2) /\
     (g10 0 = 3)`;

(*---------------------------------------------------------------------------
 * Inaccessible patterns
 *---------------------------------------------------------------------------*)
def `(h (x:num) = 1) /\
     (h x = 2)`;

def `(h1 (x:num,0) = 1) /\
     (h1 (x,SUC y) = 2) /\
     (h1 (x,y) = 3) /\
     (h1 (x,y) = 3)`;

def `(h2 (x,0) = 1) /\
     (h2 (0,x) = 2) /\
     (h2 (0,0) = 3) /\ 
     (h2 (x,y) = 4)`; 
