signature NUMBER_HOL_TYPE =
sig
   eqtype num
   
   val num_ty : CoreHol.Type.hol_type
   val term_of_num : num -> CoreHol.Term.term
   val num_of_term : CoreHol.Term.term -> num
   val plus : string
   val minus : string
   val mult : string
   val less : string
   val leq : string
   val great : string
   val geq : string
   val suc : string
   val pre : string
   val zero : string
   val one : string
end;

signature ARITH_CONS =
sig
(*   type term sharing type term = CoreHol.Term.term *)

   type term

   structure NumberHOLType : NUMBER_HOL_TYPE
   val mk_plus : term * term -> term
   val mk_minus : term * term -> term
   val mk_mult : term * term -> term
   val dest_plus : term -> term * term
   val dest_minus : term -> term * term
   val dest_mult : term -> term * term
   val is_plus : term -> bool
   val is_minus : term -> bool
   val is_mult : term -> bool
   val mk_less : term * term -> term
   val mk_leq : term * term -> term
   val mk_great : term * term -> term
   val mk_geq : term * term -> term
   val dest_less : term -> term * term
   val dest_leq : term -> term * term
   val dest_great : term -> term * term
   val dest_geq : term -> term * term
   val is_less : term -> bool
   val is_leq : term -> bool
   val is_great : term -> bool
   val is_geq : term -> bool
   val is_num_reln : term -> bool
   val mk_suc : term -> term
   val dest_suc : term -> term
   val is_suc : term -> bool
   val mk_pre : term -> term
   val dest_pre : term -> term
   val is_pre : term -> bool
   val is_num_const : term -> bool
   val is_zero : term -> bool
   val is_num_var : term -> bool
   val mk_num_var : string -> term
end;
