#include <stdio.h>
#include <filehdr.h>
#include <aouthdr.h>
#include <ldfcn.h>
#include <scnhdr.h>
#include <syms.h>
#include <reloc.h>

main(argc, argv)
int argc;
char *argv[];
{
	int i, j;
	char *s;

	LDFILE *ldptr;
	struct aouthdr unix_header;
	SCNHDR secthead1;
	SCNHDR secthead2;
	SCNHDR secthead3;
	SCNHDR secthead4;
	SYMENT symbol;
	struct reloc reloc;

	printf("sizeof(struct reloc) = %d\n\n", sizeof(struct reloc));
	printf("sizeof(struct syment) = %d\n\n", sizeof(struct syment));

	ldptr = ldopen(argv[1], NULL);

	printf("f_magic:        %o\n", HEADER(ldptr).f_magic);
	printf("f_nscns:	%d\n", HEADER(ldptr).f_nscns);
	printf("f_timdat:	%d\n", HEADER(ldptr).f_timdat);
	printf("f_symptr:	%d\n", HEADER(ldptr).f_symptr);
	printf("f_nsyms:	%d\n", HEADER(ldptr).f_nsyms);
	printf("f_opthdr:	%d\n", HEADER(ldptr).f_opthdr);
	printf("f_flags:	%o\n", HEADER(ldptr).f_flags);

	if(HEADER(ldptr).f_opthdr == 0)
		goto SSS;
	FSEEK(ldptr, sizeof(struct filehdr), 0);
	FREAD(&unix_header, sizeof(struct aouthdr), 1, ldptr);

	printf("\nmagic:		%o\n", unix_header.magic);
	printf("vstamp:		%o\n", unix_header.vstamp);
	printf("tsize:		%d\n", unix_header.tsize);
	printf("dsize:		%d\n", unix_header.dsize);
	printf("bsize:		%d\n", unix_header.bsize);
	printf("entry:		%o\n", unix_header.entry);
	printf("text_start:	%o\n", unix_header.text_start);
	printf("data_start:	%o\n", unix_header.data_start);

SSS:
	ldshread(ldptr, 1, &secthead1);

	printf("\nsecthead1:\n");
	printf("s_name: %s\n", secthead1.s_name);
	printf("s_paddr:	%o\n", secthead1.s_paddr);
	printf("s_vaddr:	%o\n", secthead1.s_vaddr);
	printf("s_size:		%d\n", secthead1.s_size);
	printf("s_scnptr:	%o\n", secthead1.s_scnptr);
	printf("s_relptr:	%o\n", secthead1.s_relptr);
	printf("s_lnnoptr:	%o\n", secthead1.s_lnnoptr);
	printf("s_nreloc:	%d\n", secthead1.s_nreloc);
	printf("s_nlnno:	%d\n", secthead1.s_nlnno);
	printf("s_flags:	%o\n", secthead1.s_flags);

	ldshread(ldptr, 2, &secthead2);

	printf("\nsecthead2:\n");
	printf("s_name:	%s\n", secthead2.s_name);
	printf("s_paddr:	%o\n", secthead2.s_paddr);
	printf("s_vaddr:	%o\n", secthead2.s_vaddr);
	printf("s_size:		%d\n", secthead2.s_size);
	printf("s_scnptr:	%o\n", secthead2.s_scnptr);
	printf("s_relptr:	%o\n", secthead2.s_relptr);
	printf("s_lnnoptr:	%o\n", secthead2.s_lnnoptr);
	printf("s_nreloc:	%d\n", secthead2.s_nreloc);
	printf("s_nlnno:	%d\n", secthead2.s_nlnno);
	printf("s_flags:	%o\n", secthead2.s_flags);

	ldshread(ldptr, 3, &secthead3);

	printf("\nsecthead3:\n");
	printf("s_name:	%s\n", secthead3.s_name);
	printf("s_paddr:	%o\n", secthead3.s_paddr);
	printf("s_vaddr:	%o\n", secthead3.s_vaddr);
	printf("s_size:		%d\n", secthead3.s_size);
	printf("s_scnptr:	%o\n", secthead3.s_scnptr);
	printf("s_relptr:	%o\n", secthead3.s_relptr);
	printf("s_lnnoptr:	%o\n", secthead3.s_lnnoptr);
	printf("s_nreloc:	%d\n", secthead3.s_nreloc);
	printf("s_nlnno:	%d\n", secthead3.s_nlnno);
	printf("s_flags:	%o\n", secthead3.s_flags);

	ldshread(ldptr, 4, &secthead4);

	printf("\nsecthead4:\n");
	printf("s_name:	%s\n", secthead4.s_name);
	printf("s_paddr:	%o\n", secthead4.s_paddr);
	printf("s_vaddr:	%o\n", secthead4.s_vaddr);
	printf("s_size:		%d\n", secthead4.s_size);
	printf("s_scnptr:	%o\n", secthead4.s_scnptr);
	printf("s_relptr:	%o\n", secthead4.s_relptr);
	printf("s_lnnoptr:	%o\n", secthead4.s_lnnoptr);
	printf("s_nreloc:	%d\n", secthead4.s_nreloc);
	printf("s_nlnno:	%d\n", secthead4.s_nlnno);
	printf("s_flags:	%o\n", secthead4.s_flags);

	printf("\nreloc info for 1:\n");
	ldrseek(ldptr, 1);
	for (i = 0; i < secthead1.s_nreloc; i++)	{
		j = fread(&reloc, 10, 1, IOPTR(ldptr));
		if (j != 1)
			fprintf(stderr, "READ ERROR\n");
		printf("\nr_vaddr		%o\n", reloc.r_vaddr);
		printf("r_symndx	%d\n", reloc.r_symndx);
		switch (reloc.r_type)	{
		case R_ABS:
			printf("r_type		R_ABS\n");
			break;
		case R_DIR32:
			printf("r_type		R_DIR32\n");
			break;
		case R_OFF16:
			printf("r_type		R_OFF16\n");
			break;
		case R_DIR32S:
			printf("r_type		R_DIR32S\n");
			break;
		case R_REL24:
			printf("r_type		R_REL24\n");
			break;
		case R_OPT16:
			printf("r_type		R_OPT16\n");
			break;
		case R_IND24:
			printf("r_type		R_IND24\n");
			break;
		case R_IND32:
			printf("r_type		R_IND32\n");
			break;
		default:
			fprintf(stderr, "Illegal r_type:	%o\n",
				reloc.r_type);
			break;
		}
	}

	printf("\nreloc info for 2:\n");
	ldrseek(ldptr, 2);
	for (i = 0; i < secthead2.s_nreloc; i++)	{
		fread(&reloc, sizeof(struct reloc), 1, IOPTR(ldptr));
		printf("\nr_vaddr		%o\n", reloc.r_vaddr);
		printf("r_symndx	%d\n", reloc.r_symndx);
		switch (reloc.r_type)	{
		case R_RELBYTE:
			printf("r_type		R_RELTYPE\n");
			break;
		case R_RELWORD:
			printf("r_type		R_RELWORD\n");
			break;
		case R_RELLONG:
			printf("r_type		R_RELLONG\n");
			break;
		default:
			fprintf(stderr, "Illegal r_type:	%d",
				reloc.r_type);
			break;
		}
	}

	printf("\nsymbols:\n");
	for (i = 0; i < HEADER(ldptr).f_nsyms; i++)	{
		ldtbread(ldptr, i, &symbol);
		printf("\nldgetname(%d):	%s\n",
			i, ldgetname(ldptr, &symbol));
		printf("n_value:	%o\n", symbol.n_value);
		switch (symbol.n_scnum)	{
		case N_UNDEF:
			printf("n_scnum:	N_UNDEF\n");
			break;
		case N_ABS:
			printf("n_scnum:	N_ABS\n");
			break;
		case N_DEBUG:
			printf("n_scnum:	N_DEBUG\n");
			break;
		case N_TV:
			printf("n_scnum:	N_TV\n");
			break;
		case P_TV:
			printf("n_scnum:	P_TV\n");
			break;
		default:
			printf("n_scnum:	%d\n", symbol.n_scnum);
			break;
		}
		printf("n_type:		%d\n", symbol.n_type);
		printf("n_scalss:	%d\n", symbol.n_sclass);
		printf("n_numaux:	%d\n", symbol.n_numaux);
		i += symbol.n_numaux;
	}
}
