/*
(C) Copyright Taiichi Yuasa and Masami Hagiya, 1984.  All rights reserved.
*/

/*
	sys.c
	DG-SPECIFIC
*/

#include "include.h"

#define $ERMSG 0311
#define BUFLN 128

sys_emes(ecode)
int	ecode;
{
	int	ac1,ac2;
	int	ier;
	int	i;
	char	mess_buff[BUFLN];

	getemes(ecode, mess_buff);

	vs_push(make_simple_string(mess_buff));
	FEerror("~@(~A~).", 1, vs_head);
}

getemes(ecode, buff)
int	ecode;
char	*buff;
{
	int	ac0, ac1, ac2, ac3;

	for (ac0 = 0; ac0 < BUFLN; ac0++)
		buff[ac0] = '\0';

	ac0 = ecode;
	ac1 = BUFLN * 0400 + 0377;
	ac2 = buff;
	if (sys($ERMSG, &ac0, &ac1, &ac2))
		sprintf(buff, "System error, code : %o", ecode);
}

#define $PNAME	0116

char	mypid[4] = "000\0";

get_pid()
{
	int	ac0, ac1, ac2, ier, i;

	ac0 = 0;
	ac1 = -1;	/* get my pid */
	sys($PNAME, &ac0, &ac1, &ac2);		/* ignore error */

	for (i=2; i >= 0; i--) {
		ac0 = ac1 % 10;
		ac1 = ac1 / 10;
		mypid[i] = ac0 + '0';
		}
}

copypid(buffp)
char	*buffp;
{
	int	i;

	for (i=0; i <= 2; i++) buffp[i] = mypid[i];
}

#define $RUNTM 030

runtime()
{
	int	pack[4];
	int	ac0, ac1, ac2, ier;
		
	ac0 = -1;
	ac2 = pack;
	sys($RUNTM, &ac0, &ac1, &ac2);
	return(pack[1]);
}

#define FLOAT_OVF	010000000000
#define FLOAT_UNF	004000000000
#define FLOAT_DVZ	002000000000
#define FLOAT_MOF	001000000000

FERR(fstat)
int	fstat;
{
	if (fstat & FLOAT_OVF)
		FEerror("Floating point overflow.",0);
	if (fstat & FLOAT_UNF)
		FEerror("Floating point underflow.",0);
	if (fstat & FLOAT_DVZ)
		FEerror("Floating point fault : zero divide.",0);
	if (fstat & FLOAT_MOF)
		FEerror("Floating point mantissa overflow.",0);

	FEerror("Unknown floating point error.",0);
}
