/*
(C) Copyright Taiichi Yuasa and Masami Hagiya, 1984.  All rights reserved.
*/

/*
	dguxfaslio.c
	DG-SPECIFIC

	FASL loader io routines
*/

#include <stdio.h>
#include "../h/fasl.h"
#include "../h/fasl_global.h"

/* open fasl file */
fasl_open(namep)
char	*namep;		/* file name byte pointer */
{
	if (faslin != NULL) fasl_close();
	faslin = fopen(namep, "r");
	if (faslin == NULL) return(-1);
	setbuf(faslin, faslbuff);
	return(0);

}

/* close FASL file */
fasl_close()
{
	fclose(faslin);
	faslin = NULL;
	return(0);
}

/* get next fasl block */
fasl_nblock()
{
	int block_len;

	fread(fas_buffp, FAS_HEADER_BLEN, 1, faslin);

	block_len = ((FAS_HDR_P)fas_buffp)->hdr_len;  /* set block len */

	/* if no block body , then return to caller */
	if (block_len <= FAS_HEADER_LEN) return(0);

	/* we must read block body */
	fread(fas_buffp + FAS_HEADER_BLEN, block_len * 2 - FAS_HEADER_BLEN,
		1, faslin);
	return(0);
}

fasl_open_temp()
{
	int	i;

	if (fasltemp != NULL) fasl_close_temp();

	for (i = 0; (fasltempname[i]=fasltemporg[i]) != 0; i++) ;

	fasltemp = fopen(mktemp(fasltempname), "w+");
	if (fasltemp == NULL) FEerror("Can't open temp file.", 0); 
	setbuf(fasltemp, faslbuff1);
}

fasl_close_temp()
{
	fclose(fasltemp);
	fasltemp = NULL;
	unlink(fasltempname);
	return(0);
}

fasl_read_temp(recno)
int	recno;
{
	fseek(fasltemp, FAS_BUFF_LEN * recno, 0);
	fread(fas_temp_buff, FAS_BUFF_LEN, 1, fasltemp);
	fas_temp_curr = recno;
}

fasl_write_temp()
{
	fseek(fasltemp, FAS_BUFF_LEN * fas_temp_curr, 0);
	fwrite(fas_temp_buff, FAS_BUFF_LEN, 1, fasltemp);
}

fasl_read_addr_rec(recno)
int recno;
{
	fseek(fasltemp, FAS_BUFF_LEN * (fas_addr_rec_first + recno), 0);
	fread(fas_addr_buff, FAS_BUFF_LEN, 1, fasltemp);
	fas_addr_rec_curr = recno;
}

fasl_write_addr_rec(recno)
int recno;
{
	fseek(fasltemp, FAS_BUFF_LEN * (fas_addr_rec_first + recno), 0);
	fwrite(fas_addr_buff, FAS_BUFF_LEN, 1, fasltemp);
}

init_fasl_io()
{
}

static int
hash(name, len)
char *name;
int len;
{
	return((name[0] + name[len-1]) % FAS_HSIZE);
}

fasl_st(symp, symv)
char *symp;
int *symv;
{
	int	blen;
	int	blen1;
	int	h;
	short	count;
	struct sym_entry *e;
	struct sym_header *p;
	int	page_no;
	char	*b;

	blen = strlen(symp);
	page_no = h = hash(symp, blen);

	for (;;) {
		b = faslsymbuff[page_no];
/*		p = (struct sym_header *)(&(faslsymbuff[page_no][0]));	*/
		p = (struct sym_header *)b;
		count = p->count;
		page_no = p->npage;
		e = (struct sym_entry *)(p + 1);
		while (count-- > 0) {
			blen1 = e->blength;
			if (blen == blen1 &&
			    strncmp(symp, (char *)(e + 1), blen) == 0) {
				*symv = e->value;
				return(0);
			}
			e = (struct sym_entry *)
				((char *)(e + 1) + blen1 + (blen1 & 1));
		}
		if (page_no == 0) return(-1);
	}
}

init_faslst()
{
	FILE	*st;
	int	i;
	char	buff[BUFSIZ];

	st = fopen("entry_table", "r");
	if (st == NULL) FEerror("Can't open entry_table.", 0);
	setbuf(st, buff);

	for (i = 0; i < SYMBOL_TABLE_MAX; i++) {
		if (fread(&(faslsymbuff[i][0]), BUFSIZ, 1, st) < 1) break;
	}

	fclose(st);
}
