/*
(c) Copyright Taiichi Yuasa and Masami Hagiya, 1984.  All rights reserved.
Copying of this file is authorized to users who have executed the true and
proper "License Agreement for Kyoto Common LISP" with SIGLISP.
*/

/*
	cfun.c
*/

#include "include.h"

object
make_cfun(self, name, data, start, size)
int (*self)();
object name, data;
char *start;
int size;
{
	object cf;

	cf = alloc_object(t_cfun);
	cf->cf.cf_self = self;
	cf->cf.cf_name = name;
	cf->cf.cf_data = data;
	cf->cf.cf_start = start;
	cf->cf.cf_size = size;
	return(cf);
}

object
make_cclosure(self, name, env, data, start, size)
int (*self)();
object name, env, data;
char *start;
int size;
{
	object cc;

	cc = alloc_object(t_cclosure);
	cc->cc.cc_self = self;
	cc->cc.cc_name = name;
	cc->cc.cc_env = env;
	cc->cc.cc_data = data;
	cc->cc.cc_start = start;
	cc->cc.cc_size = size;
	cc->cc.cc_turbo = NULL;
	return(cc);
}

object
MF(sym, self, start, size, data)
object sym;
int (*self)();
char *start;
int size;
object data;
{
	object cf;

	if (type_of(sym) != t_symbol)
		not_a_symbol(sym);
	if (sym->s.s_sfdef != NOT_SPECIAL && sym->s.s_mflag)
		sym->s.s_sfdef = NOT_SPECIAL;
	clear_compiler_properties(sym);
	cf = alloc_object(t_cfun);
	cf->cf.cf_self = self;
	cf->cf.cf_name = sym;
	cf->cf.cf_data = data;
	cf->cf.cf_start = start;
	cf->cf.cf_size = size;
	sym->s.s_gfdef = cf;
	sym->s.s_mflag = FALSE;
}

object
MM(sym, self, start, size, data)
object sym;
int (*self)();
char *start;
int size;
object data;
{
	object cf;

	if (type_of(sym) != t_symbol)
		not_a_symbol(sym);
	if (sym->s.s_sfdef != NOT_SPECIAL && sym->s.s_mflag)
		sym->s.s_sfdef = NOT_SPECIAL;
	clear_compiler_properties(sym);
	cf = alloc_object(t_cfun);
	cf->cf.cf_self = self;
	cf->cf.cf_name = sym;
	cf->cf.cf_data = data;
	cf->cf.cf_start = start;
	cf->cf.cf_size = size;
	sym->s.s_gfdef = cf;
	sym->s.s_mflag = TRUE;
}

object
make_function(s, f)
char *s;
int (*f)();
{
	object x;
	vs_mark;

	x = make_ordinary(s);
	vs_push(x);
	x->s.s_gfdef = make_cfun(f, x, Cnil, NULL, 0);
	x->s.s_mflag = FALSE;
	vs_reset;
	return(x);
}

object
make_si_function(s, f)
char *s;
int (*f)();
{
	object x;
	vs_mark;

	x = make_si_ordinary(s);
	vs_push(x);
	x->s.s_gfdef = make_cfun(f, x, Cnil, NULL, 0);
	x->s.s_mflag = FALSE;
	vs_reset;
	return(x);
}

object
make_special_form(s, f)
char *s;
int (*f)();
{
	object x;
	x = make_ordinary(s);
	x->s.s_sfdef = f;
	return(x);
}

siLcompiled_function_name()
{
	check_arg(1);

	if (type_of(vs_base[0]) == t_cfun)
		vs_base[0] = vs_base[0]->cf.cf_name;
	else if (type_of(vs_base[0]) == t_cclosure)
		vs_base[0] = vs_base[0]->cc.cc_name;
	else
		FEerror("~S is not a compiled-function.", 1, vs_base[0]);
}

turbo_closure(fun)
object fun;
{
	object l;
	int n;

	for (n = 0, l = fun->cc.cc_env;  !endp(l);  n++, l = l->c.c_cdr)
		;
	fun->cc.cc_turbo = (object *)alloc_contblock(n*sizeof(object));
	for (n = 0, l = fun->cc.cc_env;  !endp(l);  n++, l = l->c.c_cdr)
		fun->cc.cc_turbo[n] = l;
}

siLturbo_closure()
{
	check_arg(1);
	if (type_of(vs_base[0]) == t_cclosure)
		turbo_closure(vs_base[0]);
}

init_cfun()
{
	make_si_function("COMPILED-FUNCTION-NAME",
			 siLcompiled_function_name);
	make_si_function("TURBO-CLOSURE", siLturbo_closure);
}
