;; (c) Copyright Taiichi Yuasa and Masami Hagiya, 1984.  All rights reserved.
;; Copying of this file is authorized to users who have executed the true and
;; proper "License Agreement for Kyoto Common LISP" with SIGLISP.

;;;;   setdoc.lsp
;;;;
;;;;                    Sets doc-strings for built-in symbols.
;;;;			This file is intended to be loaded into KCL
;;;;			after initialization and before save.
;;;;			This file need not be compiled.

;;;;		In the following doc-strings, some phrases come from
;;;;		Steele's manual and some from Spice code.  But almost
;;;;		all sentences are tuned for KCL.


(in-package 'system)

(defmacro docfun (symbol kind string)
          (declare (ignore kind))
  `(si:putprop ',symbol ,string 'si:function-documentation))

(defmacro docvar (symbol kind string)
          (declare (ignore kind))
  `(si:putprop ',symbol ,string 'si:variable-documentation))

(defmacro doctype (symbol string)
  `(si:putprop ',symbol ,string 'si::type-documentation))

(docfun * function "
Args: (&rest numbers)
Returns the product of its arguments.  With no args, returns 1.")

(docvar * variable "
Holds the value of the last top-level form.")

(docvar ** variable "
Gets the previous value of * when KCL evaluates a top-level form.")

(docvar *** variable "
Gets the previous value of ** when KCL evaluates a top-level form.")

(docfun + function "
Args: (&rest numbers)
Returns the sum of its arguments.  With no args, returns 0.")

(docvar + variable "
Holds the last top-level form.")

(docvar ++ variable "
Gets the previous value of + when KCL evaluates a top-level form.")

(docvar +++ variable "
Gets the previous value of ++ when KCL evaluates a top-level form.")

(docfun - function "
Args: (number &rest more-numbers)
Subtracts the second and all subsequent NUMBERs from the first NUMBER.
With one arg, negates it.")

(docvar - variable "
Holds the top-level form that KCL is currently evaluating.")

(docfun / function "
Args: (number &rest more-numbers)
Divides the first NUMBER by each of the subsequent NUMBERS.
With one arg, returns the reciprocal of the number.")

(docvar / variable "
Holds a list of the values of the last top-level form.")

(docvar // variable "
Gets the previous value of / when KCL evaluates a top-level form.")

(docvar /// variable "
Gets the previous value of // when KCL evaluates a top-level form.")

(docfun /= function "
Args: (number &rest more-numbers)
Returns T if no two of its arguments are numerically equal; NIL otherwise.")

(docfun 1+ function "
Args: (number)
Returns NUMBER + 1.")

(docfun 1- function "
Args: (number)
Returns NUMBER - 1.")

(docfun < function "
Args: (number &rest more-numbers)
Returns T if its arguments are in strictly increasing order; NIL otherwise.")

(docfun <= function "
Args: (number &rest more-numbers)
Returns T if arguments are in strictly non-decreasing order; NIL otherwise.")

(docfun = function "
Args: (number &rest more-numbers)
Returns T if all of its arguments are numerically equal; NIL otherwise.")

(docfun > function "
Args: (number &rest more-numbers)
Returns T if its arguments are in strictly decreasing order; NIL otherwise.")

(docfun >= function "
Args: (number &rest more-numbers)
Returns T if arguments are in strictly non-increasing order; NIL otherwise.")

(docfun abs function "
Args: (number)
Returns the absolute value of NUMBER.")

(docfun acons function "
Args: (key datum alist)
Constructs a new alist by adding the pair (KEY . DATUM) to ALIST.")

(docfun acos function "
Args: (number)
Returns the arc cosine of NUMBER.")

(docfun acosh function "
Args: (number)
Returns the hyperbolic arc cosine of NUMBER.")

(docfun adjoin function "
Args: (item list &key (test #'eql) test-not (key #'identity))
Adds ITEM to LIST unless ITEM is already a member of LIST.")

(docfun adjust-array function "
Args: (array dimensions
       &key (element-type (array-element-type array))
            initial-element (initial-contents nil) (fill-pointer nil)
            (displaced-to nil) (displaced-index-offset 0))
Adjusts the dimensions of ARRAY to the given DIMENSIONS.  The default value
of INITIAL-ELEMENT depends on ELEMENT-TYPE.")

(docfun adjustable-array-p function "
Args: (array)
Returns T if ARRAY is adjustable; NIL otherwise.")

(docfun allocate function "
Args: (type number &optional (really-allocate nil))
KCL specific: Sets the maximum number of pages for the type class of the
KCL implementation type TYPE to NUMBER.  If REALLY-ALLOCATE is given a
non-NIL value, then the specified number of pages will be allocated
immediately.")

(docfun allocate-contiguous-pages function "
Args: (number &optional (really-allocate nil))
KCL specific: Sets the maximum number of pages for contiguous blocks to
NUMBER.  If REALLY-ALLOCATE is given a non-NIL value, then the specified
number of pages will be allocated immediately.")

(docfun allocate-relocatable-pages function "
Args: (number)
KCL specific: Sets the maximum number of pages for relocatable blocks to
NUMBER.")

(docfun allocated-contiguous-pages function "
Args: ()
KCL specific: Returns the number of pages currently allocated for contiguous
blocks.")

(docfun allocated-pages function "
Args: (type)
KCL specific: Returns the number of pages currently allocated for the type
class of the KCL implementation type TYPE.")

(docfun allocated-relocatable-pages function "
Args: ()
KCL specific: Returns the number of pages currently allocated for relocatable
blocks.")

(docfun alpha-char-p function "
Args: (char)
Returns T if CHAR is an alphabetic character, A-Z or a-z; NIL otherwise.")

(docfun alphanumericp function "
Args: (char)
Returns T if CHAR is either numeric or alphabetic; NIL otherwise.")

(docfun and macro "
Syntax: (and {form}*)
Evaluates FORMs in order from left to right.  If any FORM evaluates to NIL,
returns immediately with the value NIL.  Else, returns the value(s) of the
last FORM.")

(docfun append function "
Args: (&rest lists)
Constructs a new list by concatenating its arguments.")

(docfun apply function "
Args: (function arg &rest more-args)
Applies FUNCTION.  The arguments to the function consist of all ARGs
except for the last, and all elements of the last ARG.")

(docfun applyhook function "
Args: (function args evalhookfn applyhookfn &optional (env nil))
Applies FUNCTION to ARGS, with *EVALHOOK* bound to EVALHOOKFN and with
*APPLYHOOK* bound to APPLYHOOKFN.  Ignores the hook function once, for the
top-level application of FUNCTION to ARGS.")

(docvar *applyhook* variable "
Used to substitute another function for the implicit APPLY normally done
within EVAL.  If *APPLYHOOK* is not NIL, its value must be a function 
which takes three arguments: a function to be applied, a list of arguments,
and an environment.  This function does the application instead of APPLY.")

(docfun apropos function "
Args: (string &optional (package nil))
Prints those symbols whose print-names contain STRING as substring.
If PACKAGE is non-NIL, then only the specified package is searched.")

(docfun apropos-list function "
Args: (string &optional (package nil))
Returns, as a list, all symbols whose print-names contain STRING as substring.
If PACKAGE is non-NIL, then only the specified package is searched.")

(docfun aref function "
Args: (array &rest subscripts)
Returns the element of ARRAY specified by SUBSCRIPTS.")

(doctype array "
An array is an object with components arranged according to Cartesian
coordinate system.  Vectors are kinds of arrays.  Other arrays are called
general arrays and are denoted as
	#?a( ... )	or	#?A( ... )
where '?' is actually the rank of the array.
Some arrays may be displaced to another array, may have a fill pointer, or
may be adjusted its size.  Other arrays are called simple arrays.")

(docfun array-dimension function "
Args: (array axis-number)
Returns the length of AXIS-NUMBER of ARRAY.")

(docvar array-dimension-limit constant "
The exclusive upper bound of the array dimension.")

(docfun array-dimensions function "
Args: (array)
Returns a list whose elements are the dimensions of ARRAY")

(docfun array-element-type function "
Args: (array)
Returns the type of the elements of ARRAY")

(docfun array-has-fill-pointer-p function "
Args: (array)
Returns T if ARRAY has a fill pointer; NIL otherwise.")

(docfun array-in-bounds-p function "
Args: (array &rest subscripts)
Returns T if SUBSCRIPTS are valid subscripts for ARRAY; NIL otherwise.")

(docfun array-rank function "
Args: (array)
Returns the number of dimensions of ARRAY.")

(docvar array-rank-limit constant "
The exclusive upper bound on the rank of an array.")

(docfun array-row-major-index function "
Args: (array &rest subscripts)
Returns the index into the data vector of ARRAY for the element of ARRAY
specified by SUBSCRIPTS.")

(docfun array-total-size function "
Args: (array)
Returns the total number of elements of ARRAY.")

(docvar array-total-size-limit constant "
The exclusive upper bound on the total number of elements of an array.")

(docfun arrayp function "
Args: (x)
Returns T if X is an array; NIL otherwise.")

(docfun ash function "
Args: (integer count)
Shifts INTEGER left by COUNT places.  Shifts right if COUNT is negative.")

(docfun asin function "
Args: (number)
Returns the arc sine of NUMBER.")

(docfun asinh function "
Args: (number)
Returns the hyperbolic arc sine of NUMBER.")

(docfun assert macro "
Syntax: (assert test-form [({place}*) [string {arg}*]])
Signals an error if the value of TEST-FORM is NIL.  STRING is an format string
used as the error message.  ARGs are arguments to the format string.")

(docfun assoc function "
Args: (item alist &key (test #'eql) test-not)
Returns the first pair in ALIST whose car is equal (in the sense of TEST) to
ITEM.")

(docfun assoc-if function "
Args: (test alist)
Returns the first pair in ALIST whose car satisfies TEST.")

(docfun assoc-if-not function "
Args: (test alist)
Returns the first pair in ALIST whose car does not satisfy TEST.")

(docfun atan function "
Args: (x &optional (y 1))
Returns the arc tangent of X/Y.")

(docfun atanh function "
Args: (number)
Returns the hyperbolic arc tangent of NUMBER.")

(docfun atom function "
Args: (x)
Returns T if X is not a cons; NIL otherwise.")

(doctype bignum "
A bignum is an integer that is not a fixnum.")

(docfun bit function "
Args: (bit-array &rest subscripts)
Returns the bit from BIT-ARRAY at SUBSCRIPTS.")

(docfun bit-and function "
Args: (bit-array1 bit-array2 &optional (result-bit-array nil))
Performs a bit-wise logical AND on the elements of BIT-ARRAY1 and BIT-ARRAY2.
Puts the results into a new bit array if RESULT-BIT-ARRAY is NIL, into
BIT-ARRAY1 if RESULT-BIT-ARRAY is T, or into RESULT-BIT-ARRAY otherwise.")

(docfun bit-andc1 function "
Args: (bit-array1 bit-array2 &optional (result-bit-array nil))
Performs a bit-wise logical ANDC1 on the elements of BIT-ARRAY1 and
BIT-ARRAY2.
Puts the results into a new bit array if RESULT-BIT-ARRAY is NIL, into
BIT-ARRAY1 if RESULT-BIT-ARRAY is T, or into RESULT-BIT-ARRAY otherwise.")

(docfun bit-andc2 function "
Args: (bit-array1 bit-array2 &optional (result-bit-array nil))
Performs a bit-wise logical ANDC2 on the elements of BIT-ARRAY1 and
BIT-ARRAY2.
Puts the results into a new bit array if RESULT-BIT-ARRAY is NIL, into
BIT-ARRAY1 if RESULT-BIT-ARRAY is T, or into RESULT-BIT-ARRAY otherwise.")

(docfun bit-eqv function "
Args: (bit-array1 bit-array2 &optional (result-bit-array nil))
Performs a bit-wise logical EQV  on the elements of BIT-ARRAY1 and BIT-ARRAY2.
Puts the results into a new bit array if RESULT-BIT-ARRAY is NIL, into
BIT-ARRAY1 if RESULT-BIT-ARRAY is T, or into RESULT-BIT-ARRAY otherwise.")

(docfun bit-ior function "
Args: (bit-array1 bit-array2 &optional (result-bit-array nil))
Performs a bit-wise logical IOR on the elements of BIT-ARRAY1 and BIT-ARRAY2.
Puts the results into a new bit array if RESULT-BIT-ARRAY is NIL, into
BIT-ARRAY1 if RESULT-BIT-ARRAY is T, or into RESULT-BIT-ARRAY otherwise.")

(docfun bit-nand function "
Args: (bit-array1 bit-array2 &optional (result-bit-array nil))
Performs a bit-wise logical NAND  on the elements of BIT-ARRAY1 and
BIT-ARRAY2.
Puts the results into a new bit array if RESULT-BIT-ARRAY is NIL, into
BIT-ARRAY1 if RESULT-BIT-ARRAY is T, or into RESULT-BIT-ARRAY otherwise.")

(docfun bit-nor function "
Args: (bit-array1 bit-array2 &optional (result-bit-array nil))
Performs a bit-wise logical NOR  on the elements of BIT-ARRAY1 and BIT-ARRAY2.
Puts the results into a new bit array if RESULT-BIT-ARRAY is NIL, into
BIT-ARRAY1 if RESULT-BIT-ARRAY is T, or into RESULT-BIT-ARRAY otherwise.")

(docfun bit-not function "
Args: (bit-array &optional (result-bit-array nil))
Performs a bit-wise logical NOT in the elements of BIT-ARRAY.
Puts the results into a new bit array if RESULT-BIT-ARRAY is NIL, into
BIT-ARRAY if RESULT-BIT-ARRAY is T, or into RESULT-BIT-ARRAY otherwise.")

(docfun bit-orc1 function "
Args: (bit-array1 bit-array2 &optional (result-bit-array nil))
Performs a bit-wise logical ORC1 on the elements of BIT-ARRAY1 and BIT-ARRAY2.
Puts the results into a new bit array if RESULT-BIT-ARRAY is NIL, into
BIT-ARRAY1 if RESULT-BIT-ARRAY is T, or into RESULT-BIT-ARRAY otherwise.")

(docfun bit-orc2 function "
Args: (bit-array1 bit-array2 &optional (result-bit-array nil))
Performs a bit-wise logical ORC2 on the elements of BIT-ARRAY1 and BIT-ARRAY2.
Puts the results into a new bit array if RESULT-BIT-ARRAY is NIL, into
BIT-ARRAY1 if RESULT-BIT-ARRAY is T, or into RESULT-BIT-ARRAY otherwise.")

(doctype bit-vector "
A bit-vector is a vector of bits.  A bit-vector is denoted by '#*' followed
by the constituent bits (0 or 1).
Some bit-vectors may be displaced to another bit-vectors, may have a fill
pointer, or may be adjusted its size.  Other bit-vectors are called simple
bit-vectors.")

(docfun bit-vector-p function "
Args: (x)
Returns T if X is a bit vector; NIL otherwise.")

(docfun bit-xor function "
Args: (bit-array1 bit-array2 &optional (result-bit-array nil))
Performs a bit-wise logical XOR on the elements of BIT-ARRAY1 and BIT-ARRAY2.
Puts the results into a new bit array if RESULT-BIT-ARRAY is NIL, into
BIT-ARRAY1 if RESULT-BIT-ARRAY is T, or into RESULT-BIT-ARRAY otherwise.")

(docfun block special "
Syntax: (block name {form}*)
The FORMs are evaluated in order, but it is possible to exit the block
using (RETURN-FROM name value).  The RETURN-FROM must be lexically contained
within the block.")

(docfun boole function "
Args: (op integer1 integer2)
Returns an integer produced by performing the logical operation specified by
OP on the two integers.  OP must be the value of one of the following
constants:
	BOOLE-CLR	BOOLE-C1	BOOLE-XOR	BOOLE-ANDC1
	BOOLE-SET	BOOLE-C2	BOOLE-EQV	BOOLE-ANDC2
	BOOLE-1		BOOLE-AND	BOOLE-NAND	BOOLE-ORC1
	BOOLE-2		BOOLE-IOR	BOOLE-NOR	BOOLE-ORC2
See the variable docs of these constants for their operations.")

(docvar boole-1 constant "
Makes BOOLE return INTEGER1.")

(docvar boole-2 constant "
Makes BOOLE return INTEGER2.")

(docvar boole-and constant "
Makes BOOLE return LOGAND of INTEGER1 and INTEGER2.")

(docvar boole-andc1 constant "
Makes BOOLE return LOGANDC1 of INTEGER1 and INTEGER2.")

(docvar boole-andc2 constant "
Makes BOOLE return LOGANDC2 of INTEGER1 and INTEGER2.")

(docvar boole-c1 constant "
Makes BOOLE return the complement of INTEGER1.")

(docvar boole-c2 constant "
Makes BOOLE return the complement of INTEGER2.")

(docvar boole-clr constant "
Makes BOOLE return 0.")

(docvar boole-eqv constant "
Makes BOOLE return LOGEQV of INTEGER1 and INTEGER2.")

(docvar boole-ior constant "
Makes BOOLE return LOGIOR of INTEGER1 and INTEGER2.")

(docvar boole-nand constant "
Makes BOOLE return LOGNAND of INTEGER1 and INTEGER2.")

(docvar boole-nor constant "
Makes BOOLE return LOGNOR of INTEGER1 and INTEGER2.")

(docvar boole-orc1 constant "
Makes BOOLE return LOGORC1 of INTEGER1 and INTEGER2.")

(docvar boole-orc2 constant "
Makes BOOLE return LOGORC2 of INTEGER1 and INTEGER2.")

(docvar boole-set constant "
Makes BOOLE return -1.")

(docvar boole-xor constant "
Makes BOOLE return LOGXOR of INTEGER1 and INTEGER2.")

(docfun both-case-p function "
Args: (char)
Returns T if CHAR is an alphabetic character; NIL otherwise.  Equivalent to
ALPHA-CHAR-P.")

(docfun boundp function "
Args: (symbol)
Returns T if the global variable named by SYMBOL has a value; NIL otherwise.")

(docfun break function "
Args: (&optional (format-string nil) &rest args)
Enters a break loop.  If FORMAT-STRING is non-NIL, formats FORMAT-STRING
and ARGS to *ERROR-OUTPUT* before entering a break loop.
Typing :HELP at the break loop will list the break-loop commands.")

(docvar *break-enable* variable "
KCL specific:  When an error occurrs, control enters to the break loop only
if the value of this variable is non-NIL.")

(docvar *break-on-warnings* variable "
When the function WARN is called, control enters to the break loop only
if the value of this varialbe is non-NIL.")

(docfun butlast function "
Args: (list &optional (n 1))
Creates and returns a list with the same elements as LIST but without the
last N elements.")

(docfun by function "
Args: ()
KCL specific: Exits from KCL.")

(docfun bye function "
Args: ()
KCL specific: Exits from KCL.")

(docfun byte function "
Args: (size position)
Returns a byte specifier.  In KCL, a byte specifier is represented by
a dotted pair (<size> . <position>).")

(docfun byte-position function "
Args: (bytespec)
Returns the position part (in KCL, the cdr part) of the byte specifier.")

(docfun byte-size function "
Args: (bytespec)
Returns the size part (in KCL, the car part) of the byte specifier.")

(docfun caaaar function "
Args: (x)
Equivalent to (CAR (CAR (CAR (CAR X)))).")

(docfun caaadr function "
Args: (x)
Equivalent to (CAR (CAR (CAR (CDR X)))).")

(docfun caaar function "
Args: (x)
Equivalent to (CAR (CAR (CAR X))).")

(docfun caadar function "
Args: (x)
Equivalent to (CAR (CAR (CDR (CAR X)))).")

(docfun caaddr function "
Args: (x)
Equivalent to (CAR (CAR (CDR (CDR X)))).")

(docfun caadr function "
Args: (x)
Equivalent to (CAR (CAR (CDR X))).")

(docfun caar function "
Args: (x)
Equivalent to (CAR (CAR X)).")

(docfun cadaar function "
Args: (x)
Equivalent to (CAR (CDR (CAR (CAR X)))).")

(docfun cadadr function "
Args: (x)
Equivalent to (CAR (CDR (CAR (CDR X)))).")

(docfun cadar function "
Args: (x)
Equivalent to (CAR (CDR (CAR X))).")

(docfun caddar function "
Args: (x)
Equivalent to (CAR (CDR (CDR (CAR X)))).")

(docfun cadddr function "
Args: (x)
Equivalent to (CAR (CDR (CDR (CDR X)))).")

(docfun caddr function "
Args: (x)
Equivalent to (CAR (CDR (CDR X))).")

(docfun cadr function "
Args: (x)
Equivalent to (CAR (CDR X)).")

(docvar call-arguments-limit constant "
The upper exclusive bound on the number of arguments that may be passed to
a function.  Actually, however, there is no such upper bound in KCL.")

(docfun car function "
Args: (list)
Returns the car of LIST.  Returns NIL if LIST is NIL.")

(docfun case macro "
Syntax: (case keyform {({key | ({key}*)} {form}*)}*)
Evaluates KEYFORM and tries to find the KEY that is EQL to the value of
KEYFORM.  If one is found, then evaluates FORMs that follow the KEY and
returns the value(s) of the last FORM.  If not, simply returns NIL.")

(docfun catch special "
Syntax: (catch tag {form}*)
Sets up a catcher with that value TAG.  Then evaluates FORMs as a PROGN, but
may possibly abort the evaluation by a THROW form that specifies the value
EQ to the catcher tag.")

(docfun ccase macro "
Syntax: (ccase keyplace {({key | ({key}*)} {form}*)}*)
Evaluates KEYPLACE and tries to find the KEY that is EQL to the value of
KEYPLACE.  If one is found, then evaluates FORMs that follow the KEY and
returns the value(s) of the last FORM.  If not, signals a correctable error.")

(docfun cdaaar function "
Args: (x)
Equivalent to (CDR (CAR (CAR (CAR X)))).")

(docfun cdaadr function "
Args: (x)
Equivalent to (CDR (CAR (CAR (CDR X)))).")

(docfun cdaar function "
Args: (x)
Equivalent to (CDR (CAR (CAR X))).")

(docfun cdadar function "
Args: (x)
Equivalent to (CDR (CAR (CDR (CAR X)))).")

(docfun cdaddr function "
Args: (x)
Equivalent to (CDR (CAR (CDR (CDR X)))).")

(docfun cdadr function "
Args: (x)
Equivalent to (CDR (CAR (CDR X))).")

(docfun cdar function "
Args: (x)
Equivalent to (CDR (CAR X)).")

(docfun cddaar function "
Args: (x)
Equivalent to (CDR (CDR (CAR (CAR X)))).")

(docfun cddadr function "
Args: (x)
Equivalent to (CDR (CDR (CAR (CDR X)))).")

(docfun cddar function "
Args: (x)
Equivalent to (CDR (CDR (CAR X))).")

(docfun cdddar function "
Args: (x)
Equivalent to (CDR (CDR (CDR (CAR X)))).")

(docfun cddddr function "
Args: (x)
Equivalent to (CDR (CDR (CDR (CDR X)))).")

(docfun cdddr function "
Args: (x)
Equivalent to (CDR (CDR (CDR X))).")

(docfun cddr function "
Args: (x)
Equivalent to (CDR (CDR X)).")

(docfun cdr function "
Args: (list)
Returns the cdr of LIST.  Returns NIL if LIST is NIL.")

(docfun ceiling function "
Args: (number &optional (divisor 1))
Returns the smallest integer not less than or NUMBER/DIVISOR.  Returns the
remainder as the second value.")

(docfun cerror function "
Args: (continue-format-string error-format-string &rest args)
Signals a correctable error.")

(docfun char function "
Args: (string index)
Returns the INDEX-th character in STRING.")

(docfun char-bit function "
Args: (char name)
Returns T if the named bit is on in the character CHAR; NIL otherwise.
In KCL, this function always returns NIL.")

(docfun char-bits function "
Args: (char)
Returns the bits attribute (which is always 0 in KCL) of CHAR.")

(docvar char-bits-limit constant "
The upper exclusive bound on values produced by CHAR-BITS.")

(docfun char-code function "
Args: (char)
Returns the code attribute of CHAR.")

(docvar char-code-limit constant "
The upper exclusive bound on values produced by CHAR-CODE.")

(docvar char-control-bit constant "
The bit that indicates a control character.")

(docfun char-downcase function "
Args: (char)
Returns the lower-case equivalent of CHAR, if any.
If not, simply returns CHAR.")

(docfun char-equal function "
Args: (char &rest more-chars)
Returns T if all of its arguments are the same character; NIL otherwise.
Upper case character and its lower case equivalent are regarded the same.")

(docfun char-font function "
Args: (char)
Returns the font attribute of CHAR.")

(docvar char-font-limit constant "
The upper exclusive bound on values produced by CHAR-FONT.")

(docfun char-greaterp function "
Args: (char &rest more-chars)
Returns T if the codes of CHARs are in strictly decreasing order; NIL
otherwise.  For a lower-case character, the code of its upper-case equivalent
is used.")

(docvar char-hyper-bit constant "
The bit that indicates a hyper character.")

(docfun char-int function "
Args: (char)
Returns the font, bits, and code attributes as a single non-negative integer.
Equivalent to CHAR-CODE in KCL.")

(docfun char-lessp function "
Args: (char &rest more-chars)
Returns T if the codes of CHARs are in strictly increasing order; NIL
otherwise.  For a lower-case character, the code of its upper-case equivalent
is used.")

(docvar char-meta-bit constant "
The bit that indicates a meta character.")

(docfun char-name function "
Args: (char)
Returns the name for CHAR as a string; NIL if CHAR has no name.
Only #\\Backspace, #\\Tab, #\\Newline (or #\\Linefeed), #\\Page, #\\Return,
and #\\Rubout have names.")

(docfun char-not-equal function "
Args: (char &rest more-chars)
Returns T if no two of CHARs are the same character; NIL otherwise.
Upper case character and its lower case equivalent are regarded the same.")

(docfun char-not-greaterp function "
Args: (char &rest more-chars)
Returns T if the codes of CHARs are in strictly non-decreasing order; NIL
otherwise.  For a lower-case character, the code of its upper-case equivalent
is used.")

(docfun char-not-lessp function "
Args: (char &rest more-chars)
Returns T if the codes of CHARs are in strictly non-increasing order; NIL
otherwise.  For a lower-case character, the code of its upper-case equivalent
is used.")

(docvar char-super-bit constant "
The bit that indicates a super character.")

(docfun char-upcase function "
Args: (char)
Returns the upper-case equivalent of CHAR, if any.
If not, simply returns CHAR.")

(docfun char/= function "
Args: (char &rest more-chars)
Returns T if no two of CHARs are the same character; NIL otherwise.")

(docfun char< function "
Args: (char &rest more-chars)
Returns T if the codes of CHARs are in strictly increasing order; NIL
otherwise.")

(docfun char<= function "
Args: (char &rest more-chars)
Returns T if the codes of CHARs are in strictly non-decreasing order; NIL
otherwise.")

(docfun char= function "
Args: (char &rest more-chars)
Returns T if all CHARs are the same character; NIL otherwise.")

(docfun char> function "
Args: (char &rest more-chars)
Returns T if the codes of CHARs are in strictly decreasing order; NIL
otherwise.")

(docfun char>= function "
Args: (char &rest more-chars)
Returns T if the codes of CHARs are in strictly non-increasing order; NIL
otherwise.")

(doctype character "
A character object represents a character.  Characters have font, bits, and
code attributes.  Font and bits attributes are always 0 in KCL.  Most versions
of KCL uses ASCII code:

  000 - 037	#\\^@  #\\^A  #^B ... #\\Z  #\\^[  #\\^\\  #\\^]  #\\^^  #\\^_
		except #\\Tab(011)     #\\Newline(012)     #\\Page(014)
		       #\\Return(015)  #\\Backspace(031)
  040 - 057	#\\Space  #\\!  #\\\"  #\\#  #\\$  #\\%  #\\&  #\\'  #\\(  #\\)  #\\*
		#\\+  #\\,  #\\-  #\\.  #\\/
  060 - 071	#\\0  #\\1  #\\2  #\\3  #\\4  #\\5  #\\6  #\\7  #\\8  #\\9
  072 - 100	#\\:  #\\;  #\\<  #\\=  #\\>  #\\?  #\\@
  101 - 132	#\\A ... #\\Z
  133 - 140	#\\[  #\\\\  #\\]  #\\^  #\\_  #\\`
  141 - 172	#\\a ... #\\z
  173 - 177	#\\{  #\\|  #\\}  #\\~  #\\Rubout

Some versions of KCL support additional characters to represent Japanese
KANJI characters with.")

(docfun character function "
Args: (x)
Coerces X into a character object if possible.")

(docfun characterp function "
Args: (x)
Returns T if X is a character; NIL otherwise.")

(docfun check-type macro "
Syntax: (check-type place typespec [string])
Signals an error, if the contents of PLACE are not of the specified type.")

(docfun cis function "
Args: (radians)
Returns e raised to i*RADIANS.")

(docfun clear-input function "
Args: (&optional (stream *standard-input*))
Clears the input stream STREAM.")

(docfun clear-output function "
Args: (&optional (stream *standard-output*))
Clears the output stream STREAM.")

(docfun clines macro "
Syntax: (clines {string}*)
KCL specific:  The KCL compiler embeds STRINGs into the intermediate C
language code.  The interpreter ignores this form.")

(docfun close function "
Args: (stream &key (abort nil))
Closes STREAM.  A non-NIL value of :ABORT indicates an abnormal termination.")

(docfun clrhash function "
Args: (hash-table)
Removes all entries of HASH-TABLE and returns the hash table itself.")

(docfun code-char function "
Args: (code &optional (bits 0) (font 0))
Returns a character object with the specified code, if any.
If not, returns NIL.")

(docfun coerce function "
Args: (x type)
Coerces X to an object of the type TYPE.")

(doctype common "
COMMON is the type of all Common Lisp data types.")

(docfun commonp function "
Args: (x)
Returns T if X is a Common Lisp object; NIL otherwise.")

(docfun compile function "
Args: (name &optional (definition nil) &key (leave-gazonk nil))
If DEFINITION is NIL, NAME must be the name of a not-yet-compiled
function.  In this case, COMPILE compiles the function, installs the compiled
function as the global function definition of NAME, and returns NAME.
If DEFINITION is non-NIL, it must be a lambda expression and NAME must be
a symbol.  COMPILE compiles the lambda expression, installs the compiled
function as the function definition of NAME, and returns NAME.
There is only one exception for this:  If NAME is NIL, then the compiled
function is not installed but is simply returned as the value of COMPILE.
     In any case, COMPILE creates temporary files whose filenames are
\"gazonk***\".  By default, i.e. if :LEAVE-GAZONK is not supplied or is
NIL, these files are automatically deleted after compilation.")

(docfun compile-file function "
Args: (input-pathname
       &key output-file (load nil) (message-file nil) (verbose nil))
Compiles the file specified by INPUT-PATHNAME and generates a fasl file
specified by OUTPUT-FILE.  If the filetype is not specified in
INPUT-PATHNAME, then \".lsp\" is used as the default file type for the
source file.  :LOAD specifies whether to load the generated fasl file
after compilation.  :MESSAGE-FILE specifies the log file for the compiler
messages.  It defaults to the value of the variable COMPILER:*DEFAULT-
MESSAGE-FILE*.  A non-NIL value of :VERBOSE forces the compiler to indicate
the form currently being compiled.  More keyword parameters are accepted,
depending on the version.  Most versions of KCL can receive :O-FILE, :C-FILE,
:H-FILE, and :DATA-FILE keyword parameters, with which you can control the
intermediate files generated by the KCL compiler.  See the KCL Report
at your hand for the details.")

(doctype compiled-function "
A compiled function is a compiled code object.  A compiled function is
denoted in either of the form:
	#<compiled-function ?>
	#<compiled-closure nil>
where '?' is actually the name of the compiled-function.")

(docfun compiled-function-p function "
Args: (x)
Returns T if X is a compiled function; NIL otherwise.")

(docfun compiler-let special "
Syntax: (compiler-let ({var | (var [value])}*) {form}*)
When interpreted, this form works just like a LET form with all VARs declared
special.  When compiled, FORMs are processed with the VARs bound at compile
time, but no bindings occur when the compiled code is executed.")

(doctype complex "
A complex number consists of a real part and an imaginary part.  A complex
number is denoted as
	#c( realpart  imagpart )  or  #C( realpart  imagpart )
where realpart and imagpart are non-complex numbers.")

(docfun complex function "
Args: (realpart &optional (imagpart 0))
Returns a complex number with the given real and imaginary parts.")

(docfun complexp function "
Args: (x)
Returns T if X is a complex number; NIL otherwise.")

(docfun concatenate function "
Args: (result-type &rest sequences)
Returns a new sequence of the specified RESULT-TYPE, consisting of all
elements in SEQUENCEs.")

(docfun cond macro "
Syntax: (cond {(test {form}*)}*)
Evaluates each TEST in order until one evaluates to a non-NIL value.  Then
evaluates the associated FORMs in order and returns the value(s) of the last
FORM.  If no forms follow the TEST, then returns the value of the TEST.
Returns NIL, if all TESTs evaluate to NIL.")

(docfun conjugate function "
Args: (number)
Returns the complex conjugate of NUMBER.")

(doctype cons "
A cons is a record structure containing two components called the car and the
cdr.")

(docfun cons function "
Args: (x y)
Returns a new cons whose car and cdr are X and Y, respectively.")

(docfun consp function "
Args: (x)
Returns T if X is a cons; NIL otherwise.")

(docfun constantp function "
Args: (symbol)
Returns T if the variable named by SYMBOL is a constant; NIL otherwise.")

(docfun copy-alist function "
Args: (alist)
Returns a new copy of ALIST.")

(docfun copy-list function "
Args: (list)
Returns a new copy of LIST.")

(docfun copy-readtable function "
Args: (&optional (from-readtable *readtable*) (to-readtable nil))
Returns a copy of the readtable FROM-READTABLE.  If TO-READTABLE is non-NIL,
then copies into TO-READTABLE.  Otherwise, creates a new readtable.")

(docfun copy-seq function "
Args: (sequence)
Returns a copy of SEQUENCE.")

(docfun copy-symbol function "
Args: (symbol &optional (copy-props nil))
Returns a new uninterned symbol with the same print name as SYMBOL.
If COPY-PROPS is NIL, the function, the variable, and the property slots
of the new symbol have no value.  Otherwise, these slots are given the
values of the corresponding slots of SYMBOL.")

(docfun copy-tree function "
Args: (object)
Recursively copies conses in OBJECT and returns the result.")

(docfun cos function "
Args: (radians)
Returns the cosine of RADIANS.")

(docfun cosh function "
Args: (number)
Returns the hyperbolic cosine of NUMBER.")

(docfun count function "
Args: (item sequence
       &key (from-end nil) (test #'eql) test-not (start 0)
            (end (length sequence)) (key #'identity))
Returns the number of elements in SEQUENCE satisfying TEST with ITEM.")

(docfun count-if function "
Args: (test sequence
       &key (from-end nil) (start 0) (end (length sequence)) (key #'identity))
Returns the number of elements in SEQUENCE satisfying TEST.")

(docfun count-if-not function "
Args: (test sequence
       &key (from-end nil) (start 0) (end (length sequence)) (key #'identity))
Returns the number of elements in SEQUENCE not satisfying TEST.")

(docfun ctypecase macro "
Syntax: (ctypecase keyplace {(type {form}*)}*)
Evaluates KEYPLACE and tries to find the TYPE in which the value of KEYPLACE
belongs.  If one is found, then evaluates FORMs that follow the KEY and
returns the value(s) of the last FORM.  If not, signals a correctable error.")

(docvar *debug-io* variable "
Holds the I/O stream used by the KCL debugger.")

(docfun decf macro "
Syntax: (decf place [delta])
Subtracts the number produced by DELTA (which defaults to 1) from the number
in PLACE.")

(docfun declare special "
Syntax: (declare {decl-spec}*)
Gives a declaration.  Possible DECL-SPECs are:
  (SPECIAL {var}*)
  (TYPE type {var}*)
  (type {var}*) : where 'type' is one of the following symbols
	array		fixnum		package		simple-bit-vector
	atom		float		pathname	simple-string
	bignum		function	random-state	simple-vector
	bit		hash-table	ratio		single-float
	bit-vector	integer		rational	standard-char
	character	keyword		readtable	stream
	common		list		sequence	string
	compiled-function  long-float	short-float	string-char
	complex		nil		signed-byte	symbol
	cons		null		unsigned-byte	t
	double-float	number		simple-array	vector
  (OBJECT {var}*)
  (FTYPE type {function-name}*)
  (FUNCTION function-name ({arg-type}*) {return-type}*)
  (INLINE {function-name}*)
  (NOTINLINE {function-name}*)
  (IGNORE {var}*)
  (OPTIMIZE {({SPEED | SPACE | SAFETY | COMPILATION-SPEED} {0 | 1 | 2 | 3})}*)
  (DECLARATION {non-standard-decl-name}*).")

(docfun decode-float function "
Args: (float)
Returns, as three values, the significand F, the exponent E, and the sign S
of the given float, so that
			 E
	FLOAT = S * F * B	where B = (FLOAT-RADIX FLOAT)

S and F are floating-point numbers of the same float format as FLOAT, and E
is an integer.")

(docfun decode-universal-time function "
Args: (universal-time &optional (timezone -9))
Converts UNIVERSAL-TIME into a decoded time at the TIMEZONE.
Returns nine values: second, minute, hour, date, month (1 - 12), year,
day-of-week (0 - 6), daylight-saving-time-p, and time-zone.
TIMEZONE in KCL defaults to -9, the time zone of Japan.")

(docvar *default-pathname-defaults* variable "
The default pathname-defaults pathname.")

(docfun defcfun macro "
Syntax: (defcfun header n {element}*)
KCL specific: Defines a C-language function which calls Lisp functions and/or
handles Lisp objects.  HEADER gives the header of the C function as a string.
N is the number of the main stack entries used by the C function, primarily
for protecting Lisp objects from being garbage-collected.  Each ELEMENT may
give a C code fragment as a string, or it may be a list
	((symbol {arg}*) {place}*)
which, when executed, calls the Lisp function named by SYMBOL with the
specified arguments and saves the value(s) to the specified places.
The DEFCFUN form has the above meanings only after compiled;  The KCL
interpreter simply ignores this form.")

(docfun defconstant macro "
Syntax: (defconstant name initial-value [doc])
Declares that the variable NAME is a constant whose value is the value of
INITIAL-VALUE.  The doc-string DOC, if supplied, is saved as a VARIABLE doc
and can be retrieved by (documentation 'NAME 'variable).")

(docfun defentry macro "
Syntax: (defentry name lambda-list C-function)
KCL specific:  The compiler defines a Lisp function whose body consists of
a calling sequence to the C language function specified by C-FUNCTION.  The
interpreter ignores this form.  See the doc of DEFUN for the complete syntax
of a lambda-list.")

(docfun define-modify-macro macro "
Syntax: (define-modify-macro name lambda-list fun [doc])
Defines a read-modify-write macro, like PUSH and INCF.  The defined macro will
expand a form (NAME place val1 ... valn) into a form that in effect SETFs the
value of the call (FUN PLACE arg1 ... argm) into PLACE, where arg1 ... argm
are parameters in LAMBDA-LIST which are bound to the forms VAL1 ... VALn.
The doc-string DOC, if supplied, is saved as a FUNCTION doc and can be
retrieved by (documentation 'NAME 'function).")

(docfun define-setf-method macro "
Syntax: (define-setf-method access-fun defmacro-lambda-list {decl | doc}*
          {form}*)
Defines how to SETF a generalized-variable reference of the form
(ACCESS-FUN ...).  When a form (setf (ACCESS-FUN arg1 ... argn) value) is
being evaluated, the FORMs are first evaluated as a PROGN with the parameters
in DEFMACRO-LAMBDA-LIST bound to ARG1 ... ARGn.  Assuming that the last FORM
returns five values
	(temp-var-1 ... temp-var-k)
	(value-from-1 ... value-form-k)
	(store-var)
	storing-form
	access-form
in order, the whole SETF is then expanded into
	(let* ((temp-var-1 value-from-1) ... (temp-k value-form-k)
	       (store-var VALUE))
	  storing-from)
Incidentally, the five values are called the five gangs of a SETF method.
The doc-string DOC, if supplied, is saved as a SETF doc and can be retrieved
by (documentation 'NAME 'setf).")

(docfun defla macro "
Syntax: (defla name lambda-list {decl | doc}* {form}*)
KCL specific: Used to DEFine Lisp Alternative.  For the interpreter, DEFLA is
equivalent to DEFUN, but the compiler ignores this form.")

(docfun defmacro macro "
Syntax: (defmacro name defmacro-lambda-list {decl | doc}* {form}*)
Defines a macro as the global macro definition of the symbol NAME.
The complete syntax of a defmacro-lambda-list is:

( [&whole var]
  [&environment var]
  {pseudo-var}*
  [&optional {var | (pseudo-var [initform [pseudo-var]])}*]
  {[{&rest | &body} pseudo-var]
   [&key {var | ({var | (keyword pseudo-var)} [initform [pseudo-var]])}*
         [&allow-other-keys]]
   [&aux {var | (pseudo-var [initform])}*]
  |  . var})

where pseudo-var is either a symbol or a list of the following form:

( {pseudo-var}*
  [&optional {var | (pseudo-var [initform [pseudo-var]])}*]
  {[{&rest | &body} pseudo-var]
   [&key {var | ({var | (keyword pseudo-var)} [initform [pseudo-var]])}*
         [ &allow-other-keys ] ]
   [&aux {var | (pseudo-var [initform])}*]
  |  . var})

As a special case, a non-NIL symbol is accepcted as a defmacro-lambda-list:
(DEFMACRO <name> <symbol> ...) is equivalent to
(DEFMACRO <name> (&REST <symbol>) ...).
     The doc-string DOC, if supplied, is saved as a FUNCTION doc and can be
retrieved by (documentation 'NAME 'function).
See the type doc of LIST for the backquote macro useful for defining macros.
Also, see the function doc of PPRINT for the output-formatting.")

(docfun defparameter macro "
Syntax: (defparameter name initial-value [doc])
Declares the variable NAME as a special variable and initializes the value.
The doc-string DOC, if supplied, is saved as a VARIABLE doc and can be
retrieved by (documentation 'NAME 'variable).")

(docfun defsetf macro "
Syntax: (defsetf access-fun {update-fun [doc] |
                             lambda-list (store-var) {decl | doc}* {form}*)
Defines how to SETF a generalized-variable reference of the form
(ACCESS-FUN ...).  The doc-string DOC, if supplied, is saved as a SETF doc and
can be retrieved by (documentation 'NAME 'setf).

(defsetf access-fun update-fun) defines an expansion from
(setf (ACCESS-FUN arg1 ... argn) value) to (UPDATE-FUN arg1 ... argn value).

(defsetf access-fun lambda-list (store-var) . body) defines a macro which
expands (setf (ACCESS-FUN arg1 ... argn) value) into the form
	(let* ((temp1 ARG1) ... (tempn ARGn) (temp0 value)) rest)
where REST is the value of BODY with parameters in LAMBDA-LIST bound to the
symbols TEMP1 ... TEMPn and with STORE-VAR bound to the symbol TEMP0.")

(docfun defstruct macro "
Syntax: (defstruct
         {name | (name {:conc-name | (:conc-name prefix-string) |
                        :constructor | (:constructor symbol [lambda-list]) |
                        :copier | (:copier symbol) |
                        :predicate | (:predicate symbol) | 
                        (:include symbol) |
                        (:print-function function) |
                        (:type {vector | (vector type) | list}) |
                        :named |
                        (:initial-offset number)}*)}
         [doc]
         {slot-name |
          (slot-name [default-value-form] {:type type | :read-only flag}*) }*
         )
Defines a structure.  The doc-string DOC, if supplied, is saved as a STRUCTURE
doc and can be retrieved by (documentation 'NAME 'structure).")

(docfun deftype macro "
Syntax: (deftype name lambda-list {decl | doc}* {form}*)
Defines a new type-specifier abbreviation in terms of an 'expansion' function
	(lambda lambda-list1 {decl}* {form}*)
where lambda-list1 is identical to LAMBDA-LIST except that all optional
parameters with no default value specified in LAMBDA-LIST defaults to the
symbol '*', but not to NIL.  When the type system of KCL encounters a
type specifier (NAME arg1 ... argn), it calls the expansion function with
the arguments arg1 ... argn, and uses the returned value instead of the
original type specifier.  When the symbol NAME is used as a type specifier,
the expansion function is called with no argument.  The doc-string DOC, if
supplied, is saved as the TYPE doc of NAME, and is retrieved by
(documentation 'NAME 'type).")

(docfun defun macro "
Syntax: (defun name lambda-list {decl | doc}* {form}*)
Defines a function as the global function definition of the symbol NAME.
The complete syntax of a lambda-list is:
	({var}*
	 [&optional {var | (var [initform [svar]])}*]
	 [&rest var]
	 [&key {var | ({var | (keyword var)} [initform [svar]])}*
	       [&allow-other-keys]]
	 [&aux {var | (var [initform])}*])
The doc-string DOC, if supplied, is saved as a FUNCTION doc and can be
retrieved by (documentation 'NAME 'function).")

(docfun defvar macro "
Syntax: (defvar name [initial-value [doc]])
Declares the variable NAME as a special variable and, optionally, initializes
it.  The doc-string DOC, if supplied, is saved as a VARIABLE doc and can be
retrieved by (documentation 'NAME 'variable).")

(docfun delete function "
Args: (item sequence
       &key (from-end nil) (test #'eql) test-not (start 0)
            (end (length sequence)) (count most-positive-fixnum)
            (key #'identity))
Returns a sequence formed by removing the specified ITEM destructively from
SEQUENCE.")

(docfun delete-duplicates function "
Args: (sequence &key (from-end nil) (test #'eql) test-not (start 0)
                     (end (length sequence)) (key #'identity))
Returns a sequence formed by removing duplicated elements destructively from
SEQUENCE.")

(docfun delete-file function "
Args: (file)
Deletes FILE.")

(docfun delete-if function "
Args: (test sequence
       &key (from-end nil) (start 0) (end (length sequence))
            (count most-positive-fixnum) (key #'identity))
Returns a sequence formed by removing the elements satisfying TEST
destructively from SEQUENCE.")

(docfun delete-if-not function "
Args: (test sequence
       &key (from-end nil) (start 0) (end (length sequence))
            (count most-positive-fixnum) (key #'identity))
Returns a sequence formed by destructively removing the elements not
satisfying TEST from SEQUENCE.")

(docfun denominator function "
Args: (rational)
Returns the denominator of RATIONAL as an integer.")

(docfun deposit-field function "
Args: (newbyte bytespec integer)
Returns an integer computed by replacing the specified byte of INTEGER with
the specified byte of NEWBYTE.")

(docfun describe function "
Args: (x)
Prints a description of the object X.")

(docfun digit-char function "
Args: (digit &optional (radix 10) (font 0))
Returns a character object that represents the DIGIT in the specified RADIX.
Returns NIL if no such character exists.")

(docfun digit-char-p function "
Args: (char &optional (radix 10))
If CHAR represents a digit in RADIX, then returns the weight as an integer.
Otherwise, returns nil.")

(docfun directory function "
Args: (name)
Returns a list of files that match NAME.  NAME may be a string, a pathname,
or a file stream.")

(docfun directory-namestring function "
Args: (pathname)
Returns the directory part of PATHNAME as a string.")

(docfun disassemble function "
Args: (&optional (thing nil) &key (h-file nil) (data-file nil))
Compiles the form specified by THING and prints the intermediate C language
code for that form.  But does NOT install the result of compilation.
If THING is NIL, then the previously disassembled form is re-disassembled.
If THING is a symbol that names a not-yet-compiled function, the function
definition is disassembled.
If THING is a lambda expression, it is disassembled as a function definition.
Otherwise, THING itself is disassembled as a top-level form.")

(docfun do macro "
Syntax: (do ({(var [init [step]])}*) (endtest {result}*)
          {decl}* {tag | statement}*)
Creates a NIL block, binds each VAR to the value of the corresponding INIT,
and then executes STATEMENTs repeatedly until ENDTEST is satisfied.  After
each iteration, assigns to each VAR the value of the corresponding STEP.  When
ENDTEST is satisfied, evaluates RESULTs as a PROGN and returns the value(s) of
the last RESULT (or NIL if no RESULTs are supplied).  Performs variable
bindings and assignments all at once, just like LET and PSETQ do.")

(docfun do* macro "
Syntax: (do* ({(var [init [step]])}*) (endtest {result}*)
          {decl}* {tag | statement}*)
Just like DO, but performs variable bindings and assignments in serial, just
like LET* and SETQ do.")

(docfun do-all-symbols macro "
Syntax: (do-all-symbols (var [result-form]) {decl}* {tag | statement}*)
Executes STATEMENTs once for each symbol in each package, with VAR bound to
the current symbol.  Then evaluates RESULT-FORM (which defaults to NIL) and
returns the value(s).")

(docfun do-external-symbols macro "
Syntax: (do-external-symbols (var [package [result-form]])
          {decl}* {tag | statement}*)
Executes STATEMENTs once for each external symbol in the PACKAGE (which
defaults to the current package), with VAR bound to the current symbol.
Then evaluates RESULT-FORM (which defaults to NIL) and returns the value(s).")

(docfun do-symbols macro "
Syntax: (do-symbols (var [package [result-form]]) {decl}* {tag | statement}*)
Executes STATEMENTs once for each symbol in the PACKAGE (which defaults to
the current package), with VAR bound to the current symbol.  Then evaluates
RESULT-FORM (which defaults to NIL) and returns the value(s).")

(docfun documentation function "
Args: (symbol doc-type)
Returns the doc-string of DOC-TYPE for SYMBOL; NIL if none exists.
Possible doc-types are:
	FUNCTION  (special forms, macros, and functions)
	VARIABLE  (dynamic variables, including constants)
	TYPE      (types defined by DEFTYPE)
	STRUCTURE (structures defined by DEFSTRUCT)
	SETF      (SETF methods defined by DEFSETF, DEFINE-SETF-METHOD, and
	           DEFINE-MODIFY-MACRO)
All built-in special forms, macros, functions, and variables have their
doc-strings.")

(docfun dolist macro "
Syntax: (dolist (var listform [result]) {decl}* {tag | statement}*)
Executes STATEMENTs, with VAR bound to each member of the list value of
LISTFORM.  Then returns the value(s) of RESULT (which defaults to NIL).")

(docfun dotimes macro "
Syntax: (dotimes (var countform [result]) {decl}* {tag | statement}*)
Executes STATEMENTs, with VAR bound to each number between 0 (inclusive) and
the value of COUNTFORM (exclusive).  Then returns the value(s) of RESULT
(which defaults to NIL).")

(docvar double-float-epsilon constant "
Same as LONG-FLOAT-EPSILON.")

(docvar double-float-negative-epsilon constant "
Same as LONG-FLOAT-NEGATIVE-EPSILON.")

(docfun dpb function "
Args: (newbyte bytespec integer)
Returns an integer computed by replacing the specified byte of INTEGER with
NEWBYTE.")

(docfun dribble function "
Args: (&optional pathname)
If PATHNAME is given, begins to record the interaction to the specified file.
If PATHNAME is not given, ends the recording.")

(docfun ecase macro "
Syntax: (ecase keyform {({key | ({key}*)} {form}*)}*)
Evaluates KEYFORM and tries to find the KEY that is EQL to the value of
KEYFORM.  If one is found, then evaluates FORMs that follow the KEY and
returns the value(s) of the last FORM.  If not, signals an error.")

(docfun ed function "
Args: (&optional x)
Invokes the editor.  The action depends on the version of KCL.  See the
KCL Report for details.")

(docfun eighth function "
Args: (x)
Equivalent to (CADDDR (CDDDDR X)).")

(docfun elt function "
Args: (sequence index)
Returns the INDEX-th element of SEQUENCE.")

(docfun encode-universal-time function "
Args: (second minute hour date month year &optional (timezone -9))
Does the inverse operation of DECODE-UNIVERSAL-TIME.")

(docfun endp function "
Args: (x)
Returns T if X is NIL.  Returns NIL if X is a cons.  Otherwise, signals an
error.")

(docfun enough-namestring function "
Args: (pathname &optional (defaults *default-pathname-defaults*))
Returns a string which uniquely identifies PATHNAME with respect to
DEFAULTS.")

(docfun eq function "
Args: (x y)
Returns T if X and Y are the same identical object; NIL otherwise.")

(docfun eql function "
Args: (x y)
Returns T if X and Y are EQ, or if they are numbers of the same type with
the same value, or if they are character objects that represent the same
character.  Returns NIL otherwise.")

(docfun equal function "
Args: (x y)
Returns T if X and Y are EQL or if they are of the same type and corresponding
components are EQUAL.  Returns NIL otherwise.  Strings and bit-vectors are
EQUAL if they are the same length and have identical components.  Other
arrays must be EQ to be EQUAL.")

(docfun equalp function "
Args: (x y)
Returns T if X and Y are EQUAL, if they are characters and satisfy CHAR-EQUAL,
if they are numbers and have the same numerical value, or if they have
components that are all EQUALP.  Returns NIL otherwise.")

(docfun error function "
Args: (control-string &rest args)
Signals a fatal error.")

(docvar *error-output* variable "
Holds the output stream for error messages.")

(docfun etypecase macro "
Syntax: (etypecase keyform {(type {form}*)}*)
Evaluates KEYFORM and tries to find the TYPE in which the value of KEYFORM
belongs.  If one is found, then evaluates FORMs that follow the KEY and
returns the value(s) of the last FORM.  If not, signals an error.")

(docfun eval function "
Args: (exp)
Evaluates EXP and returns the result(s).")

(docfun eval-when special "
Syntax: (eval-when ({situation}*) {form}*)
A situation must be either COMPILE, LOAD, or EVAL.  The interpreter evaluates
only when EVAL is specified.  If COMPILE is specified, FORMs are evaluated
at compile time.  If LOAD is specified, the compiler arranges so that FORMs
be evaluated when the compiled code is loaded.")

(docvar *eval-when-compile* variable "
KCL specific: Tells the KCL compiler whether (non-NIL) or not (NIL) the
compiler should process top-level forms in compile-time-too mode.")

(docfun evalhook function "
Args: (form evalhookfn applyhookfn &optional (env nil))
Evaluates FORM with *EVALHOOK* bound to EVALHOOKFN and *APPLYHOOK* bound
to APPLYHOOKFN.  Ignores these hooks once, for the top-level evaluation
of FORM.")

(docvar *evalhook* variable "
If *EVALHOOK* is not NIL, its value must be a function that can receive
two arguments: a form to evaluate and an environment.  This function does
the evaluation instead of EVAL.")

(docfun evenp function "
Args: (integer)
Returns T if INTEGER is even.  Returns NIL if INTEGER is odd.")

(docfun every function "
Args: (predicate sequence &rest more-sequences)
Returns T if every elements of SEQUENCEs satisfy PREDICATE; NIL otherwise.")

(docfun exp function "
Args: (number)
Calculates e raised to the power NUMBER, where e is the base of natural
logarithms.")

(docfun export function "
Args: (symbols &optional (package *package*))
Makes SYMBOLS external symbols of PACKAGE.  SYMBOLS must be a list of symbols
or a symbol.")

(docfun expt function "
Args: (base-number power-number)
Returns BASE-NUMBER raised to the power POWER-NUMBER.")

(docfun fboundp function "
Args: (symbol)
Returns T if SYMBOL has a global function definition or if SYMBOL names a
special form or a macro; NIL otherwise.")

(docfun fceiling function "
Args: (number &optional (divisor 1))
Same as CEILING, but returns a float as the first value.")

(docvar *features* variable "
List of symbols that name features of the current version of KCL.
These features are used to decide the read-time conditionalization facility
provided by '#+' and '#-' read macros.  When the KCL reader encounters
	#+ feature-description form
it reads FORM in the usual manner if FEATURE-DESCRIPTION is true.  Otherwise,
the reader just skips FORM.
	#- feature-description form
is equivalent to
	#- (not feature-description) form
A feature-description may be a symbol, which is true only when it is an
element of *FEATURES*.  Or else, it must be one of the following:
	(and feature-desciption-1 ... feature-desciption-n)
	(or  feature-desciption-1 ... feature-desciption-n)
	(not feature-desciption)
The AND description is true only when all of its sub-descriptions are true.
The OR description is true only when at least one of its sub-descriptions is
true.  The NOT description is true only when its sub-description is false.")

(docfun ffloor function "
Args: (number &optional (divisor 1))
Same as FLOOR, but returns a float as the first value.")

(docfun fifth function "
Args: (x)
Equivalent to (CAR (CDDDDR X)).")

(docfun file-author function "
Args: (file)
Returns the author name of the specified file, as a string.
FILE may be a string or a stream")

(docfun file-length function "
Args: (file-stream)
Returns the length of the specified file stream.")

(docfun file-namestring function "
Args: (pathname)
Returns the written representation of PATHNAME as a string.")

(docfun file-position function "
Args: (file-stream &optional position)
Sets the file pointer of the specified file to POSITION, if POSITION is given.
Otherwise, returns the current file position of the specified file.")

(docfun file-write-date function "
Args: (file)
Returns the time at which the specified file is written, as an integer in
universal time format.  FILE may be a string or a stream.")

(docfun fill function "
Args: (sequence item &key (start 0) (end (length sequence)))
Replaces the specified elements of SEQUENCE all with ITEM.")

(docfun fill-pointer function "
Args: (vector)
Returns the fill pointer of VECTOR.")

(docfun find function "
Args: (item sequence
       &key (from-end nil) (test #'eql) test-not (start 0)
            (end (length sequence)) (key #'identity))
Returns the first element in SEQUENCE satisfying TEST with ITEM; NIL if no
such element exists.")

(docfun find-all-symbols function "
Args: (string-or-symbol)
Returns a list of all symbols that have the specified name.")

(docfun find-if function "
Args: (test sequence
       &key (from-end nil) (start 0) (end (length sequence)) (key #'identity))
Returns the index of the first element in SEQUENCE that satisfies TEST; NIL if
no such element exists.")

(docfun find-if-not function "
Args: (test sequence
       &key (from-end nil) (start 0) (end (length sequence)) (key #'identity))
Returns the index of the first element in SEQUENCE that does not satisfy
TEST; NIL if no such element exists.")

(docfun find-package function "
Args: (name)
Returns the specified package if it already exists; NIL otherwise.  NAME may
be a string that is the name or nickname of the package.  NAME may also be
a symbol, in which case the symbol's print name is used.")

(docfun find-symbol function "
Args: (name &optional (package *package*))
Returns the symbol named NAME in PACKAGE.  If such a symbol is found, then
the second value is :INTERN, :EXTERNAL, or :INHERITED to indicate how the
symbol is accessible.  If no symbol is found then both values are NIL.")

(docfun finish-output function "
Args: (&optional (stream *standard-output*))
Attempts to ensure that all output sent to STREAM has reached its destination,
and only then returns.")

(docfun first function "
Args: (x)
Equivalent to (CAR X).")

(doctype fixnum "
A fixnum is an integer between MOST-NEGATIVE-FIXNUM (= -2147483648) and
MOST-POSITIVE-FIXNUM (= 2147483647), inclusive.  Other integers are bignums.")

(docfun flet special "
Syntax: (flet ({(name lambda-list {decl | doc}* {form}*)}*) . body)
Evaluates BODY as a PROGN, with local function definitions in effect.  BODY is
the scope of each local function definition.  Since the scope does not include
the function definitions themselves, the local function can reference
externally defined functions of the same name.  See the doc of DEFUN for the
complete syntax of a lambda-list.  Doc-strings for local functions are simply
ignored.")

(doctype float "
KCL supports two formats for floating-point numbers.  One format is called
SHORT-FLOAT and the other format is called SINGLE-FLOAT, DOUBLE-FLOAT, or
LONG-FLOAT.  Precisions and exponent sizes of floating-point numbers depends
on the version of KCL.  See the KCL Report at your hand for details.
The following syntax is used to denote a floating-point number.
	{ [sign] {radix-10-digit}* decimal-point {radix-10-digit}+ [exponent]
	| [sign] {radix-10-digit}+ [decimal-point {radix-10-digit}*}] exponent
	}
where EXPONENT is
	{ e | s | f | d | l | E | S | F | D | L } [sign] {radix-10-digit}+
See the type doc of INTEGER for the syntactic variables used here.  The
exponent markers in EXPONENT have the following interpretations.
	e or E	floating-point number in the default float format
	s or S	short-float
	f or F	single-float
	d or D	double-float
	l or L	long-float
The default float format is single-float normally, but may be any other float
format.  See the variable doc of *READ-DEFAULT-FLOAT-FORMAT*.")

(docfun float function "
Args: (number &optional other)
Converts a non-complex number to a floating-point number.  If NUMBER is
already a float, FLOAT simply returns NUMBER.  Otherwise, the format of
the returned float depends on OTHER;  If OTHER is not provided, FLOAT returns
a SINGLE-FLOAT.  If OTHER is provided, the result is in the same float format
as OTHER's.")

(docfun float-digits function "
Args: (float)
Returns the number of radix-B digits used to represent the significand F of
the floating-point number, where B = (FLOAT-RADIX FLOAT).")

(docfun float-precision function "
Args: (float)
Returns the number of significant radix-B digits used to represent the
significand F of the floating-point number, where B = (FLOAT-RADIX FLOAT).")

(docfun float-radix function "
Args: (float)
Returns the representation radix (or base) of the floating-point number.")

(docfun float-sign function "
Args: (float1 &optional (float2 (float 1 float1)))
Returns a floating-point number with the same sign as FLOAT1 and with the
same absolute value as FLOAT2.")

(docfun floatp function "
Args: (x)
Returns T if X is a floating-point number; NIL otherwise.")

;;; here

(docfun floor function "
Args: (number &optional (divisor 1))
Returns the largest integer not larger than the NUMBER divided by DIVISOR.
The second returned value is (- NUMBER (* first-value DIVISOR)).")

(docfun fmakunbound function "
Args: (symbol)
Discards the global function definition named by SYMBOL.  Returns SYMBOL.")

(docfun force-output function "
Args: (&optional (stream *standard-output*))
Attempts to force any buffered output to be sent.")

(docfun format function "
Args: (destination control-string &rest arguments)
Provides various facilities for formatting output.  CONTROL-STRING is a string
to be output, possibly with embedded formatting directives, which are flagged
with the escape character \"~\".  Directives generally expand into additional
text to be output, usually consuming one or more of ARGUMENTs in the process.
A few useful directives are:

~A, ~nA, ~n@A	Prints one argument as if by PRINC
~S, ~nS, ~n@S	Prints one argument as if by PRIN1
~D, ~B, ~O, ~X	Prints one integer in decimal, binary, octal, and hexa
~%		Does TERPRI
~&		Does FRESH-LINE

where n is the minimal width of the field in which the object is printed.
~nA and ~nS put padding spaces on the right; ~n@A and ~n@S put on the left.

DESTINATION controls where the result will go.  If DESTINATION is T, then
the output is sent to the standard output stream.  If it is NIL, then the
output is returned in a string as the value of the call.  Otherwise,
DESTINATION must be a stream to which the output will be sent.")

(docfun fourth function "
Args: (x)
Equivalent to (CADDDR X).")

(docfun fresh-line function "
Args: (&optional (stream *standard-output*))
Outputs a newline if it is not positioned at the beginning of a line.  Returns
T if it output a newline; NIL otherwise.")

(docfun fround function "
Args: (number &optional (divisor 1))
Same as ROUND, but returns first value as a float.")

(docfun ftruncate function "
Args: (number &optional (divisor 1))
Same as TRUNCATE, but returns first value as a float.")

(docfun funcall function "
Args: (function &rest arguments)
Applies FUNCTION to the ARGUMENTs")

(doctype function "
A function is anything that may be correctly given to the FUNCALL or APPLY
function, and is to be executed as code when arguments are supplied.
A function is either:
	* a compiled function (compiled-function or compiled-closure)
	* a list in one of the following format.
	   (lambda lambda-list . body)
	   (lambda-block block-name lambda-list . body)
	   (lambda-closure env1 env2 env3 lambda-list . body)
	   (lambda-block-closure env1 env2 env3 block-name lambda-list . body)
	 where env1, env2, and env3 respectively represent the variable
	 environment, the function/macro environment, and the block/tagbody
	 environment at the time of the function creation.
	* a symbol that names a function.
See the doc of DEFUN for the complete syntax of a lambda-list.")

(docfun function special "
Syntax: (function x) or #'x
If X is a lambda expression, creates and returns a lexical closure of X in
the current lexical environment.  If X is a symbol that names a function,
returns that function.")

(docfun functionp function "
Args: (x)
Returns T if X is a function, suitable for use by FUNCALL or APPLY.  Returns
NIL otherwise.")

(docfun gbc function "
Args: (x)
KCL specific: Invokes the garbage collector (GC) with the collection level
specified by X.  NIL as the argument causes GC to collect cells only.  T as
the argument causes GC to collect everything.")

(docfun gcd function "
Args: (&rest integers)
Returns the greatest common divisor of INTEGERs.")

(docfun gensym function "
Args: (&optional (x nil))
Creates and returns a new uninterned symbol whose name is a prefix string
(defaults to \"G\"), followed by a decimal number.  The number is incremented
by each call to GENSYM.  X, if an integer, resets the counter.  If X is a
string, it becomes the new prefix.")

(docfun gentemp function "
Args: (&optional (prefix \"t\") (package *package*))
Creates a new symbol interned in the package PACKAGE with the given PREFIX.")

(docfun get function "
Args: (symbol indicator &optional (default nil))
Looks on the property list of SYMBOL for the specified INDICATOR.  If this
is found, returns the associated value.  Otherwise, returns DEFAULT.")

(docfun get-decoded-time function "
Args: ()
Returns the current time in decoded time format.  Returns nine values: second,
minute, hour, date, month, year, day-of-week, daylight-saving-time-p, and
time-zone.")

(docfun get-dispatch-macro-character function "
Args: (disp-char sub-char &optional (readtable *readtable*))
Returns the macro-character function for SUB-CHAR under DISP-CHAR.")

(docfun get-internal-real-time function "
Args: ()
Returns the real time in the internal time format.  This is useful for
finding elapsed time.")

(docfun get-internal-run-time function "
Args: ()
Returns the run time in the internal time format.  This is useful for
finding CPU usage.")

(docfun get-macro-character function "
Args: (char &optional (readtable *readtable*))
Returns the function associated with CHAR and, as a second value, returns
the non-terminating-p flag.")

(docfun get-output-stream-string function "
Args: (stream)
Returns a string of all the characters sent to STREAM made by
MAKE-STRING-OUTPUT-STREAM since the last call to this function.")

(docfun get-properties function "
Args: (place indicator-list)
Looks for the elements of INDICATOR-LIST in the property list stored in PLACE.
If found, returns the indicator, the value, and T as multiple-values.  If not,
returns NILs as its three values.")

(docfun get-setf-method function "
Args: (form)
Returns the five values (or five 'gangs') constituting the SETF method for
FORM.  See the doc of DEFINE-SETF-METHOD for the meanings of the gangs.  It
is an error if the third value (i.e., the list of store variables) is not a
one-element list.  See the doc of GET-SETF-METHOD-MULTIPLE-VALUE for
comparison.")

(docfun get-setf-method-multiple-value function "
Args: (form)
Returns the five values (or five 'gangs') constituting the SETF method for
FORM.  See the doc of DEFINE-SETF-METHOD for the meanings of the gangs.  The
third value (i.e., the list of store variables) may consist of any number of
elements.  See the doc of GET-SETF-METHOD for comparison.")

(docfun get-universal-time function "
Args: ()
Returns the current time as a single integer in universal time format.")

(docfun getf function "
Args: (place indicator &optional (default nil))
Searches the property list stored in Place for an indicator EQ to Indicator.
If one is found, the corresponding value is returned, else the Default is
returned.")

(docfun gethash function "
Args: (key hash-table &optional (default nil))
Finds the entry in HASH-TABLE whose key is KEY and returns the associated
value and T, as multiple values.  Returns DEFAULT and NIL if there is no
such entry.")

(docfun go special "
Syntax: (go tag)
Jumps to the specified TAG established by a lexically surrounding TAGBODY.")

(docfun graphic-char-p function "
Args: (char)
Returns T if CHAR is a printing character, i.e., #\\Space through #\\~;
NIL otherwise.")

(doctype hash-table "
Hash tables provide an efficient way of mapping any Lisp object to an
associated object.
A hash table is denoted as #<a hash-table>.")

(docfun hash-table-count function "
Args: (hash-table)
Returns the number of entries in the given Hash-Table.")

(docfun hash-table-p function "
Args: (x)
Returns T if X is a hash table object; NIL otherwise.")

(docfun help function "
Args: (&optional symbol)
KCL specific: Prints the documentation associated with SYMBOL.  With no
argument, this function prints the greeting message to KCL beginners.")

(docfun help* function "
Args: (string &optional (package 'lisp))
KCL specific: Prints the documentation associated with those symbols in the
specified package whose print names contain STRING as substring.  STRING may
be a symbol, in which case the print-name of that symbol is used.  If PACKAGE
is NIL, then all packages are searched.")

(docfun host-namestring function "
Args: (pathname)
Returns the host part of PATHNAME as a string.")

(docfun identity function "
Args: (x)
Simply returns X.")

(docfun if special "
Syntax: (if test then [else])
If TEST evaluates to non-NIL, then evaluates THEN and returns the result.
If not, evaluates ELSE (which defaults to NIL) and returns the result.")

(docvar *ignore-maximum-pages* variable "
KCL specific: Tells the KCL memory manager whether (non-NIL) or not (NIL) it
should expand memory whenever the maximum allocatable pages have been used
up.")

(docfun imagpart function "
Args: (number)
Extracts the imaginary part of NUMBER.")

(docfun import function "
Args: (symbols &optional (package *package*))
Makes SYMBOLS internal symbols of PACKAGE.  SYMBOLS must be a list of symbols
or a symbol.")

(docfun in-package function "
Args: (package-name &key (nicknames nil) (use '(lisp)))
Sets *PACKAGE* to the package with PACKAGE-NAME, creating the package if
it does not exist.  If the package already exists then it is modified
to agree with USE and NICKNAMES arguments.  Any new nicknames are added
without removing any old ones not specified.  If any package in the USE list
is not currently used, then it is added to the use list.")

(docfun incf macro "
Syntax: (incf place [delta])
Adds the number produced by DELTA (which defaults to 1) to the number
in PLACE.")

(docfun input-stream-p function "
Args: (stream)
Returns non-NIL if STREAM can handle input operations; NIL otherwise.")

(docfun inspect function "
Args: (x)
Shows the information about the object X in an interactive manner")

(docfun int-char function "
Args: (integer)
Performs the inverse of CHAR-INT.  Equivalent to CODE-CHAR in KCL.")

(doctype integer "
An integer represents a mathematical integer.  An integer may be a fixnum, or
else it is a bignum.  Normally, the following syntax is used to denote an
integer:
	{ [sign]{digit-in-default-radix}+
	  | {#b | #B} [sign] {radix-2-digit}+
	  | {#o | #O} [sign] {radix-8-digit}+
	  | [sign] {radix-10-digit}+ decimal-point
	  | {#x | #X} [sign] {radix-16-digit}+
	  | {#2r | #2R} [sign] {radix-2-digit}+
	  ....
	  | {#36r | #36R} [sign] {radix-36-digit}+  }
where SIGN is either '+' or '-', DECIMAL-POINT is '.', and
	digit-in-radix-2 ::= { 0 | 1 }
	...
	digit-in-radix-10 ::= { 0 | 1 | ... | 9 }
	digit-in-radix-11 ::= { 0 | 1 | ... | 9 | a | A }
	...
	digit-in-radix-36 ::= { 0 | 1 | ... | 9 | a | ... | z | A | ... | Z }
The default radix is 10 normally, but may be any integer between 2 and 36
inclusive.  See the variable docs of *PRINT-RADIX* and *READ-BASE*.")

(docfun integer-decode-float function "
Args: (float)
Returns, as three values, the integer interpretation of significand F,
the exponent E, and the sign S of the given float, so that
			 E
	FLOAT = S * F * B	where B = (FLOAT-RADIX FLOAT)

F is a non-negative integer, E is an integer, and S is either 1 or -1.")

(docfun integer-length function "
Args: (integer)
Returns the number of significant bits in the absolute value of INTEGER.")

(docfun integerp function "
Args: (x)
Returns T if X is an integer (fixnum or bignum); NIL otherwise.")

(docfun intern function "
Args: (name &optional (package *package*))
Returns a symbol having the specified name, creating it if necessary.
Returns as the second value one of the symbols :INTERNAL, :EXTERNAL,
:INHERITED, and NIL.")

(docvar internal-time-units-per-second constant "
The number of internal time units that fit into a second.")

(docfun intersection function "
Args: (list1 list2 &key (test #'eql) test-not (key #'identity))
Returns the intersection of List1 and List2.")

(docfun isqrt function "
Args: (integer)
Returns the greatest integer less than or equal to the square root of the
given non-negative integer.")

(docfun keywordp function "
Args: (x)
Returns T if X is a symbol and it belongs to the KEYWORD package; NIL
otherwise.")

(docfun labels special "
Syntax: (labels ({(name lambda-list {decl | doc}* {form}*)}*) . body)
Evaluates BODY as a PROGN, with the local function definitions in effect.
The scope of the locally defined functions include the function definitions
themselves, so they can reference externally defined functions of the same
name.  See the doc of DEFUN for the complete syntax of a lambda-list.
Doc-strings for local functions are simply ignored.")

(docvar lambda-list-keywords constant "
List of all the lambda-list keywords used in KCL.")

(docvar lambda-parameters-limit constant "
The exclusive upper bound on the number of distinct parameter names that may
appear in a single lambda-list.  Actually, however, there is no such upper
bound in KCL.")

(docfun last function "
Args: (list)
Returns the last cons in LIST")

#+aosvs
(docfun last-termination-message function "
Args: ()
KCL specific: Flushes all the message currently spooled and returns the last
termination message as a string.  Only KCL/AOS supports this function.")

(docfun lcm function "
Args: (integer &rest more-integers)
Returns the least common multiple of the arguments.")

(docfun ldb function "
Args: (bytespec integer)
Extracts and right-justifies the specified byte of INTEGER, and returns the
result.")

(docfun ldb-test function "
Args: (bytespec integer)
Returns T if at least one of the bits in the specified bytes of INTEGER is 1;
NIL otherwise.")

(docfun ldiff function "
Args: (list sublist)
Returns a new list, whose elements are those of LIST that appear before
SUBLIST.  If SUBLIST is not a tail of LIST, a copy of LIST is returned.")

(docvar least-negative-double-float constant "
Same as LEAST-NEGATIVE-LONG-FLOAT.")

(docvar least-negative-long-float constant "
The negative long-float closest in value to zero.")

(docvar least-negative-short-float constant "
The negative short-float closest in value to zero.")

(docvar least-negative-single-float constant "
Same as LEAST-NEGATIVE-LONG-FLOAT.")

(docvar least-positive-double-float constant "
Same as LEAST-POSITIVE-LONG-FLOAT.")

(docvar least-positive-long-float constant "
The positive long-float closest in value to zero.")

(docvar least-positive-short-float constant "
The positive short-float closest in value to zero.")

(docvar least-positive-single-float constant "
Same as LEAST-POSITIVE-LONG-FLOAT.")

(docfun length function "
Args: (sequence)
Returns the length of SEQUENCE.")

(docfun let special "
Syntax: (let ({var | (var [value])}*) {decl}* {form}*)
Initializes VARs, binding them to the values of VALUEs (which defaults to NIL)
all at once, then evaluates FORMs as a PROGN.")

(docfun let* special "
Syntax: (let* ({var | (var [value])}*) {decl}* {form}*)
Initializes VARs, binding them to the values of VALUEs (which defaults to NIL)
from left to right, then evaluates FORMs as a PROGN.")

(docfun lisp-implementation-type function "
Args: ()
Returns a string that tells you that you are using a version of KCL.")

(docfun lisp-implementation-version function "
Args: ()
Returns a string that tells you when the current KCL implementation is
brought up.")

(doctype list "
A list is either NIL (the empty list) or a cons whose cdr is a list.
A list is denoted by writing its element in order, separated by blank space,
and surrounded by parentheses.
A dotted list is a cons whose cdr is either a non-cons object or a dotted
list.  A dotted list is denoted in the same way as a list is, but the last
cdr in the cdr chain is preceded by a dot '.' and blank space.

The backquote macro is sometimes useful to construct a compilcated list
structure.  When evaluating `(...)
	,form embeds the value of FORM,
	,@form and ,.form embed all elements of the list value of FORM,
	and other things embed itself
into the structure at their position.  For example,
	`(a b ,c d e) expands to (list* 'a 'b c '(d e))
	`(a b ,@c d e) expands to (list* 'a 'b (append c '(d e)))
	`(a b ,.c d e) expands to (list* 'a 'b (nconc c '(d e)))")

(docfun list function "
Args: (&rest args)
Returns a list of its arguments")

(docfun list* function "
Args: (arg &rest others)
Returns a list of its arguments with the last cons being a dotted pair of
the next to the last argument and the last argument.")

(docfun list-all-packages function "
Args: ()
Returns a list of all existing packages.")

(docfun list-length function "
Args: (list)
Returns the length of LIST, or NIL if LIST is circular.")

(docfun listen function "
Args: (&optional (stream *standard-input*))
Returns T if a character is available on STREAM; NIL otherwise.  This function
does not correctly work in some versions of KCL because of the lack of such
mechanism in the underlying operating system.")

(docfun listp function "
Args: (x)
Returns T if X is either a cons or NIL; NIL otherwise.")

(docfun load function "
Args: (filename
       &key (verbose *load-verbose*) (print nil) (if-does-not-exist :error))
Loads the file named by FILENAME into KCL.")

(docvar *load-verbose* variable "
The default for the VERBOSE argument to LOAD.")

(docfun locally macro "
Syntax: (locally {decl}* {form}*)
Gives local pervasive declarations.")

(docfun log function "
Args: (number &optional base)
Returns the logarithm of NUMBER in the base BASE.  BASE defaults to the base
of natural logarithms.")

(docfun logand function "
Args: (&rest integers)
Returns the bit-wise AND of its arguments.")

(docfun logandc1 function "
Args: (integer1 integer2)
Returns the logical AND of (LOGNOT INTEGER1) and INTEGER2.")

(docfun logandc2 function "
Args: (integer1 integer2)
Returns the logical AND of INTEGER1 and (LOGNOT INTEGER2).")

(docfun logbitp function "
Args: (index integer)
Returns T if the INDEX-th bit of INTEGER is 1.")

(docfun logcount function "
Args: (integer)
If INTEGER is negative, returns the number of 0 bits.  Otherwise, returns
the number of 1 bits.")

(docfun logeqv function "
Args: (&rest integers)
Returns the bit-wise EQUIVALENCE of its arguments.")

(docfun logior function "
Args: (&rest integers)
Returns the bit-wise INCLUSIVE OR of its arguments.")

(docfun lognand function "
Args: (integer1 integer2)
Returns the complement of the logical AND of INTEGER1 and INTEGER2.")

(docfun lognor function "
Args: (integer1 integer2)
Returns the complement of the logical OR of INTEGER1 and INTEGER2.")

(docfun lognot function "
Args: (integer)
Returns the bit-wise logical NOT of INTEGER.")

(docfun logorc1 function "
Args: (integer1 integer2)
Returns the logical OR of (LOGNOT INTEGER1) and INTEGER2.")

(docfun logorc2 function "
Args: (integer1 integer2)
Returns the logical OR of INTEGER1 and (LOGNOT INTEGER2).")

(docfun logtest function "
Args: (integer1 integer2)
Returns T if LOGAND of INTEGER1 and INTEGER2 is not zero; NIL otherwise.")

(docfun logxor function "
Args: (&rest integers)
Returns the bit-wise EXCLUSIVE OR of its arguments.")

(docvar long-float-epsilon constant "
The smallest positive long-float that satisfies
	(not (= (float 1 e) (+ (float 1 e) e))).")

(docvar long-float-negative-epsilon constant "
The smallest positive long-float that satisfies
	(not (= (float 1 e) (- (float 1 e) e))).")

(docfun long-site-name function "
Args: ()
Returns a string that identifies the physical location of the current KCL.")

(docfun loop macro "
Syntax: (loop {form}*)
Executes FORMs repeatedly until exited by a THROW or RETURN.  The FORMs are
surrounded by an implicit NIL block.")

(docfun lower-case-p function "
Args: (char)
Returns T if CHAR is a lower-case character; NIL otherwise.")

(docfun machine-instance function "
Args: ()
Returns a string that identifies the machine instance of the machine
on which KCL is currently running.")

(docfun machine-type function "
Args: ()
Returns a string that identifies the machine type of the machine
on which KCL is currently running.")

(docfun machine-version function "
Args: ()
Returns a string that identifies the machine version of the machine
on which KCL is currently running.")

(docfun macro-function function "
Args: (symbol)
If SYMBOL globally names a macro, then returns the expansion function.
Returns NIL otherwise.")

(docfun macroexpand function "
Args: (form &optional (env nil))
If FORM is a macro form, then expands it repeatedly until it is not a macro
any more.  Returns two values: the expanded form and a T-or-NIL flag
indicating whether the original form was a macro.")

(docfun macroexpand-1 function "
Args: (form &optional (env nil))
If FORM is a macro form, then expands it once.  Returns two values: the
expanded form and a T-or-NIL flag indicating whether the original form was
a macro.")

(docvar *macroexpand-hook* variable "
Holds a function that can take two arguments (a macro expansion function
and the macro form to be expanded) and returns the expanded form.  This
function is whenever a macro-expansion takes place.  Initially this is set to
#'FUNCALL.")

(docfun macrolet special "
Syntax: (macrolet ({(name defmacro-lambda-list {decl | doc}* . body)}*)
          {form}*)
Evaluates FORMs as a PROGN, with the local macro definitions in effect.
See the doc of DEFMACRO for the complete syntax of a defmacro-lambda-list.
Doc-strings for local macros are simply ignored.")

(docfun make-array function "
Args: (dimensions
       &key (element-type t) initial-element (initial-contents nil)
            (adjustable nil) (fill-pointer nil) (displaced-to nil)
            (displaced-index-offset 0))
Creates an array of the specified DIMENSIONS.  The default for INITIAL-
ELEMENT depends on ELEMENT-TYPE.")

(docfun make-broadcast-stream function "
Args: (&rest streams)
Returns an output stream which sends its output to all of the given streams.")

(docfun make-char function "
Args: (char &optional (bits 0) (font 0))
Returns a character object with the same code attribute as CHAR and with
the specified BITS and FONT attributes.")

(docfun make-concatenated-stream function "
Args: (&rest streams)
Returns a stream which takes its input from each of the STREAMs in turn,
going on to the next at end of stream.")

(docfun make-dispatch-macro-character function "
Args: (char &optional (non-terminating-p nil) (readtable *readtable*))
Causes the character CHAR to be a dispatching macro character in READTABLE.")

(docfun make-echo-stream function "
Args: (input-stream output-stream)
Returns a bidirectional stream which gets its input from INPUT-STREAM and
sends its output to OUTPUT-STREAM.  In addition, all input is echoed to
OUTPUT-STREAM.")

(docfun make-hash-table function "
Args: (&key (test 'eql) (size 1024) (rehash-size 1.5) (rehash-threshold 0.7))
Creates and returns a hash table.")

(docfun make-list function "
Args: (size &key (initial-element nil))
Creates and returns a list containing SIZE elements, each of which is
initialized to INITIAL-ELEMENT.")

(docfun make-package function "
Args: (package-name &key (nicknames nil) (use '(lisp)))
Makes a new package having the specified PACKAGE-NAME and NICKNAMES.  The
package will inherit all external symbols from each package in the USE list.")

(docfun make-pathname function "
Args: (&key (defaults (parse-namestring \"\"
                        (pathname-host *default-pathname-defaults*)))
            (host (pathname-host defaults))
            (device (pathname-device defaults))
            (directory (pathname-directory defaults))
            (name (pathname-name defaults))
            (type (pathname-type defaults))
            (version (pathname-version defaults)))
Create a pathname from HOST, DEVICE, DIRECTORY, NAME, TYPE and VERSION.")

(docfun make-random-state function "
Args: (&optional (state *random-state*))
Creates and returns a copy of the specified random state.  If STATE is NIL,
then the value of *RANDOM-STATE* is used.  If STATE is T, then returns a
random state object generated from the universal time.")

(docfun make-sequence function "
Args: (type length &key initial-element)
Returns a sequence of the given TYPE and LENGTH, with elements initialized
to INITIAL-ELEMENT.  The default value of INITIAL-ELEMENT depends on TYPE.")

(docfun make-string function "
Args: (size &key (initial-element #\\Space))
Creates and returns a new string of SIZE length whose elements are all
INITIAL-ELEMENT.")

(docfun make-string-input-stream function "
Args: (string &optional (start 0) (end (length string)))
Returns an input stream which will supply the characters of String between
Start and End in order.")

(docfun make-string-output-stream function "
Args: ()
Returns an output stream which will accumulate all output given it for
the benefit of the function GET-OUTPUT-STREAM-STRING.")

(docfun make-symbol function "
Args: (string)
Creates and returns a new uninterned symbol whose print name is STRING.")

(docfun make-synonym-stream function "
Args: (symbol)
Returns a stream which performs its operations on the stream which is the
value of the dynamic variable named by SYMBOL.")

(docfun make-two-way-stream function "
Args: (input-stream output-stream)
Returns a bidirectional stream which gets its input from INPUT-STREAM and
sends its output to OUTPUT-STREAM.")

(docfun makunbound function "
Args: (symbol)
Makes empty the value slot of SYMBOL.  Returns SYMBOL.")

(docfun map function "
Args: (result-type function sequence &rest more-sequences)
FUNCTION must take as many arguments as there are sequences provided.  The 
result is a sequence such that the i-th element is the result of applying
FUNCTION to the i-th elements of the SEQUENCEs.")

(docfun mapc function "
Args: (fun list &rest more-lists)
Applies FUN to successive cars of LISTs.  Returns the first LIST.")

(docfun mapcan function "
Args: (fun list &rest more-lists)
Applies FUN to successive cars of LISTs, NCONCs the results, and returns it.")

(docfun mapcar function "
Args: (fun list &rest more-lists)
Applies FUN to successive cars of LISTs and returns the results as a list.")

(docfun mapcon function "
Args: (fun list &rest more-lists)
Applies FUN to successive cdrs of LISTs, NCONCs the results, and returns it.")

(docfun maphash function "
Args: #'hash-table
For each entry in HASH-TABLE, calls FUNCTION on the key and value of the
entry; returns NIL.")

(docfun mapl function "
Args: (fun list &rest more-lists)
Applies FUN to successive cdrs of LISTs.  Returns the first LIST.")

(docfun maplist function "
Args: (fun list &rest more-lists)
Applies FUN to successive cdrs of LISTs and returns the results as a list.")

(docfun mask-field function "
Args: (bytespec integer)
Extracts the specified byte from INTEGER.")

(docfun max function "
Args: (number &rest more-numbers)
Returns the greatest of its arguments.")

(docfun maximum-allocatable-pages function "
Args: (type)
KCL specific: Returns the current maximum number of pages for the type class
of the KCL implementation type TYPE.")

(docfun maximum-contiguous-pages function "
Args: ()
KCL specific: Returns the current maximum number of pages for contiguous
blocks.")

(docfun member function "
Args: (item list &key (test #'eql) test-not (key #'identity))
Returns the tail of LIST beginning with the first ITEM.")

(docfun member-if function "
Args: (test list &key (key #'identity))
Returns the tail of LIST beginning with the first element satisfying TEST.")

(docfun member-if-not function "
Args: (test list &key (key #'identity))
Returns the tail of LIST beginning with the first element not satisfying
TEST.")

(docfun merge function "
Args: (result-type sequence1 sequence2 predicate &key (key #'identity))
SEQUENCE1 and SEQUENCE2 are destructively merged into a sequence of type
RESULT-TYPE using PREDICATE to order the elements.")

(docfun merge-pathnames function "
Args: (pathname
       &optional (defaults *default-pathname-defaults*) default-version)
Fills in unspecified slots of PATHNAME from DEFAULTS.  DEFAULT-VERSION
is ignored in KCL.")

(docfun min function "
Args: (number &rest more-numbers)
Returns the least of its arguments.")

(docfun minusp function "
Args: (number)
Returns T if NUMBER < 0; NIL otherwise.")

(docfun mismatch function "
Args: (sequence1 sequence2
       &key (from-end nil) (test #'eql) test-not (start1 0) (start2 0)
            (end1 (length sequence1)) (end2 (length sequence2))
            (key #'identity))
The specified subsequences of SEQUENCE1 and SEQUENCE2 are compared
element-wise.  If they are of equal length and match in every element, the
result is NIL.  Otherwise, the result is a non-negative integer, the index
within SEQUENCE1 of the leftmost position at which they fail to match; or, if
one is shorter than and a matching prefix of the other, the index within
SEQUENCE1 beyond the last position tested is returned.")

(docfun mod function "
Args: (number divisor)
Returns the second result of (FLOOR NUMBER DIVISOR).")

(docvar *modules* variable "
A list of names of the modules that have been loaded into KCL.")

(docvar most-negative-double-float constant "
Same as MOST-NEGATIVE-LONG-FLOAT.")

(docvar most-negative-fixnum constant "
The fixnum closest in value to negative infinity.")

(docvar most-negative-long-float constant "
The long-float closest in value to negative infinity.")

(docvar most-negative-short-float constant "
The short-float closest in value to negative infinity.")

(docvar most-negative-single-float constant "
Same as MOST-NEGATIVE-LONG-FLOAT.")

(docvar most-positive-double-float constant "
Same as MOST-POSITIVE-LONG-FLOAT.")

(docvar most-positive-fixnum constant "
The fixnum closest in value to positive infinity.")

(docvar most-positive-long-float constant "
The long-float closest in value to positive infinity.")

(docvar most-positive-short-float constant "
The short-float closest in value to positive infinity.")

(docvar most-positive-single-float constant "
Same as MOST-POSITIVE-LONG-FLOAT.")

(docfun multiple-value-bind macro "
Syntax: (multiple-value-bind ({var}*) values-form {decl}* {form}*)
Binds the VARiables to the results of VALUES-FORM, in order (defaulting to
NIL) and evaluates FORMs in order.")

(docfun multiple-value-call special "
Syntax: (multiple-value-call function {form}*)
Calls FUNCTION with all the values of FORMs as arguments.")

(docfun multiple-value-list macro "
Syntax: (multiple-value-list form)
Evaluates FORM, and returns a list of multiple values it returned.")

(docfun multiple-value-prog1 special "
Syntax: (multiple-value-prog1 form {form}*)
Evaluates the first FORM, saves all the values produced, then evaluates
the other FORMs.  Returns the saved values.")

(docfun multiple-value-setq macro "
Syntax: (multiple-value-setq variables form)
Sets each variable in the list VARIABLES to the corresponding value of FORM.
Returns the value assigned to the first variable.")

(docvar multiple-values-limit constant "
The exclusive upper bound on the number of values that may be returned from
a function.  Actually, however, there is no such upper bound in KCL.")

(docfun name-char function "
Args: (name)
Given an argument acceptable to string,
Returns a character object whose name is NAME if one exists.  Returns NIL
otherwise.  NAME must be an object that can be coerced to a string.")

(docfun namestring function "
Args: (pathname)
Returns the full form of PATHNAME as a string.")

(docfun nbutlast function "
Args: (list &optional (n 1))
Changes the cdr of the N+1 th cons from the end of the list LIST to NIL.
Returns the whole list.")

(docfun nconc function "
Args: (&rest lists)
Concatenates LISTs by destructively modifying them.")

(doctype nil "
The type NIL is a subtype of every type.  No object belongs to this type.")

(docvar nil constant "
Holds NIL.")

(docfun nintersection function "
Args: (list1 list2 &key (test #'eql) test-not (key #'identity))
Returns the intersection of LIST1 and LIST2.  LIST1 may be destroyed.")

(docfun ninth function "
Args: (x)
Equivalent to (CAR (CDDDDR (CDDDDR X))).")

(docfun not function "
Args: (x)
Returns T if X is NIL; NIL otherwise.")

(docfun notany function "
Args: (predicate sequence &rest more-sequences)
Returns T if none of the elements in SEQUENCEs satisfies PREDICATE; NIL
otherwise.")

(docfun notevery function "
Args: (predicate sequence &rest more-sequences)
Returns T if at least one of the elements in SEQUENCEs does not satisfy
PREDICATE; NIL otherwise.")

(docfun nreconc function "
Args: (x y)
Equivalent to (NCONC (NREVERSE X) Y).")

(docfun nreverse function "
Args: (sequence)
Returns a sequence of the same elements as SEQUENCE but in reverse order.
SEQUENCE may be destroyed.")

(docfun nset-difference function "
Args: (list1 list2 &key (test #'eql) test-not (key #'identity))
Returns a list of elements of LIST1 that do not appear in LIST2.  LIST1 may
be destroyed.")

(docfun nset-exclusive-or function "
Args: (list1 list2 &key (test #'eql) test-not (key #'identity))
Returns a list with elements which appear but once in LIST1 and LIST2.")

(docfun nstring-capitalize function "
Args: (string &key (start 0) (end (length string)))
Returns STRING with the first character of each word converted to upper-case,
and remaining characters in the word converted to lower case.")

(docfun nstring-downcase function "
Args: (string &key (start 0) (end (length string)))
Returns STRING with all upper case characters converted to lowercase.")

(docfun nstring-upcase function "
Args: (string &key (start 0) (end (length string)))
Returns STRING with all lower case characters converted to uppercase.")

(docfun nsublis function "
Args: (alist tree &key (test #'eql) test-not (key #'identity))
Substitutes from ALIST for subtrees of TREE.")

(docfun nsubst function "
Args: (new old tree &key (test #'eql) test-not (key #'identity))
Substitutes NEW for subtrees in TREE that match OLD.")

(docfun nsubst-if function "
Args: (new test tree &key (key #'identity))
Substitutes NEW for subtrees of TREE that satisfy TEST.")

(docfun nsubst-if-not function "
Args: (new test tree &key (key #'identity))
Substitutes NEW for subtrees of TREE that do not satisfy TEST.")

(docfun nsubstitute function "
Args: (newitem olditem sequence
       &key (from-end nil) (test #'eql) test-not (start 0)
            (end (length sequence)) (count most-positive-fixnum)
            (key #'identity))
Returns a sequence of the same kind as SEQUENCE with the same elements
except that OLDITEMs are replaced with NEWITEM.  SEQUENCE may be destroyed.")

(docfun nsubstitute-if function "
Args: (new test sequence
       &key (from-end nil) (start 0) (end (length sequence))
            (count most-positive-fixnum) (key #'identity))
Returns a sequence of the same kind as SEQUENCE with the same elements
except that all elements satisfying TEST are replaced with NEWITEM.  SEQUENCE
may be destroyed.")

(docfun nsubstitute-if-not function "
Args: (new test sequence
       &key (from-end nil) (start 0) (end (length sequence))
            (count most-positive-fixnum) (key #'identity))
Returns a sequence of the same kind as SEQUENCE with the same elements
except that all elements not satisfying TEST are replaced with NEWITEM.
SEQUENCE may be destroyed.")

(docfun nth function "
Args: (n list)
Returns the N-th element of LIST, where the car of LIST is the zeroth
element.")

(docfun nthcdr function "
Args: (n list)
Returns the result of performing the CDR operation N times on LIST.")

(docfun null function "
Args: (x)
Returns T if X is NIL; NIL otherwise.")

(doctype number "
A number is either an integer, a ratio, a floating-point number, or a complex
number.  Integers and ratios are collectively called rationals.")

(docfun numberp function "
Args: (x)
Returns T if X is any kind of number; NIL otherwise.")

(docfun numerator function "
Args: (rational)
Returns as an integer the numerator of the given rational number.")

(docfun nunion function "
Args: (list1 list2 &key (test #'eql) test-not (key #'identity))
Returns the union of LIST1 and LIST2.  LIST1 and/or LIST2 may be destroyed.")

(docfun oddp function "
Args: (integer)
Returns T if INTEGER is odd; NIL otherwise.")

(docfun open function "
Args: (filename &key (direction :input) (element-type 'string-char)
                     (if-exists :error) (if-does-not-exist :error))
Opens the file specified by FILENAME, which may be a string, a pathname,
or a stream.  Returns a stream for the open file.
Possible DIRECTION values are :INPUT, :OUTPUT, :IO and :PROBE.
Possible ELEMENT-TYPE values are STRING-CHAR, (UNSIGNED-BYTE n),
UNSIGNED-BYTE, (SIGNED-BYTE n), SIGNED-BYTE, CHARACTER, BIT, (MOD n), and
:DEFAULT.
Possible IF-EXISTS values are :ERROR, :NEW-VERSION, :RENAME,
:RENAME-AND-DELETE, :OVERWRITE, :APPEND, :SUPERSEDE, and NIL.
Possible IF-DOES-NOT-EXIST values are :ERROR, :CREATE, and NIL.")

(docfun or macro "
Syntax: (or {form}*)
Evaluates FORMs in order from left to right.  If any FORM evaluates to
non-NIL, quits and returns that (single) value.  If the last FORM is reached,
returns whatever values it returns.")

(docfun output-stream-p function "
Args: (stream)
Returns non-nil if STREAM can handle output operations; NIL otherwise.")

(doctype package "
Packages are collections of symbols that serve as name spaces.
A package is denoted as #<? package> where '?' is actually the name of the
package.
KCL provides five built-in packages:
	lisp	 symbols that names Common Lisp functions and variables.
	user	 the standard package used by the user.
	keyword	 the keyword package.
	system	 symbols that names internal functions and variables.
		 Has nicknames SYS and SI.
	compiler symbols that names functions and variables internally used
		 by the KCL compiler.")

(docvar *package* variable "
The current package.")

(docfun package-name function "
Args: (package)
Returns the string that names the specified PACKAGE.")

(docfun package-nicknames function "
Args: (package)
Returns as a list the nickname strings for the specified PACKAGE.")

(docfun package-shadowing-symbols function "
Args: (package)
Returns the list of symbols that have been declared as shadowing symbols
in PACKAGE.")

(docfun package-use-list function "
Args: (package)
Returns the list of packages used by PACKAGE.")

(docfun package-used-by-list function "
Args: (package)
Returns the list of packages that use PACKAGE.")

(docfun packagep function "
Args: (x)
Returns T if X is a package; NIL otherwise.")

(docfun pairlis function "
Args: (keys data &optional (alist nil))
Constructs an association list from KEYS and DATA adding to ALIST.")

(docfun parse-integer function "
Args: (string
       &key (start 0) (end (length string)) (radix 10) (junk-allowed nil))
Parses STRING for an integer and returns it.")

(docfun parse-namestring function "
Args: (thing &optional host (defaults *default-pathname-defaults*)
             &key (start 0) (end (length thing)) (junk-allowed nil))
Parses a string representation of a pathname into a pathname.  HOST
is ignored.")

(doctype pathname "
Pathnames are the means by which a Lisp program can interface to an external
file system in a reasonably implementation-independent manner.
Among the six elements in a pathname described in Steele's manual,
HOST, DEVICE, and VERSION are meaningless in KCL, though they are harmless
at all.
A pathname is denoted as #\"???\" where '???' is actually some pathname
information.  This depends on the version of KCL.  Refer to the KCL report
at your hand for details.")

(docfun pathname function "
Args: (x)
Turns X into a pathname.  X may be a string, symbol, stream, or pathname.")

(docfun pathname-device function "
Args: (pathname)
Returns the device slot of PATHNAME.")

(docfun pathname-directory function "
Args: (pathname)
Returns the directory slot of PATHNAME.")

(docfun pathname-host function "
Args: (pathname)
Returns the host slot of PATHNAME.")

(docfun pathname-name function "
Args: (pathname)
Returns the name slot of PATHNAME.")

(docfun pathname-type function "
Args: (pathname)
Returns the type slot of PATHNAME.")

(docfun pathname-version function "
Args: (pathname)
Returns the version slot of PATHNAME.")

(docfun pathnamep function "
Args: (x)
Returns T if X is a pathname object; NIL otherwise.")

(docfun peek-char function "
Args: (&optional (peek-type nil) (stream *standard-input*) (eof-error-p t)
                 (eof-value nil) (recursive-p nil))
Peeks at the next character in the input stream STREAM.")

(docfun phase function "
Args: (number)
Returns the angle part of the polar representation of a complex number.
For non-complex numbers, this is 0.")

(docvar pi constant "
The floating-point number that is appropriately equal to the ratio of the
circumference of the circle to the diameter.")

(docfun plusp function "
Args: (number)
Returns T if NUMBER > 0; NIL otherwise.")

(docfun pop macro "
Syntax: (pop place)
Pops one item off the front of the list in PLACE and returns it.")

(docfun position function "
Args: (item sequence
       &key (from-end nil) (test #'eql) test-not (start 0)
            (end (length sequence)) (key #'identity))
Returns the index of the first element in SEQUENCE that satisfies TEST with
ITEM; NIL if no such element exists.")

(docfun position-if function "
Args: (test sequence
       &key (from-end nil) (start 0) (end (length sequence)) (key #'identity))
Returns the index of the first element in SEQUENCE that satisfies TEST; NIL
if no such element exists.")

(docfun position-if-not function "
Args: (test sequence
       &key (from-end nil) (start 0) (end (length sequence)) (key #'identity))
Returns the index of the first element in SEQUENCE that does not satisfy TEST;
NIL if no such element exists.")

(docfun pprint function "
Args: (object &optional (stream *standard-output*))
Pretty-prints OBJECT.  Returns OBJECT.  Equivalent to
	(WRITE :STREAM STREAM :PRETTY T)
The SI:PRETTY-PRINT-FORMAT property N (which must be a non-negative integer)
of a symbol SYMBOL controls the pretty-printing of form
	(SYMBOL f1 ... fN fN+1 ... fM)
in such a way that the subforms fN+1, ..., fM are regarded as the 'body' of
the entire form.  For instance, the property value of 2 is initially given
to the symbol DO.")

(docfun prin1 function "
Args: (object &optional (stream *standard-output*))
Prints OBJECT in the mostly readable representation.  Returns OBJECT.
Equivalent to (WRITE OBJECT :STREAM STREAM :ESCAPE T).")

(docfun prin1-to-string function "
Args: (object)
Returns as a string the printed representation of OBJECT in the mostly
readable representation.
Equivalent to (WRITE-TO-STRING OBJECT :ESCAPE T).")

(docfun princ function "
Args: (object &optional (stream *standard-output*))
Prints OBJECT without escape characters.  Returns OBJECT.  Equivalent to
	(WRITE OBJECT :STREAM STREAM :ESCAPE NIL).")

(docfun princ-to-string function "
Args: (object)
Returns as a string the printed representation of OBJECT without escape
characters.  Equivalent to
	(WRITE-TO-STRING OBJECT :ESCAPE NIL).")

(docfun print function "
Args: (object &optional (stream *standard-output*))
Outputs a newline character, and then prints OBJECT in the mostly readable
representation.  Returns OBJECT.  Equivalent to
	(PROGN (TERPRI STREAM) (WRITE OBJECT :STREAM STREAM :ESCAPE T)).")

(docvar *print-array* variable "
Whether the KCL printer should print array elements.")

(docvar *print-base* variable "
The radix in which the KCL printer prints integers and rationals.
The value must be an integer from 2 to 36, inclusive.")

(docvar *print-case* variable "
The case in which the KCL printer should print ordinary symbols.
The value must be one of the keywords :UPCASE, :DOWNCASE, and :CAPITALIZE.")

(docvar *print-circle* variable "
Whether the KCL printer should take care of circular lists.")

(docvar *print-escape* variable "
Whether the KCL printer should put escape characters whenever appropriate.")

(docvar *print-gensym* variable "
Whether the KCL printer should prefix symbols with no home package
with \"#:\".")

(docvar *print-length* variable "
How many elements the KCL printer should print at each level of nested data
object.  Unlimited if NIL.")

(docvar *print-level* variable "
How many levels deep the KCL printer should print.  Unlimited if NIL.")

(docvar *print-pretty* variable "
Whether the KCL printer should pretty-print.  See the function doc of PPRINT
for more information about pretty-printing.")

(docvar *print-radix* variable "
Whether the KCL printer should print the radix indicator when printing
integers and rationals.")

(docfun probe-file function "
Args: (file)
Returns the truename of file if the file exists.
Returns NIL otherwise.")

#+aosvs
(docfun process function "
Args: (progname &optional (ipc-message \"\")
       &key block console debug dir input output username list data ioc)
KCL specific: Creates a process.  Only KCL/AOS supports this function.")

(docfun proclaim function "
Args: (decl-spec)
Puts the declaration given by DECL-SPEC into effect globally.  See the doc of
DECLARE for possible DECL-SPECs.")

(docfun proclamation function "
Args: (decl-spec)
KCL specific: Returns T if the specified declaration is globally in effect;
NIL otherwise.  See the doc of DECLARE for possible DECL-SPECs.")

(docfun prog macro "
Syntax: (prog ({var | (var [init])}*) {decl}* {tag | statement}*)
Creates a NIL block, binds VARs in parallel, and then executes STATEMENTs.")

(docfun prog* macro "
Syntax: (prog* ({var | (var [init])}*) {decl}* {tag | statement}*)
Creates a NIL block, binds VARs sequentially, and then executes STATEMENTs.")

(docfun prog1 macro "
Syntax: (prog1 first {form}*)
Evaluates FIRST and FORMs in order, and returns the (single) value of FIRST.")

(docfun prog2 macro "
Syntax: (prog2 first second {forms}*)
Evaluates FIRST, SECOND, and FORMs in order, and returns the (single) value
of SECOND.")

(docfun progn special "
Syntax: (progn {form}*)
Evaluates FORMs in order, and returns whatever the last FORM returns.")

(docfun progv special "
Syntax: (progv symbols values {form}*)
SYMBOLS must evaluate to a list of variables.  VALUES must evaluate to a list
of initial values.  Evaluates FORMs as a PROGN, with each variable bound (as
special) to the corresponding value.")

(docfun provide function "
Args: (module-name)
Adds the specified module to the list of modules maintained in *MODULES*.")

(docfun psetf macro "
Syntax: (psetf {place newvalue}*)
Similar to SETF, but evaluates all NEWVALUEs first, and then replaces the
value in each PLACE with the value of the corresponding NEWVALUE.  Returns
NIL always.")

(docfun psetq macro "
Syntax: (psetq {var form}*)
Similar to SETQ, but evaluates all FORMs first, and then assigns each value to
the corresponding VAR.  Returns NIL always.")

(docfun push macro "
Syntax: (push item place)
Conses ITEM onto the list in PLACE, and returns the new list.")

(docfun pushnew macro "
Syntax: (pushnew item place {keyword value}*)
If ITEM is already in the list stored in PLACE, does nothing.  Else, conses
ITEM onto the list.  Returns NIL.  If no KEYWORDs are supplied, each element
in the list is compared with ITEM by EQL, but the comparison can be controlled
by supplying keywords :TEST, :TEST-NOT, and/or :KEY.")

(docvar *query-io* variable "
The query I/O stream.")

(docfun quote special "
Syntax: (quote x) or 'x
Simply returns X without evaluating it.")

(docfun random function "
Args: (number &optional (state *random-state*))
Generates a uniformly distributed pseudo-random number between zero
(inclusive) and NUMBER (exclusive), by using the random state object STATE.")

(doctype random-state "
A random state is used to encapsulate state information used by the
pseudo-random number generator.
A random state is denoted by prefixing a number with '#$'.")

(docvar *random-state* variable "
The default random-state object used by RAMDOM.")

(docfun random-state-p function "
Args: (x)
Returns T if X is a random-state object; NIL otherwise.")

(docfun rassoc function "
Args: (item alist &key (test #'eql) test-not (key #'identity))
Returns the first cons in ALIST whose cdr is equal to ITEM.")

(docfun rassoc-if function "
Args: (predicate alist)
Returns the first cons in ALIST whose cdr satisfies PREDICATE.")

(docfun rassoc-if-not function "
Args: (predicate alist)
Returns the first cons in ALIST whose cdr does not satisfy PREDICATE.")

(doctype ratio "
A ratio represents a mathematical ratio of two integers.  A ratio is
denoted by its numerator and denominator, separated by a slash '/'.  More
precisely, the following syntax is normally used.
	{ [sign]{digit-in-default-radix}+ / {digit-in-default-radix}+
	  | {#b | #B} [sign] {radix-2-digit}+ / {radix-2-digit}+
	  | {#o | #O} [sign] {radix-8-digit}+ / {radix-8-digit}+
	  | {#x | #X} [sign] {radix-16-digit}+ / {radix-16-digit}+
	  | {#2r | #2R} [sign] {radix-2-digit}+ / {radix-2-digit}+
	  ....
	  | {#36r | #36R} [sign] {radix-36-digit}+ / {radix-36-digit}+  }
See the type doc of INTEGER for the syntactic variables used here.")

(docfun rational function "
Args: (number)
Converts NUMBER into rational accurately and returns it.")

(docfun rationalize function "
Args: (number)
Converts NUMBER into rational approximately and returns it.")

(docfun rationalp function "
Args: (x)
Returns T if X is an integer or a ratio; NIL otherwise.")

(docfun read function "
Args: (&optional (stream *standard-input*) (eof-error-p t) (eof-value nil)
                 (recursivep nil))
Reads in the next object from STREAM.")

(docvar *read-base* variable "
The radix that the KCL reader reads numbers in.")

(docfun read-byte function "
Args: (stream &optional (eof-error-p t) (eof-value nil))
Reads the next byte from STREAM.")

(docfun read-char function "
Args: (&optional (stream *standard-input*) (eof-error-p t)
                 (eof-value nil) (recursive-p nil))
Reads a character from STREAM.")

(docfun read-char-no-hang function "
Args: (&optional (stream *standard-input*) (eof-error-p t)
                 (eof-value nil) (recursive-p nil))
Returns the next character from STREAM if one is available; NIL otherwise.")

(docvar *read-default-float-format* variable "
The floating-point format the KCL reader uses when reading floating-point
numbers that have no exponent marker or have e or E for an exponent marker.
Must be one of SHORT-FLOAT, SINGLE-FLOAT, DOUBLE-FLOAT, and LONG-FLOAT.")

(docfun read-delimited-list function "
Args: (char &optional (stream *standard-input*) (recursive-p nil))
Reads objects from STREAM until the next character after an object's
representation is CHAR.  Returns a list of the objects read.")

(docfun read-from-string function "
Args: (string &optional (eof-error-p t) (eof-value nil)
              &key (start 0) (end (length string)) (preserve-whitespace nil))
Reads an object from STRING.")

(docfun read-line function "
Args: (&optional (stream *standard-input*) (eof-error-p t)
                 (eof-value nil) (recursive-p nil))
Returns a line of text read from STREAM as a string, discarding the newline
character.")

(docfun read-preserving-whitespace function "
Args: (&optional (stream *standard-input*) (eof-error-p t) (eof-value nil)
                 (recursive-p nil))
Reads an object from STREAM, preserving the whitespace that followed the
object.")

(docvar *read-suppress* variable "
When the value of this variable is NIL, the KCL reader operates normally.
When it is non-NIL, then the reader parses input characters but much of what
is read is not interpreted.")

(doctype readtable "
A readtable is a data structure that maps characters into syntax types for the
KCL parser.
A readtable is denoted as #<a readtable>.")

(docvar *readtable* variable "
The current readtable.")

(docfun readtablep function "
Args: (x)
Returns T if X is a readtable object; NIL otherwise.")

(docfun realpart function "
Args: (number)
Extracts the real part of NUMBER.")

(docfun reduce function "
Args: (function sequence
       &key (from-end nil) (start 0) (end (length sequence)) initial-value)
Combines all the elements of SEQUENCE using a binary operation FUNCTION.
If INITIAL-VALUE is supplied, it is logically placed before the SEQUENCE.")

(docfun rem function "
Args: (number divisor)
Returns the second value of (TRUNCATE NUMBER DIVISOR).")

(docfun remf macro "
Syntax: (remf place indicator)
PLACE may be any place expression acceptable to SETF, and is expected
to hold a property list or NIL.  This list is destructively altered to
remove the property specified by INDICATOR.  Returns T if such a
property was present; NIL otherwise.")

(docfun remhash function "
Args: (key hash-table)
Removes any entry for KEY in HASH-TABLE.  Returns T if such an entry
existed; NIL otherwise.")

(docfun remove function "
Args: (item sequence
       &key (from-end nil) (test #'eql) test-not (start 0)
            (end (length sequence)) (count most-positive-fixnum)
            (key #'identity))
Returns a copy of SEQUENCE with ITEM removed.")

(docfun remove-duplicates function "
Args: (sequence
       &key (from-end nil) (test #'eql) test-not (start 0)
            (end (length sequence)) (key #'identity))
The elements of SEQUENCE are examined, and if any two match, one is discarded.
Returns the resulting sequence.")

(docfun remove-if function "
Args: (test sequence
       &key (from-end nil) (start 0) (end (length sequence))
            (count most-positive-fixnum) (key #'identity))
Returns a copy of SEQUENCE with elements satisfying TEST removed.")

(docfun remove-if-not function "
Args: (test sequence
       &key (from-end nil) (start 0) (end (length sequence))
            (count most-positive-fixnum) (key #'identity))
Returns a copy of SEQUENCE with elements not satisfying TEST removed.")

(docfun remprop function "
Args: (symbol indicator)
Look on property list of SYMBOL for property with specified
INDICATOR.  If found, splice this indicator and its value out of
the plist, and return the tail of the original list starting with
INDICATOR.  If not found, returns NIL with no side effects.")

(docfun rename-file function "
Args: (file new-name)
Renames the file FILE to NEW-NAME.  FILE may be a string, a pathname, or
a stream.")

(docfun rename-package function "
Args: (package new-name &optional (new-nicknames nil))
Replaces the old name and nicknames of PACKAGE with NEW-NAME and
NEW-NICKNAMES.")

(docfun replace function "
Args: (sequence1 sequence2
       &key (start1 0) (end1 (length sequence1))
            (start2 0) (end2 (length sequence2)))
Destructively modifies SEQUENCE1 by copying successive elements into it from
SEQUENCE2.")

(docfun require function "
Args: (module-name &optional (pathname))
If the specified module is not present, then loads the appropriate file(s).
PATHNAME may be a single pathname or it may be a list of pathnames.")

(docfun rest function "
Args: (x)
Equivalent to (CDR X).")

(docfun return macro "
Syntax: (return [result])
Returns from the lexically surrounding NIL block.  The value of RESULT,
which defaults to NIL, is returned as the value of the block.")

(docfun return-from special "
Syntax: (return-from name [result])
Returns from the lexically surrounding block whose name is NAME.  The value
of RESULT, which defaults to NIL, is returned as the value of the block.")

(docfun revappend function "
Args: (x y)
Equivalent to (APPEND (REVERSE X) Y)")

(docfun reverse function "
Args: (sequence)
Returns a new sequence containing the same elements as SEQUENCE but in
reverse order.")

(docfun room function "
Args: (&optional (x t))
Displays information about storage allocation in the following format.

* for each type class
	* the number of pages so-far allocated for the type class
	* the maximum number of pages for the type class
	* the percentage of used cells to cells so-far allocated
	* the number of times the garbage collector has been called to
	  collect cells of the type class
	* the implementation types that belongs to the type class
* the number of pages actually allocated for contiguous blocks
* the maximum number of pages for contiguous blocks
* the number of times the garbage collector has been called to collect
  contiguous blocks
* the number of pages in the hole
* the maximum number of pages for relocatable blocks
* the number of times the garbage collector has been called to collect
  relocatable blocks
* the total number of pages allocated for cells
* the total number of pages allocated
* the number of available pages
* the number of pages KCL can use.

The number of times the garbage collector has been called is not shown,
if the number is zero.  The optional X is ignored.")

(docfun rotatef macro "
Syntax: (rotatef {place}*)
Evaluates PLACEs in turn, then assigns to each PLACE the value of the form to
its right.  The rightmost PLACE gets the value of the leftmost PLACE.
Returns NIL always.")

(docfun round function "
Args: (number &optional (divisor 1))
Rounds NUMBER/DIVISOR to nearest integer.  The second returned value is the
remainder.")

(docfun rplaca function "
Args: (x y)
Replaces the car of X with Y, and returns the modified X.")

(docfun rplacd function "
Args: (x y)
Replaces the cdr of X with Y, and returns the modified X.")

(docfun save function "
Args: (pathname)
KCL specific: Saves the current KCL core image into a program file specified
by PATHNAME.  This function depends on the version of KCL.  See KCL Report for
the details.")

(docfun sbit function "
Args: (simple-bit-array &rest subscripts)
Returns the bit from SIMPLE-BIT-ARRAY at SUBSCRIPTS.")

(docfun scale-float function "
Args: (float integer)
Returns (* FLOAT (expt (float-radix FLOAT) INTEGER)).")

(docfun schar function "
Args: (simple-string index)
Returns the character object representing the INDEX-th character in STRING.
This is faster than CHAR.")

(docfun search function "
Args: (sequence1 sequence2
       &key (from-end nil) (test #'eql) test-not (start1 0) (start2 0)
            (end1 (length sequence1)) (end2 (length sequence2))
            (key #'identity))
A search is conducted for the first subsequence of SEQUENCE2 which
element-wise matches SEQUENCE1.  If there is such a subsequence in SEQUENCE2,
the index of the its leftmost element is returned; otherwise, NIL is
returned.")

(docfun second function "
Args: (x)
Equivalent to (CADR X).")

(doctype sequence "
A sequence is either a list or a vector.")

(docfun set function "
Args: (symbol value)
Assigns the value of VALUE to the dynamic variable named by SYMBOL, and
returns the value assigned.")

(docfun set-char-bit function "
Args: (char name newvalue)
Returns a character just like CHAR except that the named bit is set or
cleared, according to whether NEWVALUE is non-NIL or NIL.  This function
is useless in KCL.")

(docfun set-difference function "
Args: (list1 list2 &key (test #'eql) test-not (key #'identity))
Returns a list of elements of LIST1 that do not appear in LIST2.")

(docfun set-dispatch-macro-character function "
Args: (disp-char sub-char function &optional (readtable *readtable*))
Causes FUNCTION to be called when the DISP-CHAR followed by SUB-CHAR is
read.")

(docfun set-exclusive-or function "
Args: (list1 list2 &key (test #'eql) test-not (key #'identity))
Returns a list of elements appearing exactly once in LIST1 and LIST2.")

(docfun set-macro-character function "
Args: (char function
       &optional (non-terminating-p nil) (readtable *readtable*))
Causes CHAR to be a macro character that, when seen by READ, causes FUNCTION
to be called.")

(docfun set-syntax-from-char function "
Args: (to-char from-char
       &optional (to-readtable *readtable*) (from-readtable nil))
Makes the syntax of TO-CHAR in TO-READTABLE be the same as the syntax of
FROM-CHAR in FROM-READTABLE.")

(docfun setf macro "
Syntax: (setf {place newvalue}*)
Replaces the value in PLACE with the value of NEWVALUE, from left to right.
Returns the value of the last NEWVALUE.  Each PLACE may be any one of the
following:
  * A symbol that names a variable.
  * A function call form whose first element is the name of the following
    functions:
	nth	elt	subseq	rest	first ... tenth
	c?r	c??r	c???r	c????r
	aref	svref	char	schar	bit	sbit	fill-poiter
	get	getf	documentation	symbol-value	symbol-function
	symbol-plist	macro-function	gethash
	char-bit	ldb	mask-field
	apply
    where '?' stands for either 'a' or 'd'.
  * the form (THE type place) with PLACE being a place recognized by SETF.
  * a macro call which expands to a place recognized by SETF.
  * any form for which a DEFSETF or DEFINE-SETF-METHOD declaration has been
    made.")

(docfun setq special "
Syntax: (setq {var form}*)
VARs are not evaluated and must be symbols.  Assigns the value of the first
FORM to the first VAR, then assigns the value of the second FORM to the second
VAR, and so on.  Returns the last value assigned.")

(docfun seventh function "
Args: (x)
Equivalent to (CADDR (CDDDDR X)).")

(docfun shadow function "
Args: (symbols &optional (package *package*))
Creates an internal symbol in PACKAGE with the same name as each of the
specified SYMBOLS.  SYMBOLS must be a list of symbols or a symbol.")

(docfun shadowing-import function "
Args: (symbols &optional (package *package*))
Imports SYMBOLS into PACKAGE, disregarding any name conflict.  If a symbol
of the same name is already present, then it is uninterned.  SYMBOLS must
be a list of symbols or a symbol.")

(docfun shiftf macro "
Syntax: (shiftf {place}+ newvalue)
Evaluates all PLACEs and NEWVALUE in turn, then assigns the value of each
form to the PLACE on its left.  Returns the original value of the leftmost
form.")

(docvar short-float-epsilon constant "
The smallest positive short-float that satisfies
	(not (= (float 1 e) (+ (float 1 e) e))).")

(docvar short-float-negative-epsilon constant "
The smallest positive short-float that satisfies
	(not (= (float 1 e) (- (float 1 e) e))).")

(docfun short-site-name function "
Args: ()
Returns a string that identifies the physical location of the current KCL.")

(docfun signum function "
Args: (number)
If NUMBER is zero, returns NUMBER; else returns (/ NUMBER (ABS NUMBER)).")

(doctype simple-array "
A simple-array is an array that is not displaced to another array, has no
fill pointer, and is not to have its size adjusted.")

(doctype simple-bit-vector "
A simple-bit-vector is a bit-vector that is not displaced to another
bit-vector, has no fill pointer, and is not to have its size adjusted.")

(docfun simple-bit-vector-p function "
Args: (x)
Returns T if X is a simple bit-vector; NIL otherwise.")

(doctype simple-string "
A simple-string is a string that is not displaced to another string, has no
fill pointer, and is not to have its size adjusted.")

(docfun simple-string-p function "
Args: (x)
Returns T if X is a simple string; NIL otherwise.")

(doctype simple-vector "
A simple-vector is a vector that is not displaced to another vector, has no
fill pointer, and is not to have its size adjusted.")

(docfun simple-vector-p function "
Args: (x)
Returns T if X is a simple vector; NIL otherwise.")

(docfun sin function "
Args: (radians)
Returns the sine of RADIANS.")

(docvar single-float-epsilon constant "
Same as LONG-FLOAT-EPSILON.")

(docvar single-float-negative-epsilon constant "
Same as LONG-FLOAT-NEGATIVE-EPSILON.")

(docfun sinh function "
Args: (number)
Returns the hyperbolic sine of NUMBER.")

(docfun sixth function "
Args: (x)
Equivalent to (CADR (CDDDDR X)).")

(docfun sleep function "
Args: (n)
This function causes execution to be suspended for N seconds.  N may
be any non-negative, non-complex number.")

(docfun software-type function "
Args: ()
Returns a string that identifies the software type of the software
under which KCL is currently running.")

(docfun software-version function "
Args: ()
Returns a string that identifies the software version of the software
under which KCL is currently running.")

(docfun some function "
Args: (predicate sequence &rest more-sequences)
Returns T if at least one of the elements in SEQUENCEs satisfies PREDICATE;
NIL otherwise.")

(docfun sort function "
Args: (sequence predicate &key (key #'identity))
Destructively sorts SEQUENCE.  PREDICATE should return non-NIL if its first
argument is to precede its second argument.")

(docfun special-form-p function "
Args: (symbol)
Returns T if SYMBOL globally names a special form; NIL otherwise.
The special forms defined in Steele's manual are:

	block		if			progv
	catch		labels			quote
	compiler-let	let			return-from
	declare		let*			setq
	eval-when	macrolet		tagbody
	flet		multiple-value-call	the
	function	multiple-value-prog1	throw
	go		progn			unwind-protect

In addition, KCL implements the following macros as special forms, though
of course macro-expanding functions such as MACROEXPAND work correctly for
these macros.

	and		incf			prog1
	case		locally			prog2
	cond		loop			psetq
	decf		multiple-value-bind	push
	defmacro	multiple-value-list	return
	defun		multiple-value-set	setf
	do		or			unless
	do*		pop			when
	dolist		prog
	dotimes		prog* ")

(docfun sqrt function "
Args: (number)
Returns the principal square root of NUMBER.")

(docfun stable-sort function "
Args: (sequence predicate &key (key #'identity))
Destructively sorts SEQUENCE.  PREDICATE should return non-NIL if its first
argument is to precede its second argument.")

(doctype standard-char "
A standard-char is a space character (#\\Space), a newline character
(#\\Newline,) or a character that represents one of the following letters.

	!  \"  #  $  %  &  '  (  )  *  +  ,  -  .  /  0  1  2  3  4
	5  6  7  8  9  :  ;  <  =  >  ?  @  A  B  C  D  E  F  G  H
	I  J  K  L  M  N  O  P  Q  R  S  T  U  V  W  X  Y  Z  [  \\
	]  ^  _  `  a  b  c  d  e  f  g  h  i  j  k  l  m  n  o  p
	q  r  s  t  u  v  w  x  y  z  {  |  }  ~ ")

(docfun standard-char-p function "
Args: (char)
Returns T if CHAR is a standard character, i.e., one of the 95 ASCII printing
characters #\\Space to #\\~ and #\Newline; NIL otherwise.")

(docvar *standard-input* variable "
The default input stream used by the KCL reader.")

(docvar *standard-output* variable "
The default output stream used by the KCL printer.")

(docfun step macro "
Syntax: (step form)
Evaluates FORM in the single-step mode and returns the value.")

(doctype stream "
A stream is a source or sink of data, typically characters or bytes.
A stream is denoted in one of the following ways:
	#<input stream ??>		?? being a file name
	#<output stream ??>		?? being a file name
	#<string-input stream from ??>	?? being a string
	#<a string-output stream>
	#<a two-way stream>
	#<an echo stream>
	#<synonym stream to ??>		?? being a symbol
	#<a concatenated stream>
	#<a broadcast stream>")

(docfun stream-element-type function "
Args: (stream)
Returns a type specifier for the kind of object returned by STREAM.")

(docfun streamp function "
Args: (x)
Returns T if X is a stream object; NIL otherwise.")

(doctype string "
A string is a vector of characters.  A string is denoted by surrounding
the characters with double quotes '\"'.
Some strings may be displaced to another string, may have a fill pointer,
or may be adjusted its size.  Other strings are called simple strings.")

(docfun string function "
Args: (x)
Coerces X into a string.  If X is a string, then returns X itself.  If X is a
symbol, then returns X's print name.  If X is a character, then returns a one
element string containing that character.  Signals an error if X cannot be
coerced into a string.")

(docfun string-capitalize function "
Args: (string &key (start 0) (end (length string)))
Returns a copy of STRING with the first character of each word converted to
upper-case, and remaining characters in the word converted to lower case.")

(doctype string-char "
A string-char is a character whose bits and font attributes are zero.
Any KCL character is a string-character.")

(docfun string-char-p function "
Args: (char)
Returns T if CHAR can be stored in a string.  In KCL, this function always
returns T since any character in KCL can be stored in a string.")

(docfun string-downcase function "
Args: (string &key (start 0) (end (length string)))
Returns a copy of STRING with all upper case characters converted to
lowercase.")

(docfun string-equal function "
Args: (string1 string2
       &key (start1 0) (end1 (length string1))
            (start2 0) (end2 (length string2)))
Given two strings (string1 and string2), and optional integers start1,
start2, end1 and end2, compares characters in string1 to characters in
string2 (using char-equal).")

(docfun string-greaterp function "
Args: (string1 string2
       &key (start1 0) (end1 (length string1))
            (start2 0) (end2 (length string2)))
Similar to STRING>, but ignores cases.")

(docfun string-left-trim function "
Args: (char-bag string)
Returns a copy of STRING with the characters in CHAR-BAG removed from the
left end.")

(docfun string-lessp function "
Args: (string1 string2
       &key (start1 0) (end1 (length string1))
            (start2 0) (end2 (length string2)))
Similar to STRING<, but ignores cases.")

(docfun string-not-equal function "
Args: (string1 string2
       &key (start1 0) (end1 (length string1))
            (start2 0) (end2 (length string2)))
Similar to STRING\=, but ignores cases.")

(docfun string-not-greaterp function "
Args: (string1 string2
       &key (start1 0) (end1 (length string1))
            (start2 0) (end2 (length string2)))
Similar to STRING<=, but ignores cases.")

(docfun string-not-lessp function "
Args: (string1 string2
       &key (start1 0) (end1 (length string1))
            (start2 0) (end2 (length string2)))
Similar to STRING>=, but ignores cases.")

(docfun string-right-trim function "
Args: (char-bag string)
Returns a copy of STRING with the characters in CHAR-BAG removed from the
right end.")

(docfun string-trim function "
Args: (char-bag string)
Returns a copy of STRING with the characters in CHAR-BAG removed from both
ends.")

(docfun string-upcase function "
Args: (string &key (start 0) (end (length string)))
Returns a copy of STRING with all lower case characters converted to
uppercase.")

(docfun string/= function "
Args: (string1 string2
       &key (start1 0) (end1 (length string1))
            (start2 0) (end2 (length string2)))
Returns NIL if STRING1 and STRING2 are character-wise CHAR=.  Otherwise,
returns the index to the longest common prefix of the strings.")

(docfun string< function "
Args: (string1 string2
       &key (start1 0) (end1 (length string1))
            (start2 0) (end2 (length string2)))
If STRING1 is lexicographically less than STRING2, then returns the longest
common prefix of the strings.  Otherwise, returns NIL.")

(docfun string<= function "
Args: (string1 string2
       &key (start1 0) (end1 (length string1))
            (start2 0) (end2 (length string2)))
If STRING1 is lexicographically less than or equal to STRING2, then returns
the longest common prefix of the two strings.  Otherwise, returns NIL.")

(docfun string= function "
Args: (string1 string2
       &key (start1 0) (end1 (length string1))
            (start2 0) (end2 (length string2)))
Returns T if the two strings are character-wise CHAR=; NIL otherwise.")

(docfun string> function "
Args: (string1 string2
       &key (start1 0) (end1 (length string1))
            (start2 0) (end2 (length string2)))
If STRING1 is lexicographically greater than STRING2, then returns the
longest common prefix of the strings.  Otherwise, returns NIL.")

(docfun string>= function "
Args: (string1 string2
       &key (start1 0) (end1 (length string1))
            (start2 0) (end2 (length string2)))
If STRING1 is lexicographically greater than or equal to STRING2, then returns
the longest common prefix of the strings.  Otherwise, returns NIL.")

(docfun stringp function "
Args: (x)
Returns T if X is a string; NIL otherwise.")

(doctype structure "
Structures are instances of user-defined data types that have a fixed number
of named components.  In the simplest case, a structure is denoted as
	#s(structure-name slot-value1 ... slot-valuen)")

(docfun sublis function "
Args: (alist tree &key (test #'eql) test-not (key #'identity))
Substitutes from ALIST for subtrees of TREE nondestructively.")

(docfun subseq function "
Args: (sequence start &optional (end (length sequence)))
Returns a copy of a subsequence of SEQUENCE between START (inclusive) and
END (exclusive).")

(docfun subsetp function "
Args: (list1 list2 &key (test #'eql) test-not (key #'identity))
Returns T if every element of LIST1 appears in LIST2; NIL otherwise.")

(docfun subst function "
Args: (new old tree &key (test #'eql) test-not (key #'identity))
Substitutes NEW for subtrees of TREE that match OLD.")

(docfun subst-if function "
Args: (new test tree &key (key #'identity))
Substitutes NEW for subtrees of TREE that satisfy TEST.")

(docfun subst-if-not function "
Args: (new test tree &key (key #'identity))
Substitutes NEW for subtrees of TREE that do not satisfy TEST.")

(docfun substitute function "
Args: (newitem olditem sequence
       &key (from-end nil) (test #'eql) test-not (start 0)
            (end (length sequence)) (count most-positive-fixnum)
            (key #'identity))
Returns a sequence of the same kind as SEQUENCE with the same elements
except that OLDITEMs are replaced with NEWITEM.")

(docfun substitute-if function "
Args: (newitem test sequence
       &key (from-end nil) (start 0) (end (length sequence))
            (count most-positive-fixnum) (key #'identity))
Returns a sequence of the same kind as SEQUENCE with the same elements
except that all elements satisfying TEST are replaced with NEWITEM.")

(docfun substitute-if-not function "
Args: (new test sequence
       &key (from-end nil) (start 0) (end (length sequence))
            (count most-positive-fixnum) (key #'identity))
Returns a sequence of the same kind as SEQUENCE with the same elements
except that all elements not satisfying TEST are replaced with NEWITEM.")

(docfun subtypep function "
Args: (type1 type2)
Returns T if TYPE1 is a subtype of TYPE2; NIL otherwise.  If it could not
determine, then returns NIL as the second value.  Otherwise, the second value
is T.")

(docfun svref function "
Args: (simple-vector index)
Returns the INDEX-th element of SIMPLE-VECTOR.")

(docfun sxhash function "
Args: (object)
Computes a hash code for OBJECT and returns it as an integer.")

(docfun symbol-function function "
Args: (symbol)
Returns the current global function definition named by SYMBOL.")

(docfun symbol-name function "
Args: (symbol)
Returns the print name of the symbol SYMBOL.")

(docfun symbol-package function "
Args: (symbol)
Returns the contents of the package cell of the symbol SYMBOL.")

(docfun symbol-plist function "
Args: (symbol)
Returns the property list of SYMBOL.")

(docfun symbol-value function "
Args: (symbol)
Returns the current value of the dynamic (special) variable named by SYMBOL.")

(docfun symbolp function "
Args: (x)
Returns T if X is a symbol; NIL otherwise.")

#+unix
(docfun system function "
Args: (string)
KCL specific: Executes a Shell command as if STRING is an input to the Shell.
Not all versions of KCL support this function.")

(doctype t "
The type T is a supertype of every type.")

(docvar t constant "
Holds T.")

(docfun tagbody special "
Syntax: (tagbody {tag | statement}*)
Executes STATEMENTs and returns NIL if it falls off the end.")

(docfun tailp function "
Args: (sublist list)
Returns T if SUBLIST is one of the conses in LIST; NIL otherwise.")

(docfun tan function "
Args: (radians)
Returns the tangent of RADIANS.")

(docfun tanh function "
Args: (number)
Returns the hyperbolic tangent of NUMBER.")

(docfun tenth function "
Args: (x)
Equivalent to (CADR (CDDDDR (CDDDDR X))).")

(docvar *terminal-io* variable "
The terminal I/O stream.")

#+aosvs
(docfun termination-message function "
Args: ()
KCL specific: Returns the termination message of the son as a string.
Only KCL/AOS supports this function.")

(docfun terpri function "
Args: (&optional (stream *standard-output*))
Outputs a newline character.")

(docfun the special "
Syntax: (the value-type form)
Declares that the value of FORM must be of VALUE-TYPE.  Signals an error if
this is not the case.")

(docfun third function "
Args: (x)
Equivalent to (CADDR X).")

(docfun throw special "
Syntax: (throw tag result)
Evaluates TAG and aborts the execution of the most recent CATCH form that sets
up a catcher with the same tag value.  The CATCH form returns whatever RESULT
returned.")

(docfun time macro "
Syntax: (time form)
Evaluates FORM and outputs timing statistics on *TRACE-OUTPUT*.")

(docfun trace macro "
Syntax: (trace {function-name}*)
Traces the specified functions.  With no FUNCTION-NAMEs, returns a list of
functions currently being traced.")

(docvar *trace-output* variable "
The trace output stream.")

(docfun tree-equal function "
Args: (x y &key (test #'eql) test-not)
Returns T if X and Y are isomorphic trees with identical leaves.")

(docfun truename function "
Args: (pathname)
Returns the pathname for the actual file described by PATHNAME.")

(docfun truncate function "
Args: (number &optional (divisor 1))
Returns NUMBER/DIVISOR as an integer, rounded toward 0.  The second returned
value is the remainder.")

(docfun type-of function "
Args: (x)
Returns the type of X.")

(docfun typecase macro "
Syntax: (typecase keyform {(type {form}*)}*)
Evaluates KEYFORM and tries to find the TYPE in which the value of KEYFORM
belongs.  If one is found, then evaluates FORMs that follow the KEY and
returns the value of the last FORM.  If not, simply returns NIL.")

(docfun typep function "
Args: (x type)
Returns T if X is of the type TYPE; NIL otherwise.")

(docfun unexport function "
Args: (symbols &optional (package *package*))
Makes SYMBOLS no longer accessible as external symbols in PACKAGE.  SYMBOLS
must be a list of symbols or a symbol.")

(docfun unintern function "
Args: (symbol &optional (package *package*))
Makes SYMBOL no longer present in PACKAGE.  Returns T if SYMBOL was present;
NIL otherwise.  If PACKAGE is the home package of SYMBOL, then makes SYMBOL
uninterned.")

(docfun union function "
Args: (list1 list2 &key (test #'eql) test-not (key #'identity))
Returns the union of LIST1 and LIST2.")

(docfun unless macro "
Syntax: (unless test {form}*)
If TEST evaluates to NIL, then evaluates FORMs as a PROGN.  If not,
simply returns NIL.")

(docfun unread-char function "
Args: (character &optional (stream *standard-input*))
Puts CHARACTER back on the front of the input stream STREAM.")

(docfun untrace macro "
Syntax: (untrace {function-name}*)
Removes tracing from the specified functions.  With no FUNCTION-NAMEs,
untraces all functions.")

(docfun unuse-package function "
Args: (packages-to-unuse &optional (package *package*))
Removes PACKAGES-TO-UNUSE from the use list for PACKAGE.")

(docfun unwind-protect special "
Syntax: (unwind-protect protected-form {cleanup-form}*)
Evaluates PROTECTED-FORM and returns whatever it returned.  Guarantees that
CLEANUP-FORMs be always evaluated before exiting from the UNWIND-PROTECT
form.")

(docfun upper-case-p function "
Args: (char)
Returns T if CHAR is an upper-case character; NIL otherwise.")

(docfun use-package function "
Args: (packages-to-use &optional (package *package*))
Adds all packages in PACKAGE-TO-USE list to the use list for PACKAGE so that
the external symbols of the used packages are available as internal symbols
in PACKAGE.")

(docfun user-homedir-pathname function "
Args: (&optional host)
Returns the home directory of the logged in user as a pathname.  HOST
is ignored.")

(docfun values function "
Args: (&rest args)
Returns ARGs in order, as values.")

(docfun values-list function "
Args: (list)
Returns all of the elements of LIST in order, as values.")

(doctype vector "
A vector is a one-dimensional array.  Strings and bit-vectors are kinds of
vectors.  Other vectors are called general vectors and are denoted as
	#(elem0 ... elemn)
where n is the length of the vector minus one.
Some vectors may be displaced to another vector, may have a fill pointer,
or may be adjusted its size.  Other vectors are called simple vectors.")

(docfun vector function "
Args: (&rest objects)
Constructs a Simple-Vector from the given objects.")

(docfun vector-pop function "
Args: (vector)
Attempts to decrease the fill-pointer of VECTOR by 1 and returns the element
pointed to by the new fill pointer.  Signals an error if the old value of
the fill pointer is 0.")

(docfun vector-push function "
Args: (new-element vector)
Attempts to set the element of ARRAY designated by its fill pointer to
NEW-ELEMENT and increments the fill pointer by one.  Returns NIL if the fill
pointer is too large.  Otherwise, returns the new fill pointer value.")

(docfun vector-push-extend function "
Args: (new-element vector &optional (extension (length vector)))
Similar to VECTOR-PUSH except that, if the fill pointer gets too large,
extends VECTOR rather then simply returns NIL.")

(docfun vectorp function "
Args: (x)
Returns T if X is a vector; NIL otherwise.")

(docfun warn function "
Args: (format-string &rest args)
Formats FORMAT-STRING and ARGs to *ERROR-OUTPUT* as a warning message.")

(docfun when macro "
Syntax: (when test {form}*)
If TEST evaluates to non-NIL, then evaluates FORMs as a PROGN.  If not,
simply returns NIL.")

(docfun with-input-from-string macro "
Syntax: (with-input-from-string (var string {keyword value}*) {decl}* {form}*)
Binds VAR to an input stream that returns characters from STRING and evaluates
the FORMs.  The stream is automatically closed on exit.  Allowed keywords are
:INDEX, :START, and :END.")

(docfun with-open-file macro "
Syntax: (with-open-file (stream filename {options}*) {decl}* {form}*)
Opens the file whose name is FILENAME, using OPTIONs, and binds the variable
STREAM to a stream to/from the file.  Then evaluates FORMs as a PROGN.
The file is automatically closed on exit.")

(docfun with-open-stream macro "
Syntax: (with-open-stream (var stream) {decl}* {form}*)
Evaluates FORMs as a PROGN with VAR bound to the value of STREAM.  The stream
is automatically closed on exit.")

(docfun with-output-to-string macro "
Syntax: (with-output-to-string (var [string]) {decl}* {form}*)
Binds VAR to a string output stream that puts characters into STRING, which
defaults to a new string.  The stream is automatically closed on exit and
the string is returned.")

(docfun write function "
Args: (object &key (stream *standard-output*) (escape *print-escape*)
                   (radix *print-radix*) (base *print-base*)
                   (circle *print-circle*) (pretty *print-pretty*)
                   (level *print-level*) (length *print-length*)
                   (case *print-case*) (array *print-array*)
                   (gensym *print-gensym*))
Prints OBJECT in the specified mode.  See the variable docs of *PRINT-...*
for the mode.")

(docfun write-byte function "
Args: (integer stream)
Outputs INTEGER to the binary stream STREAM.  Returns INTEGER.")

(docfun write-char function "
Args: (char &optional (stream *standard-output*))
Outputs CHAR and returns it.")

(docfun write-line function "
Args: (string &optional (stream *standard-output*)
              &key (start 0) (end (length string)))
Outputs STRING and then outputs a newline character.  Returns STRING.")

(docfun write-string function "
Args: (string &optional (stream *standard-output*)
              &key (start 0) (end (length string)))
Outputs STRING and returns it.")

(docfun write-to-string function "
Args: (object &key (escape *print-escape*) (radix *print-radix*)
                   (base *print-base*) (circle *print-circle*)
                   (pretty *print-pretty*) (level *print-level*)
                   (length *print-length*) (case *print-case*)
                   (array *print-array*) (gensym *print-gensym*))
Returns as a string the printed representation of OBJECT in the specified
mode.  See the variable docs of *PRINT-...* for the mode.")

(docfun y-or-n-p function "
Args: (&optional (format-string nil) &rest args)
Asks the user a question whose answer is either 'Y' or 'N'.  If FORMAT-STRING
is non-NIL, then FRESH-LINE operation is performed, a message is printed as
if FORMAT-STRING and ARGs were given to FORMAT, and then a prompt
\"(Y or N)\" is printed.  Otherwise, no prompt will appear.")

(docfun yes-or-no-p function "
Args: (&optional (format-string nil) &rest args)
Asks the user a question whose answer is either 'YES' or 'NO'.  If FORMAT-
STRING is non-NIL, then FRESH-LINE operation is performed, a message is
printed as if FORMAT-STRING and ARGs were given to FORMAT, and then a prompt
\"(Yes or No)\" is printed.  Otherwise, no prompt will appear.")

(docfun zerop function "
Args: (number)
Returns T if NUMBER = 0; NIL otherwise.")





;;; System Internals

(docfun si:address function "
Args: (object)
KCL specific: Returns the address of the OBJECT as a fixnum.  The address of
an object depends on the version of KCL.  E.g. (SI:ADDRESS NIL) returns
1879062044 on KCL/AOSVS dated March 14, 1986.")

(docfun si:argc function "
Args: ()
KCL specific: Returns the number of arguments on the command line that invoked
the KCL process.")

(docfun si:argv function "
Args: (fixnum)
KCL specific: Returns the FIXNUM-th argument on the command line that invoked
the KCL process.")

(docfun si:bds-val function "
Args: (i)
KCL specific: Returns the value of the i-th entity in the bind stack.")

(docfun si:bds-var function "
Args: (i)
KCL specific: Returns the symbol of the i-th entity in the bind stack.")

#+(or bsd mips)
(docfun si:catch-bad-signals function "
Args: ()
KCL/BSD and KCL/MIPS specific: Installs a signal catcher for bad signals:
	SIGILL, SIGIOT, SIGEMT, SIGBUS, SIGSEGV, SIGSYS.
The signal catcher, upon catching the signal, signals an error (and enter
the break-level).  Since the internal memory of KCL may be broken, the user
should check the signal and exit from KCL if necessary.  When the signal
is caught during garbage collection, KCL terminates immediately.")

#+unix
(docfun si:chdir function "
Args: (pathname)
KCL/UNIX specific: Changes the current working directory to the specified
pathname.")

(docfun si:compiled-function-name function "
Args: (compiled-function-object)
KCL specific: Returns the name of the COMPILED-FUNCTION-OBJECT.")

(docfun si:copy-stream function "
Args: (in-stream out-stream)
KCL specific: Copies IN-STREAM to OUT-STREAM until the end-of-file on IN-
STREAM.")

#+aosvs
(docfun si:create-ipc-file function "
Args: (pathname local-port-number)
KCL/AOSVS specific: Creates an IPC file with the name PATHNAME and with
the specified LOCAL-PORT-NUMBER.  LOCAL-PORT-NUMBER should be a fixxnum.")

(docvar si:*default-time-zone* variable "
KCL specific: Holds the default time zone.  The initial value of SI:*DEFAULT-
TIME-ZONE* is -9 (the time zone of Japan).")

(docfun si:displaced-array-p function "
Args (array)
KCL specific: Returns T if the ARRAY is a displaced array; NIL otherwise.")

(docfun si:frs-bds function "
Args: (i)
KCL specific: Returns the bind stack index of the i-th entity in the frame
stack.")

(docfun si:frs-ihs function "
Args: (i)
KCL specific: Returns the invocation history stack index of the i-th entity
in the frame stack.")

(docfun si:frs-vs function "
Args: (i)
KCL specific: Returns the value stack index of the i-th entity in the frame
stack.")

(docfun si:error-set function "
Args: (form)
KCL specific: Evaluates the FORM in the null environment.  If the evaluation
of the FORM has successfully completed, SI:ERROR-SET returns NIL as the first
value and the result of the evaluation as the rest of the values.  If, in the
course of the evaluation, a non-local jump from the FORM is atempted,
SI:ERROR-SET traps the jump and returns the corresponding jump tag as its
value.")

#+(or bsd mips)
(docfun si:faslink function "
Args: (file string)
KCL/BSD KCL/MIPS specific: Loads the FASL file FILE while linking the object files and
libraries specified by STRING.  For example,
	(faslink \"foo.o\" \"bar.o boo.o -lpixrect\")
loads foo.o while linking two object files (bar.o and boo.o) and the library
pixrect.  Usually, foo.o consists of the C language interface for the
functions defined in the object files or the libraries.")

(docfun si:fixnump function "
Args: (object)
KCL specific: Returns T if the OBJECT is a fixnum; NIL otherwise.")

(docvar si:*gbc-message* variable "
KCL specific: If the value of SI:*GBC-MESSAGE* is non-NIL, the garbage
collector prints some information on the terminal.  Usually SI:*GBC-MESSAGE*
should be set NIL.")

(docfun si:get-string-input-stream-index function "
Args: (string-input-stream)
KCL specific: Returns the current index of the STRING-INPUT-STREAM.")

#+unix
(docfun si:getenv function "
Args: (string)
KCL/UNIX specific: Returns the environment with the name STRING as a string;
if the environment specified by STRING is not found, returns NIL.")

(docfun si:get-hole-size function "
Args: ()
KCL specific: Returns as a fixnum the size of the memory hole (in pages).")

(docvar si:*ignore-eof-on-terminal-io* variable "
KCL specific: If the value of SI:*IGNORE-EOF-ON-TERMINAL-IO* is non-NIL, KCL
ignores the eof-character (usually ^D) on the terminal and the terminal never
becomes end-of-file.  The default value of SI:*IGNORE-EOF-ON-TERMINAL-IO* is
NIL.")

(docfun si:ihs-fun function "
Args: (i)
KCL specific: Returns the function value of the i-th entity in the invocation
history stack.")

(docfun si:ihs-vs function "
Args: (i)
KCL specific: Returns the value stack index of the i-th entity in the
invocation history stack.")

#+aosvs
(docfun si:ilkup function "
Args: (pathname)
KCL/AOSVS specific: Returns the global port number of the IPC file specified
by the PATHNAME.")

(docvar si:*indent-formatted-output* variable "
KCL specific: The FORMAT directive ~% indents the next line if the value of
this variable is non-NIL.  If NIL, ~% simply does Newline.")

(docfun si:init-system function "
Args: ()
KCL specific: Initializes the library and the compiler of KCL.  Since they
have already been initialized in the standard image of KCL, calling SI:INIT-
SYSTEM will cause an error.")

(docvar si:*interrupt-enable* variable "
KCL specific: If the value of SI:*INTERRUPT-ENABLE* is non-NIL, KCL signals
an error on the terminal interrupt (this is the default case).  If it is NIL,
KCL ignores the interrupt and assigns T to SI:*INTERRUPT-ENABLE*.")

#+aosvs
(docfun si:irec function "
Args: (global-port-number local-port-number string)
KCL/AOSVS specific: Receives a message from the specified port into the
STRING.  GLOBAL-PORT-NUMBER and LOCAL-PORT-NUMBER should be fixnums.  The
STRING should have a fill-pointer.")

#+aosvs
(docfun si:isend function "
Args: (global-port-number local-port-number string)
KCL/AOSVS specific: Sends a message in the STRING to the specified port.
GLOBAL-PORT-NUMBER and LOCAL-PORT-NUMBER should be fixnums.")

(docvar si:*lisp-maxpages* variable "
KCL specific: Holds the maximum number of pages (1 page = 2048 bytes) for the
KCL process.  The result of changing the value of SI:*LISP-MAXPAGES* is
unpredictable.")

(docfun si:*make-constant function "
Args: (symbol value)
KCL specific: Makes the SYMBOL a constant with the specified VALUE.")

(docfun si:*make-special function "
Args (symbol)
KCL specific: Makes the SYMBOL globally special.")

(docfun si:make-string-output-stream-from-string function "
Args (string)
KCL specific: Creates a string-output-stream corresponding to the STRING and
returns it.  The STRING should have a fill-pointer.")

(docfun si:nani function "
Args: (fixnum)
KCL specific: Returns the object in the address FIXNUM.  This function is
the inverse of SI:ADDRESS.  Although SI:ADDRESS is a harmless operation,
SI:NANI is quite dangerous and should be used with care.")

(docvar si:*notify-gbc* variable "
KCL specific: If the value of this variable is non-NIL, then the garbage
collector notifies that it begins to run whenever it is invoked.  Otherwise,
garbage collection begins silently.")

(docfun si:output-stream-string function "
Args: (string-output-stream)
KCL specific: Returns the string corresponding to the STRING-OUTPUT-STREAM.")

(docfun si:reset-gbc-count function "
Args: ()
KCL specific: Resets the counter of the garbage collector that records how
many times the garbage collector has been called for each implementation
type.")

(docfun si:reset-stack-limits function "
Args: ()
KCL specific: Resets the stack limits to the normal state.  When a stack has
overflowed, KCL extends the limit for the stack in order to execute the error
handler.  After processing the error, KCL resets the stack limit by calling
SI:RESET-STACK-LIMITS.")

(docfun si:save-system function "
Args: (pathname)
KCL specific: Saves the current KCL core imange into a program file specified
by PATHNAME.  This function differs from SAVE in that the contiguous and
relocatable areas are made permanent in the saved image.  Usually the
standard image of KCL interpreter/compiler is saved by SI:SAVE-SYSTEM.")

(docfun si:set-hole-size function "
Args: (fixnum)
KCL specific: Sets the size of the memory hole (in pages).")

(docfun si:specialp function "
Args: (symbol)
KCL specific: Returns T if the SYMBOL is a globally special variable; NIL
otherwise.")

(docfun si:string-concatenate function "
Args: (&rest strings)
KCL specific: Returns the result of concatenating the given STRINGS.")

(docfun si:string-to-object function "
Args: (string)
KCL specific: (SI:STRING-TO-OBJECT STRING) is equivalent to
(READ-FROM-STRING STRING), but much faster.")

(docfun si:structurep function "
Args: (object)
KCL specific: Returns T if the OBJECT is a structure; NIL otherwise.")

(docvar si:*system-directory* variable "
KCL specific: Holds the name of the system directory of KCL.")

(docfun si:top-level function "
Args: ()
KCL specific: Starts the standard top-level listner of KCL.  When the KCL
process is invoked, it calls SI:TOP-LEVEL by (FUNCALL 'SI:TOP-LEVEL).
     To change the top-level of KCL, redefine SI:TOP-LEVEL and save the core
imange in a file.  When the saved imange is invoked, it will start the
redefined top-level.")

(docfun si:universal-error-handler function "
Args: (error-name correctable function-name
       continue-format-string error-format-string
       &rest args)
KCL specific: Starts the error handler of KCL.  When an error is detected,
KCL calls SI:UNIVERSAL-ERROR-HANDLER with the specified arguments.
ERROR-NAME is the name of the error.  CORRECTABLE is T for a correctable
error and NIL for a fatal error.  FUNCTION-NAME is the name of the function
that caused the error.  CONTINUE-FORMAT-STRING and ERROR-FORMAT-STRING are
the format strings of the error message.  ARGS are the arguments to the
format strings.
     To change the error handler of KCL, redefine SI:UNIVERSAL-ERROR-
HANDLER.")

#+(or bsd mips)
(docfun si:uncatch-bad-signals function "
Args: ()
KCL/BSD KCL/MIPS specific: Undoes the effect of SI:CATCH-BAD-SIGNALS.")

(docfun si:vs function "
Args: (i)
KCL specific: Returns the i-th entity in the value stack.")

