/*
(C) Copyright Taiichi Yuasa and Masami Hagiya, 1984.  All rights reserved.
*/


	/**********************************************************
 	* Copyright (C) Data General Corporation, 1982-1983.      *
 	* All Rights Reserved.                                    *
 	* Licensed Material-Property of Data General Corporation. *
 	**********************************************************/



/*****************   number of allowed files ******************/

#define NFILZ	64

/******************   AOS_VS call packets *********************/

#define _uchar unsigned char


struct blk_pkt {
	_uchar 	psti_status,
		psti_count;
	short	psto,
		*pcad;
	long	prnh;
	short	prcl,
		pres,
		_pch;		/* gamma extension */
	long	_fsize;		/* gamma extension */
        short   _disk;          /* gamma extension */
	};

struct cpd_pkt {
	short	cftyp,
		chfs;
	long	*ctim;
	char	*cacp;
	long 	cmsh;
	short	cmil,
		cmrs;
	};

struct create_pkt {
	short	cftyp,
		ccps;
	long	*ctim;
	char	*cacp;
	short	cdeh,
		cdel,
		cmil,
		cmrs;
	};

struct _msg_pkt {
	short 	greq,
		gnum;
	char	*gsw,
		*gres;
	};

struct exec_pkt {
	short	xrfnc,
		xfp1;
	char	*xfp2;
	};

struct gnfn_pkt {
	short	nfky,
		nfrs;
	char	*nfnm,
		*nftp;
	};

struct dir_pkt{ /* pseudo-packet */
        short           ich, isti;      /* channel and options */
        char *          path;           /* saved pathname of dir */
        char *          endpath;        /* place to cat fname    */
        char *          buf;            /* charptr to direct struct */
        char *          cur;            /* current buffer pos */
        struct gnfn_pkt pkt;            /* packet to use for gnfn */
        };

#define MAXPIPE 1024/*for now*/

struct pipe_member_t{ /* info of a single pipe member */
        int             lock, sleeping; /* double word aligned */
        short           count,          /* number of this type member */
                        index;          /* ring buffer index */
        };

struct pipe_buf_t{ /* 'shape' of shared memory used by pipes */
        struct
          pipe_member_t reader, writer; /* parties to this pipe */
        char            data[ MAXPIPE ];/* ring buffer */
        };

struct pipe_pkt{ /* pseudo-packet */
        short                ich, isti; /* channel and options */
        struct pipe_buf_t *  buf;       /* shared memory for pipe */
        };

struct gopn_pkt {
	short	opch,
		opty,
		opfc,
		opew;
	long	opeh;
	};

struct ipc_pkt {
	short	isfl,
		iufl,
		idph,
		idpl,
		iopn,
		ilth,
		*iptr;
	};

struct io_pkt {
	short	ich,
		isti,
		isto,
		imrs;
	char	*ibad;
	short	ires,
		ircl,
		irlr,
		irnw;
	long	irnh;
	char	*ifnp;
	short	*idel,
		*etsp,
		*etft,
		*etlt,
		*enet;

	short	esfc,
		esep;
	_uchar	escr_col,
		escr_row;
	};

struct proc_pkt {
	short	pflg,
		ppri;
	char	*psnm;
	short	*pipc;
	char	*pnm;
	long	pmem;
	char	*pdir,
		*pcon;
	short	pcal,
		pwss;
	char	*punm;
	short	pprv,
		ppcr,
		pwmi,
		p_gotcha;		/* it ain't documented */
	char	*pifp,
		*pofp,
		*plfp,
		*pdfp;
	long 	smch;
	short	plth;
	};

struct runtm_pkt {
	long	grr,
		grc,
		gri,
		grp;
	};

struct stat_pkt {
	short	styp,
		stim,
		sacp,
		scps,
		slau;
	long	sdeh;
	short	smil;
	unsigned short	stch,
			stcl,
			stah,
			stal,
			stmh,
			stml;
	short	ssts,
		sefw,
		sefh;
	long	sefm,
		sfah;
	short	sidx,
		sopn;
	long	scsh;
	};


/***************    F I L E   I N F O   **************************/

	/* the i/o packet for use in chnl_info */

typedef union {
	struct	io_pkt	  nio;		/* normal i/o */
	struct	gopn_pkt  gopn;		/* block open */
        struct  blk_pkt   bio;          /* block i/o */
        struct  dir_pkt   dio;          /* directory i/o */
        struct  pipe_pkt  pio;          /* pipe i/o */
	} io_blk;

	/* the channel info block */

struct ch_info {			/* channel info */
	io_blk	pkt;			/* the AOS io pkt */
	int	(*_read)(),		/* ptr to read routine */
		(*_write)(),		/* ptr to write routine */
		(*_close)();		/* ptr to close routine */
	short 	oc,			/* open count */
		f_mode,			/* mode used to open */
		f_info;			/* see info defines */
        };

		/* mode values for open */

#define RW	2
#define WO	1
#define RO 	0
#define DSR	-1
#define CWRIT	-2
#define APPND	-3
#define XO	-4		/* exclusive - create - I/O */
#define APIO	-5		/* read/write append */
#define UPD	-6		/* update */
#define BINR	-7		/* binary read */
#define BINW	-8		/* binary write */
#define CRW     -9              /* create & open RW */

#define LAST_NORMAL     CRW     /* update when adding nio type open */
        /* DG specific open modes */
#define BLK	-50
#define SPG	-51
        /* pseudo-packet modes */
#define PR      -100            /* pipe read */
#define PW      -101            /* pipe write */
#define DIRMODE -102            /* directory read */
#define RSRV    -103            /* reserve a descriptor & chnl blk */
	/* pseudo opens - used by exec */
#define DUPFIL	-120

	/* defines for dealing with file open modes */
#define NIO_MODE(mode)	(mode>=LAST_NORMAL)

	/* define to obtain AOS pkt location */

#define GET_PKT(fd)	_fdl[fd]

/****************    G L O B A L S     ******************************/


struct ch_info          _chnl_blk       [NFILZ],
                *       _fdl            [NFILZ];
char                    _clex           [NFILZ];
