/*
(c) Copyright Taiichi Yuasa and Masami Hagiya, 1984.  All rights reserved.
Copying of this file is authorized to users who have executed the true and
proper "License Agreement for Kyoto Common LISP" with SIGLISP.
*/

/*
	unixsave.c
*/

#include "include.h"

/* When MACHINE is S3000, use fcntl.h */
#ifdef S3000
#include <fcntl.h>
#else
#include <sys/file.h>
#endif


#ifdef BSD 
#include <a.out.h>
#endif

#ifdef VAX
#define	PAGSIZ		1024
#define	SEGSIZ		1024
#define	TXTRELOC	0
#endif

#ifdef ISI



#endif

#ifdef SEQ


#endif

#ifdef NEWS
#define	TXTRELOC	0
#endif

#ifdef IBMRT



#endif

#if defined ATT || defined ULTRIX_MIPS
#include <filehdr.h>
#include <aouthdr.h>
#include <scnhdr.h>

#ifdef ULTRIX_MIPS
#include <sym.h>
#endif

#define exec		aouthdr
#define a_text		tsize
#define a_data		dsize
#define a_bss		bsize
#endif

#ifdef E15
#include <a.out.h>
extern	etext;
#define exec		bhdr
#define a_text		tsize
#define a_data		dsize
#define a_bss		bsize
#define a_syms		ssize
#define a_trsize	rtsize
#define a_drsize	rdsize
#define	SEGSIZ		(128*1024)
#define	TXTRELOC	(1024*1024)
#endif


filecpy(to, from, n)
FILE *to, *from;
register int n;
{
	char buffer[BUFSIZ];
	struct filehdr fileheader;
	struct exec header;

	for (;;)
		if (n > BUFSIZ) {
			fread(buffer, BUFSIZ, 1, from);
			fwrite(buffer, BUFSIZ, 1, to);
			n -= BUFSIZ;
		} else if (n > 0) {
			fread(buffer, 1, n, from);
			fwrite(buffer, 1, n, to);
			break;
		} else
			break;
}


memory_save(original_file, save_file)
char *original_file, *save_file;
{

#ifdef BSD 
	struct exec header;
	int stsize;
#endif

#if defined ATT || defined ULTRIX_MIPS
	struct filehdr fileheader;
	struct exec header;
	struct scnhdr sectionheader;
	int diff;
#ifdef ULTRIX_MIPS
	HDRR symheader;
	int i, headersize;
#endif	
#endif

#ifdef E15
	struct exec header;
#endif

	char *data_begin, *data_end;
	int original_data;
	FILE *original, *save;
	register int n;
	register char *p;
	extern char *sbrk();
	extern char stdin_buf[BUFSIZ], stdout_buf[BUFSIZ];

	fclose(stdin);
	original = fopen(original_file, "r");
	if (stdin != original || original->_file != 0) {
		fprintf(stderr, "Can't open the original file.\n");
		exit(1);
	}
	setbuf(original, stdin_buf);
	fclose(stdout);
	unlink(save_file);
	n = open(save_file, O_CREAT|O_WRONLY, 0777);
	if (n != 1 || (save = fdopen(n, "w")) != stdout) {
		fprintf(stderr, "Can't open the save file.\n");
		exit(1);
	}
	setbuf(save, stdout_buf);

#ifdef BSD
	fread(&header, sizeof(header), 1, original);

#ifdef VAX
	data_begin
	= (char *)((TXTRELOC+header.a_text+(SEGSIZ-1)) & ~(SEGSIZ-1));
#endif
#ifdef SUN
	data_begin
	= (char *)((TXTRELOC+header.a_text+(SEGSIZ-1)) & ~(SEGSIZ-1));
#endif
#ifdef SUN2R3
	data_begin = (char *)N_DATADDR(header);
#endif
#ifdef SUN3
	data_begin = (char *)N_DATADDR(header);
#endif
#ifdef NEWS
	data_begin
	= (char *)((TXTRELOC+header.a_text+(SEGSIZ-1)) & ~(SEGSIZ-1));
#endif
#ifdef ISI


#endif
#ifdef SEQ


#endif
#ifdef IBMRT


#endif

	data_end = core_end;
	original_data = header.a_data;
	header.a_data = data_end - data_begin;
	header.a_bss = 0;
	fwrite(&header, sizeof(header), 1, save);

#ifdef VAX
	if (header.a_magic == ZMAGIC)
		filecpy(save, original, PAGSIZ - sizeof(header));
	filecpy(save, original, header.a_text);
#endif
#ifdef SUN
	if (header.a_magic == ZMAGIC)
		filecpy(save, original, PAGSIZ - sizeof(header));
	filecpy(save, original, header.a_text);
#endif
#ifdef SUN2R3
	filecpy(save, original, header.a_text - sizeof(header));
#endif
#ifdef SUN3
	filecpy(save, original, header.a_text - sizeof(header));
#endif
#ifdef NEWS
	if (header.a_magic == ZMAGIC)
		filecpy(save, original, PAGSIZ - sizeof(header));
	filecpy(save, original, header.a_text);
#endif
#ifdef ISI




#endif
#ifdef SEQ


#endif
#ifdef IBMRT



#endif
#endif

#if defined ATT || defined ULTRIX_MIPS
	fread(&fileheader, sizeof(fileheader), 1, original);
	fread(&header, sizeof(header), 1, original);
	data_begin = (char *)header.data_start;
	data_end = core_end;
	original_data = header.a_data;
	header.a_data = data_end - data_begin;
	diff = header.a_data - original_data;
	header.a_bss = sbrk(0) - core_end;
	fileheader.f_symptr += diff;
	fwrite(&fileheader, sizeof(fileheader), 1, save);
	fwrite(&header, sizeof(header), 1, save);
	fread(&sectionheader, sizeof(sectionheader), 1, original);
#ifdef ATT
	if (sectionheader.s_lnnoptr)
		sectionheader.s_lnnoptr += diff;
#endif
	fwrite(&sectionheader, sizeof(sectionheader), 1, save);
	fread(&sectionheader, sizeof(sectionheader), 1, original);
	sectionheader.s_size += diff;
#ifdef ATT
	if (sectionheader.s_lnnoptr)
		sectionheader.s_lnnoptr += diff;
#endif
	fwrite(&sectionheader, sizeof(sectionheader), 1, save);
	fread(&sectionheader, sizeof(sectionheader), 1, original);
	sectionheader.s_paddr += diff;
	sectionheader.s_vaddr += diff;
	sectionheader.s_size = header.a_bss;
#if defined S3000 || defined ULTRIX_MIPS
        if (sectionheader.s_scnptr)
                sectionheader.s_scnptr += diff;
#endif
#ifdef ATT
	if (sectionheader.s_lnnoptr)
		sectionheader.s_lnnoptr += diff;
#endif
	fwrite(&sectionheader, sizeof(sectionheader), 1, save);
	for (n = 4;  n <= fileheader.f_nscns;  n++) {
		fread(&sectionheader, sizeof(sectionheader), 1, original);
		if (sectionheader.s_scnptr)
			sectionheader.s_scnptr += diff;
		if (sectionheader.s_lnnoptr)
			sectionheader.s_lnnoptr += diff;
		fwrite(&sectionheader, sizeof(sectionheader), 1, save);
	}
#ifdef ULTRIX_MIPS
	headersize = sizeof(fileheader) + sizeof(header)
	    + fileheader.f_nscns * sizeof(sectionheader);
	
	/* The text size includes the size of the header */
	filecpy(save, original, header.a_text - headersize);  
#else	
	filecpy(save, original, header.a_text);
#endif
#endif

#ifdef E15
	fread(&header, sizeof(header), 1, original);
	if (header.fmagic != NMAGIC)
		data_begin
		= (char *)(TXTRELOC+header.a_text);
	else
		data_begin
		= (char *)((TXTRELOC+header.a_text+(SEGSIZ-1)) & ~(SEGSIZ-1));
	data_end = core_end;
	original_data = header.a_data;
	header.a_data = data_end - data_begin;
	header.a_bss = sbrk(0) - core_end;
	fwrite(&header, sizeof(header), 1, save);
	filecpy(save, original, header.a_text);
#endif

	for (n = header.a_data, p = data_begin;  ; n -= BUFSIZ,p += BUFSIZ)
	{
	    
	    if (n > BUFSIZ)
			fwrite(p, BUFSIZ, 1, save);
		else if (n > 0) {
		    fwrite(p, 1, n, save); 
		    break;
		} else
			break;
	}
	

	fseek(original, original_data, 1);

#ifdef BSD
	filecpy(save, original, header.a_syms+header.a_trsize+header.a_drsize);
	fread(&stsize, sizeof(stsize), 1, original);
	fwrite(&stsize, sizeof(stsize), 1, save);
	filecpy(save, original, stsize - sizeof(stsize));
#endif


#ifdef ULTRIX_MIPS
/* adjust all offsets in the symbol table header */
	fread(&symheader, sizeof(symheader), 1, original);
	if (symheader.cbLineOffset)
	    symheader.cbLineOffset += diff;
	if (symheader.cbDnOffset)
	    symheader.cbDnOffset += diff;
	if (symheader.cbPdOffset)
	    symheader.cbPdOffset += diff;
	if (symheader.cbSymOffset)
	    symheader.cbSymOffset += diff;
	if (symheader.cbOptOffset)
	    symheader.cbOptOffset += diff;
	if (symheader.cbAuxOffset)
	    symheader.cbAuxOffset += diff;
	if (symheader.cbSsOffset)
	    symheader.cbSsOffset += diff;
	if (symheader.cbSsExtOffset)
	    symheader.cbSsExtOffset += diff;
	if (symheader.cbFdOffset)
	    symheader.cbFdOffset += diff;
	if (symheader.cbRfdOffset)
	    symheader.cbRfdOffset += diff;
	if (symheader.cbExtOffset)
	    symheader.cbExtOffset += diff;
	fwrite(&symheader, sizeof(symheader), 1, save);

	for (;;) {
	    n = getc(original);
	    if (feof(original))
		break;
	    putc(n, save);
	}

#endif	

#ifdef ATT
	for (;;) {
		n = getc(original);
		if (feof(original))
			break;
		putc(n, save);
	}
#endif

#ifdef E15
	filecpy(save, original, header.a_syms+header.a_trsize+header.a_drsize);
#endif

	fclose(original);
	fclose(save);

}

Lsave()
{
	char filename[256];

	check_arg(1);
	check_type_or_pathname_string_symbol_stream(&vs_base[0]);
	coerce_to_filename(vs_base[0], filename);
#ifndef ULTRIX_MIPS
	{
		FILE *p;
		int nfile;

#if defined BSD 
		nfile = getdtablesize();
#else
		nfile = _NFILE;
#endif
		for (p = &_iob[3];  p < &_iob[nfile];  p++)
			fclose(p);

	    }
#endif ULTRIX_MIPS
	memory_save(kcl_self, filename);
/*
	_exit(0);
*/
	exit(0);
	/*  no return  */
}


init_unixsave()
{
	make_function("SAVE", Lsave);
}

#ifdef ISI










#endif







