/*
(C) Copyright Taiichi Yuasa and Masami Hagiya, 1984.  All rights reserved.
*/

/*
	fasload.c
	DG-SPECIFIC
*/

#include "include.h"

int
fasload(filename)
object filename;
{
	object	x;
	object	data, skip_count;
	object	strm;
	int	len, i, byte_count;
	char	*cp;
	char	filen[256];
	int	ob_start;
	object	*base = vs_base;
	object	*top = vs_top;

	if (type_of(filename) != t_string)
		FEwrong_type_argument(Sstring, filename);

	cp = filename->st.st_self;
	len = filename->st.st_fillp;

	for (i=0; i < len; i++) filen[i] = cp[i];
	filen[i] = '\0';

#ifdef AOSVS
	strm = open_stream(filename, smm_input, Cnil, Kerror);
	vs_push(strm);

	preserving_whitespace_flag = FALSE;
	detect_eos_flag = FALSE;
	skip_count = standard_read_object_non_recursive(strm);
	vs_push(skip_count);

	data = read_fasl_vector(strm);
	vs_push(data);
	close_stream(strm, TRUE);

	if (type_of(skip_count) != t_fixnum)
		FEerror("too large fasl file", 0);

	byte_count = fasl_loader(filen, fix(skip_count), data);
#endif
#ifdef DGUX
	data = read_fasl_data(filen);
	vs_push(data);

	byte_count = fasl_loader(filen, 0, data);
#endif
	vs_top = top;
	vs_base = base;
	return(byte_count);
}

siLobload()
{
	object	filename;
	int	byte_count;
	int	len, i;
	char	*cp;
	char	filen[256];
	object	*base = vs_base;
	object	*top = vs_top;

	check_arg(1);
	check_type_or_pathname_string_symbol_stream(&vs_base[0]);

	filename = coerce_to_namestring(vs_base[0]);

	cp = filename->st.st_self;
	len = filename->st.st_fillp;

	for (i=0; i < len; i++) filen[i] = cp[i];
	filen[i] = '\0';

	byte_count = fasl_loader(filen, 0, Cnil);

	vs_base = base;
	vs_top = top;

	if (byte_count < 0) {
		vs_top = vs_base;
		vs_push(Cnil);
	} else {
		vs_top = vs_base;
		vs_push(make_fixnum(byte_count));
	}
}

#ifdef AOSVS
init_fasload()
{
	init_fasl();
	make_si_function("OBLOAD", siLobload);
}
#endif

