(* ========================================================================= *)
(* Theory of wellfounded relations.                                          *)
(* ========================================================================= *)

parse_as_infix("<<",(12,"right"));;

let WF = new_definition
  `WF($<<) = !P:A->bool. (?x. P(x)) ==>
                         (?x. P(x) /\ !y. y << x ==> ~P(y))`;;

(* ------------------------------------------------------------------------- *)
(* Strengthen it to equality.                                                *)
(* ------------------------------------------------------------------------- *)

let WF_EQ = prove
 (`WF($<<) = !P:A->bool. (?x. P(x)) =
                         (?x. P(x) /\ !y. y << x ==> ~P(y))`,
  REWRITE_TAC[WF] THEN EQ_TAC THEN ONCE_REWRITE_TAC[EQ_SYM_EQ] THEN
  DISCH_TAC THEN ASM_REWRITE_TAC[] THEN GEN_TAC THEN EQ_TAC THEN
  ASM_REWRITE_TAC[] THEN
  DISCH_THEN(X_CHOOSE_TAC `x:A`) THEN EXISTS_TAC `x:A` THEN
  ASM_REWRITE_TAC[]);;

(* ------------------------------------------------------------------------- *)
(* Equivalence of wellfounded induction.                                     *)
(* ------------------------------------------------------------------------- *)

let WF_IND = prove
 (`WF($<<) = !P:A->bool. (!x. (!y. y << x ==> P(y)) ==> P(x)) ==> !x. P(x)`,
  REWRITE_TAC[WF] THEN EQ_TAC THEN DISCH_TAC THEN GEN_TAC THEN
  POP_ASSUM(MP_TAC o SPEC `\x:A. ~P(x)`) THEN
  REWRITE_TAC[BETA_THM; TAUT `a /\ b = ~(b ==> ~a)`;
    EXISTS_NOT_THM; FORALL_NOT_THM] THEN
  CONV_TAC (EQT_INTRO o TAUT));;

(* ------------------------------------------------------------------------- *)
(* Equivalence of the "infinite descending chains" version.                  *)
(* ------------------------------------------------------------------------- *)

let WF_DCHAIN = prove
 (`WF($<<) = ~(?s:num->A. !n. s(SUC n) << s(n))`,
  ONCE_REWRITE_TAC[TAUT `(a = b) = (~a = ~b)`] THEN
  REWRITE_TAC[WF; NOT_FORALL_THM; NOT_EXISTS_THM; NOT_IMP;
              TAUT `~(a /\ b) = a ==> ~b`] THEN EQ_TAC THENL
   [DISCH_THEN(X_CHOOSE_THEN `P:A->bool` MP_TAC) THEN
    DISCH_THEN(CONJUNCTS_THEN2 (X_CHOOSE_TAC `a:A`) MP_TAC) THEN
    DISCH_THEN(MP_TAC o REWRITE_RULE[RIGHT_IMP_EXISTS_THM; SKOLEM_THM]) THEN
    DISCH_THEN(X_CHOOSE_TAC `f:A->A`) THEN
    MP_TAC(SPECL [`a:A`; `\x (n:num). (f:A->A) x`] num_Axiom) THEN
    REWRITE_TAC[BETA_THM] THEN
    DISCH_THEN(X_CHOOSE_THEN `s:num->A` STRIP_ASSUME_TAC o EXISTENCE) THEN
    EXISTS_TAC `s:num->A` THEN ASM_REWRITE_TAC[] THEN
    SUBGOAL_THEN `!n:num. f(s n) << s n /\ P((f:A->A) (s n))`
    (fun th -> REWRITE_TAC[th]) THEN INDUCT_TAC THEN
    FIRST_ASSUM MATCH_MP_TAC THEN ASM_REWRITE_TAC[];
    DISCH_THEN(X_CHOOSE_TAC `s:num->A`) THEN
    EXISTS_TAC `\x:A. ?n:num. x = s(n)` THEN
    REWRITE_TAC[BETA_THM] THEN CONJ_TAC THENL
     [MAP_EVERY EXISTS_TAC [`(s:num->A) 0`; `0`] THEN REFL_TAC;
      GEN_TAC THEN DISCH_THEN(X_CHOOSE_THEN `n:num` SUBST1_TAC) THEN
      EXISTS_TAC `s(SUC n):A` THEN ASM_REWRITE_TAC[] THEN
      EXISTS_TAC `SUC n` THEN REFL_TAC]]);;

(* ------------------------------------------------------------------------- *)
(* Equivalent to just *uniqueness* part of recursion.                        *)
(* ------------------------------------------------------------------------- *)

let WF_URECURSE_1 = prove
 (`WF($<<) ==>
       !H. (!f g x. (!z. z << x ==> (f z = g z)) ==> (H f x = H g x))
            ==> !(f:A->B) g. (!x. f x = H f x) /\ (!x. g x = H g x)
                              ==> (f = g)`,
  REWRITE_TAC[WF_IND] THEN
  DISCH_THEN(prefix THEN (REPEAT STRIP_TAC) o MP_TAC) THEN
  DISCH_THEN(MP_TAC o SPEC `\x:A. f x :B = g x`) THEN
  BETA_TAC THEN DISCH_TAC THEN ONCE_REWRITE_TAC[FUN_EQ_THM] THEN
  FIRST_ASSUM MATCH_MP_TAC THEN GEN_TAC THEN DISCH_TAC THEN
  ASM_REWRITE_TAC[] THEN FIRST_ASSUM MATCH_MP_TAC THEN
  FIRST_ASSUM MATCH_ACCEPT_TAC);;

let WF_URECURSE_2 = prove
 (`(!H. (!f g x. (!z. z << x ==> (f z = g z)) ==> (H f x = H g x))
        ==> !(f:A->bool) g. (!x. f x = H f x) /\ (!x. g x = H g x)
                          ==> (f = g))
   ==> WF($<<)`,
  REWRITE_TAC[WF_IND] THEN
  DISCH_THEN(prefix THEN (GEN_TAC THEN DISCH_TAC) o MP_TAC) THEN
  DISCH_THEN(MP_TAC o SPEC `\f x. P(x:A) \/ !z:A. z << x ==> f(z)`) THEN
  BETA_TAC THEN W(C SUBGOAL_THEN (fun t -> REWRITE_TAC[t]) o
  funpow 2 (fst o dest_imp) o snd) THENL
   [REPEAT STRIP_TAC THEN REPEAT AP_TERM_TAC THEN
    ONCE_REWRITE_TAC[FUN_EQ_THM] THEN BETA_TAC THEN
    ASM_REWRITE_TAC[TAUT `((a ==> b) = (a ==> c)) = (a ==> (b = c))`];
    DISCH_THEN(MP_TAC o SPECL [`P:A->bool`; `\x:A. T`]) THEN
    BETA_TAC THEN ASM_REWRITE_TAC[TAUT `(a = a \/ b) = (b ==> a)`] THEN
    DISCH_THEN SUBST1_TAC THEN REWRITE_TAC[]]);;

(* ------------------------------------------------------------------------- *)
(* Full recursion.                                                           *)
(* ------------------------------------------------------------------------- *)

let WF_RECURSE_1 = prove
 (`WF($<<) ==>
       !H. (!f g x. (!z. z << x ==> (f z = g z)) ==> (H f x = H g x))
            ==> ?!f:A->B. !x. f x = H f x`,
  let lemma = prove_inductive_relations_exist
    `!f (x:A). (!z:A. z << x ==> R z (f z :B)) ==> R x (H f x)` in
  REWRITE_TAC[WF_IND] THEN REPEAT STRIP_TAC THEN
  REWRITE_TAC[EXISTS_UNIQUE_THM] THEN CONJ_TAC THENL
   [X_CHOOSE_THEN `R:A->B->bool` (ASSUME_TAC o last o CONJUNCTS) lemma THEN
    SUBGOAL_THEN `!x:A. ?!y:B. R x y` ASSUME_TAC THENL
     [FIRST_ASSUM(MP_TAC o SPEC `\x:A. ?!y:B. R x y`) THEN
      BETA_TAC THEN DISCH_THEN MATCH_MP_TAC THEN GEN_TAC THEN DISCH_TAC THEN
      REWRITE_TAC[EXISTS_UNIQUE_THM] THEN CONJ_TAC THENL
       [EXISTS_TAC `(H:(A->B)->A->B) (\x:A. @y:B. R x y) x` THEN
        FIRST_ASSUM(fun th -> GEN_REWRITE_TAC I [th]) THEN
        EXISTS_TAC `\x:A. @y:B. R x y` THEN BETA_TAC THEN REWRITE_TAC[] THEN
        GEN_TAC THEN DISCH_THEN(ANTE_RES_THEN MP_TAC) THEN
        DISCH_THEN(ACCEPT_TAC o SELECT_RULE o EXISTENCE);
        REPEAT GEN_TAC THEN ONCE_ASM_REWRITE_TAC[] THEN
        DISCH_THEN(CONJUNCTS_THEN(CHOOSE_THEN
          (CONJUNCTS_THEN2 SUBST1_TAC ASSUME_TAC))) THEN
        FIRST_ASSUM MATCH_MP_TAC THEN GEN_TAC THEN DISCH_TAC THEN
        MP_TAC(ASSUME `!z. (z:A) << (x:A) ==> (?!y:B. R z y)`) THEN
        DISCH_THEN(fun th -> FIRST_ASSUM(MP_TAC o MATCH_MP th)) THEN DISCH_THEN
         (MATCH_MP_TAC o CONJUNCT2 o REWRITE_RULE[EXISTS_UNIQUE_THM]) THEN
        CONJ_TAC THEN FIRST_ASSUM MATCH_MP_TAC THEN ASM_REWRITE_TAC[]];
      EXISTS_TAC `\x:A. @y:B. R x y` THEN GEN_TAC THEN BETA_TAC THEN
      FIRST_ASSUM
        (MP_TAC o GEN_REWRITE_RULE I [EXISTS_UNIQUE_THM] o SPEC `x:A`) THEN
      DISCH_THEN(CONJUNCTS_THEN2 (ASSUME_TAC o SELECT_RULE) MATCH_MP_TAC) THEN
      CONJ_TAC THENL
       [FIRST_ASSUM MATCH_ACCEPT_TAC;
        ONCE_ASM_REWRITE_TAC[] THEN REWRITE_TAC[] THEN
        EXISTS_TAC `\x:A. @y:B. R x y` THEN REWRITE_TAC[] THEN
        REPEAT STRIP_TAC THEN BETA_TAC THEN CONV_TAC SELECT_CONV THEN
        FIRST_ASSUM(fun th -> REWRITE_TAC
         [GEN_REWRITE_RULE I[EXISTS_UNIQUE_THM] (SPEC `z:A` th)])]];
    MP_TAC(REWRITE_RULE[WF_IND] WF_URECURSE_1) THEN
    DISCH_THEN(fun th -> FIRST_ASSUM(MATCH_MP_TAC o MATCH_MP th)) THEN
    ASM_REWRITE_TAC[]]);;

let WF_RECURSE_2 = prove
 (`(!H. (!f g x. (!z. z << x ==> (f z = g z)) ==> (H f x = H g x))
        ==> ?!f:A->bool. !x. f x = H f x)
   ==> WF($<<)`,
  DISCH_TAC THEN MATCH_MP_TAC WF_URECURSE_2 THEN
  GEN_TAC THEN DISCH_THEN(ANTE_RES_THEN MP_TAC) THEN
  REWRITE_TAC[EXISTS_UNIQUE_THM; TAUT `a /\ b ==> b`]);;

(* ------------------------------------------------------------------------- *)
(* Just the existence part of recursion (what we usually want).              *)
(* ------------------------------------------------------------------------- *)

let WF_REC = prove
 (`WF($<<) ==>
       !H. (!f g x. (!z. z << x ==> (f z = g z)) ==> (H f x = H g x))
            ==> ?f:A->B. !x. f x = H f x`,
  DISCH_THEN(ASSUME_TAC o MATCH_MP WF_RECURSE_1) THEN
  GEN_TAC THEN DISCH_THEN(ANTE_RES_THEN (ACCEPT_TAC o EXISTENCE)));;

(* ------------------------------------------------------------------------- *)
(* Definition of transitive closure, used below.                             *)
(* ------------------------------------------------------------------------- *)

let TC_CLAUSES,TC_INDUCT,TC_CASES =
  new_inductive_definition
   `(!x y. R x y ==> TC R x y) /\
    (!(x:A) y z. TC R x y /\ TC R y z ==> TC R x z)`;;

let TC_INC = prove
 (`!(R:A->A->bool) x y. R x y ==> TC R x y`,
  REWRITE_TAC[TC_CLAUSES]);;

let TC_TRANS = prove
 (`!(R:A->A->bool) x z. (?y. TC R x y /\ TC R y z) ==> TC R x z`,
  REWRITE_TAC[LEFT_IMP_EXISTS_THM; TC_CLAUSES]);;

let TC_CASES = prove
 (`!(R:A->A->bool) x z. TC R x z = R x z \/ (?y. TC R x y /\ TC R y z)`,
  MATCH_ACCEPT_TAC TC_CASES);;

let TC_INDUCT = prove
 (`!(R:A->A->bool) P.
        (!x y. R x y ==> P x y) /\
        (!x z. (?y. P x y /\ P y z) ==> P x z) ==>
            (!x y. TC R x y ==> P x y)`,
  REPEAT GEN_TAC THEN REWRITE_TAC[LEFT_IMP_EXISTS_THM] THEN
  STRIP_TAC THEN MATCH_MP_TAC TC_INDUCT THEN ASM_REWRITE_TAC[]);;

let TC_MONO = prove
 (`!(R:A->A->bool) S.
        (!x y. R x y ==> S x y) ==>
        (!x y. TC R x y ==> TC S x y)`,
  REPEAT GEN_TAC THEN DISCH_TAC THEN
  MATCH_MP_TAC TC_INDUCT THEN REPEAT STRIP_TAC THENL
   [MATCH_MP_TAC TC_INC THEN FIRST_ASSUM MATCH_MP_TAC;
    MATCH_MP_TAC TC_TRANS THEN EXISTS_TAC `y:A`] THEN
  ASM_REWRITE_TAC[]);;

(* ------------------------------------------------------------------------- *)
(* Some preservation theorems for wellfoundedness.                           *)
(* ------------------------------------------------------------------------- *)

parse_as_infix("<<<",(12,"right"));;

let WF_SUBSET = prove
 (`(!(x:A) y. x << y ==> x <<< y) /\ WF($<<<) ==> WF($<<)`,
  DISCH_THEN(CONJUNCTS_THEN2 ASSUME_TAC MP_TAC) THEN REWRITE_TAC[WF] THEN
  DISCH_TAC THEN GEN_TAC THEN DISCH_THEN(ANTE_RES_THEN MP_TAC) THEN
  UNDISCH_TAC `!(x:A) (y:A). x << y ==> x <<< y` THEN MESON_TAC[]);;

let WF_MEASURE_GEN = prove
 (`!m:A->B. WF($<<) ==> WF(\x x'. m x << m x')`,
  GEN_TAC THEN REWRITE_TAC[WF_IND] THEN REPEAT STRIP_TAC THEN
  FIRST_ASSUM(MP_TAC o SPEC `\y:B. !x:A. (m(x) = y) ==> P x`) THEN
  UNDISCH_TAC `!x. (!y. (m:A->B) y << m x ==> P y) ==> P x` THEN
  REWRITE_TAC[] THEN MESON_TAC[]);;

(*******

let WF_LEXICOG = prove
 (`WF($<< :A->A->bool) /\ WF($<<< :B->B->bool)
   ==> WF(\(x1,y1) (x2,y2). x1 << x2 \/ (x1 = x2) /\ y1 <<< y2)`,
  err);;

let WF_POINTWISE = prove
 (`WF($<< :A->A->bool) /\ WF($<<< :B->B->bool)
   ==> WF(\(x1,y1) (x2,y2). x1 << x2 /\ y1 <<< y2)`,
  STRIP_TAC THEN MATCH_MP_TAC(GEN_ALL WF_SUBSET) THEN EXISTS_TAC
   `\(x1,y1) (x2,y2). x1 << x2 \/ (x1:A = x2) /\ (y1:B) <<< (y2:B)` THEN
  CONJ_TAC THENL
   [GEN_PAIR_TAC THEN GEN_PAIR_TAC THEN
    CONV_TAC(REDEPTH_CONV PAIRED_BETA_CONV) THEN CONV_TAC TAUT;
    MATCH_MP_TAC WF_LEXICOG THEN ASM_REWRITE_TAC[]]);;

let WF_TC = prove
 (`WF($<< :A->A->bool) ==> WF(TC $<<)`,
  REWRITE_TAC[WF] THEN DISCH_TAC THEN GEN_TAC THEN
  DISCH_THEN(ANTE_RES_THEN MP_TAC) THEN
  DISCH_THEN(X_CHOOSE_THEN `m:A` STRIP_ASSUME_TAC) THEN
  EXISTS_TAC `m:A` THEN ASM_REWRITE_TAC[] THEN
  UNDISCH_TAC `!y. (y:A) << (m:A) ==> ~P y` THEN
  REWRITE_TAC[TAUT `a ==> ~b = ~(a /\ b)`; GSYM NOT_EXISTS_THM]

******)
