(* ========================================================================= *)
(* Trivial odds and ends.                                                    *)
(* ========================================================================= *)

(* ------------------------------------------------------------------------- *)
(* Some general (?) definitions about functions.                             *)
(* ------------------------------------------------------------------------- *)

let ASSOC_DEF = new_definition
 `!f:A->A->A. ASSOC f = !x y z. f x (f y z) = f (f x y) z`;;

let COMM_DEF = new_definition
 `!f:A->A->B. COMM f = !x y. f x y = f y x`;;

let FCOMM_DEF = new_definition
 `!(f:A->B->A) (g:C->A->A). FCOMM f g = !x y z. g x (f y z) = f (g x y) z`;;

let RIGHT_ID_DEF = new_definition
 `RIGHT_ID (f:A->B->A) e = (!x. f x e =  x)`;;

let LEFT_ID_DEF = new_definition
 `LEFT_ID (f:B->A->A) e = (!x. f e x =  x)`;;

let MONOID_DEF = new_definition
 `MONOID (f:A->A->A) e = ASSOC f /\ RIGHT_ID f e /\ LEFT_ID f e`;;

(* ------------------------------------------------------------------------- *)
(* Some trivial theorems about these definitions.                            *)
(* ------------------------------------------------------------------------- *)

let ASSOC_CONJ = prove
 (`ASSOC $/\`,
  REWRITE_TAC[ASSOC_DEF;CONJ_ASSOC]);;

let ASSOC_DISJ = prove
 (`ASSOC $\/`,
  REWRITE_TAC[ASSOC_DEF;DISJ_ASSOC]);;

let FCOMM_ASSOC = prove
 (`!f:A->A->A. FCOMM f f = ASSOC f`,
    REWRITE_TAC[ASSOC_DEF;FCOMM_DEF]);;

let MONOID_CONJ_T = prove
 (`MONOID $/\ T`,
  REWRITE_TAC[MONOID_DEF;CONJ_ASSOC;LEFT_ID_DEF;ASSOC_DEF;RIGHT_ID_DEF]);;

let MONOID_DISJ_F = prove
 (`MONOID $\/ F`,
  REWRITE_TAC[MONOID_DEF;DISJ_ASSOC;LEFT_ID_DEF;ASSOC_DEF;RIGHT_ID_DEF]);;

(* ------------------------------------------------------------------------- *)
(* Combinators. We don't bother with S and K, which seem of little use.      *)
(* ------------------------------------------------------------------------- *)

parse_as_infix ("o",(26,"right"));;

let o_DEF = new_definition
 `$o (f:B->C) g = \x:A. f(g(x))`;;

let I_DEF = new_definition
 `I = \x:A. x`;;

let o_THM = prove
 (`!f:B->C. !g:A->B. !x:A. (f o g) x = f(g(x))`,
  PURE_REWRITE_TAC [o_DEF] THEN
  CONV_TAC (DEPTH_CONV BETA_CONV) THEN
  REPEAT GEN_TAC THEN REFL_TAC);;

let o_ASSOC = prove
 (`!f:C->D. !g:B->C. !h:A->B. f o (g o h) = (f o g) o h`,
  REPEAT GEN_TAC THEN REWRITE_TAC [o_DEF] THEN
  CONV_TAC (REDEPTH_CONV BETA_CONV) THEN
  REFL_TAC);;

let I_THM = prove
 (`!x:A. I x = x`,
  REWRITE_TAC [I_DEF]);;

let I_o_ID = prove
 (`!f:A->B. (I o f = f) /\ (f o I = f)`,
  REPEAT STRIP_TAC THEN
  REWRITE_TAC[FUN_EQ_THM; o_DEF; I_THM]);;

(* ------------------------------------------------------------------------- *)
(* The theory "one" (a 1-element type).                                      *)
(* ------------------------------------------------------------------------- *)

let EXISTS_ONE_REP = prove
 (`?b:bool. b`,
  EXISTS_TAC `T` THEN
  BETA_TAC THEN ACCEPT_TAC TRUTH);;

let one_tydef =
  new_type_definition "one" ("one_ABS","one_REP") EXISTS_ONE_REP;;

let one_DEF = new_definition
 `one = @x:one. T`;;

let one = prove
 (`!v:one. v = one`,
  MP_TAC(GEN_ALL (SPEC `one_REP a` (CONJUNCT2 one_tydef))) THEN
  REWRITE_TAC[CONJUNCT1 one_tydef] THEN DISCH_TAC THEN
  ONCE_REWRITE_TAC[GSYM (CONJUNCT1 one_tydef)] THEN
  ASM_REWRITE_TAC[]);;

let one_axiom = prove
 (`!f g. f = (g:A->one)`,
  REPEAT GEN_TAC THEN ONCE_REWRITE_TAC[FUN_EQ_THM] THEN
  GEN_TAC THEN ONCE_REWRITE_TAC[one] THEN REFL_TAC);;

let one_Axiom = prove
 (`!e:A. ?!fn. fn one = e`,
  GEN_TAC THEN REWRITE_TAC[EXISTS_UNIQUE_THM] THEN CONJ_TAC THENL
   [EXISTS_TAC `\x:one. e:A` THEN BETA_TAC THEN REFL_TAC;
    REPEAT STRIP_TAC THEN ONCE_REWRITE_TAC[FUN_EQ_THM] THEN
    ONCE_REWRITE_TAC [one] THEN ASM_REWRITE_TAC[]]);;
