

#include "include.h"
#include "arith.h"

/* ulong a,b,y;
   (y = mulul3(a,b,&hiremainder), hiremainder:y == a*b) is TRUE.
*/   
#ifdef USE_WORD_MULUL3

int mulul3(x,y,hiremainder)
     ulong x,y,*hiremainder;
{
  ulong xlo,xhi,ylo,yhi;
  ulong z; TEMPVARS

  xlo=x&65535;xhi=x>>16;ylo=y&65535;yhi=y>>16;
  z=addll(xlo*yhi,xhi*ylo);
  *hiremainder=(overflow)?xhi*yhi+65536+(z>>16):xhi*yhi+(z>>16);
  z=addll(xlo*ylo,(z<<16));*hiremainder+=overflow;
  return z;
}

#else
ulong
mulul3(a,b,h)
unsigned int a,b, *h;
{unsigned int temph,templ,ah,al,i;
 ah=0;
 al=0;
 /* in case the shift by 32 does not zero an unsigned int..
    we separate out the first step.*/
 {if (b & 1)
    {temph=0;templ=a;
     lladd(temph,templ,ah,al);}
    /*    printf("\n%d b=%d a=%d (%d:%d)",i,b,a,ah,al); */
    b=b>>1;
  }
 i=1;
 while(b)
   {if (b & 1)
      {llshift(a,i,temph,templ);
       lladd(temph,templ,ah,al);}
      i++;b=b>>1;
    }
 *h=ah;
 return al;
}
#endif
