structure Utils =
struct

datatype 'a result = None of string
                   | Some of 'a;

fun stdOutput s = 
   let open TextIO
   in
      output(stdOut, s);
      flushOut stdOut
   end;

(*---------------------------------------------------------------------------*
 * Be persistent in attempting to do something.                              *
 *---------------------------------------------------------------------------*)
fun attempt f i =
  if i < 1 then raise Fail "attempt"
  else f () 
       handle Interrupt => raise Interrupt
            | _ => (Process.system"sleep 1"; attempt f (i-1));

(*---------------------------------------------------------------------------*
 * Try to find a file.                                                       *
 *---------------------------------------------------------------------------*)
local fun file_exists s = FileSys.access(s,[]);
in 
fun find_file s () = if file_exists s then () else raise Fail "find_file"
end;


(*---------------------------------------------------------------------------*
 * Prepend the size of a string to a string. Complicated because the size    *
 * needs to take account of the size of the size!                            *
 * Examples.                                                                 *
 *                                                                           *
 *  sizedstring "12345678" = "11 12345678"                                   *
 *  sizedstring "1234567"  = "9 1234567"                                     *
 *---------------------------------------------------------------------------*)

fun sizedstring s =
 let val i = 1 + String.size s  (* account for a space *)
     val si = Int.toString i
     val j = String.size si
     val guess0 = i + j
     val strguess = Int.toString guess0
     val k = String.size strguess
     val n = (if j < k then k else j) + i
 in 
   String.concat [Int.toString n, " ", s]
 end;


infix after
fun (g after f) x = (f x handle e => (g x; raise e); g x);

fun failed()    = Process.exit Process.failure;
fun succeeded() = Process.exit Process.success;

end;
