(*---------------------------------------------------------------------------*
 * Handles one round of interaction with the client: handleClient blocks     *
 * waiting for the next request on clientsock. When it gets a request, it    *
 * parses it and invokes the right routine. It then replies with a result    *
 * to the client.  handleClient doesn't deal with any aspect of socket       *
 * creation or destruction.                                                  *
 *---------------------------------------------------------------------------*)

structure ServeOnce =
struct

fun handleClient clientsock continue  =
 let open Dispatch SocketUtils
     val (n,comm) = readString clientsock
 in
   case comm 
    of   ""      => (sendString clientsock (no_rqt());                  ())
     | "Stop"    => (continue := false; sendString clientsock (stop()); ())
     | "Release" => (continue := false; sendString clientsock (release()); ())
     |   _       => (sendString clientsock (comm_to_answerVector comm); ())
 end;

end;
