(*---------------------------------------------------------------------------*
 * The Internet domain prototype of the Core Proof Engine. Start it with     *
 * the Unix invocation                                                       *
 *                                                                           *
 *    ./CPEinet <inet address> <port> > /dev/null &                          *
 *                                                                           *
 * Note that the shell variables `archOS' and `HOLDIR' should be set before  *
 * making the invocation. A reasonable value for the first can be obtained   *
 * via invoking <holdir>/tools/archOS, where <holdir> is the absolute path   *
 * to the Hol98 distribution. The second should simply be <holdir>.          *
 *                                                                           *
 * Example.                                                                  *
          archOS=x86-linux
          HOLDIR=/home/kxs/hol98
          ./CPEinet 127.0.0.1 5436 > /dev/null &
 *---------------------------------------------------------------------------*)

open Utils;
infix after;

fun run (ipnum,port) = 
  case Int.fromString port
    of SOME i => let val serversock = Socket.inetStream ()
                     val addr = Socket.inetAddr ipnum i
                  in
                    SocketUtils.serialMonogamist
                       ServeOnce.handleClient (serversock,addr)
                  end
     | NONE   => 
        (stdOutput (String.concat
            ["Purported port number: ", Lib.quote port,
             " is not a numeric literal."]);
         failed());

fun cleanup _ = ();

val _ = 
  case CommandLine.arguments() 
   of [ipnum,port] => ((cleanup after run) (ipnum,port); succeeded())
    |  _  => (stdOutput "Usage: CPEinet <inet address> <port>\n"; failed())
