 #########################################################################
 #                                                                       #
 # Copyright (C) 1993 by General Electric company.  All rights reserved. #
 #                                                                       #
 # Permission to use, copy, modify, and distribute this                  #
 # software and its documentation for any purpose and without            #
 # fee is hereby granted, provided that the above copyright              #
 # notice appear in all copies and that both that copyright              #
 # notice and this permission notice appear in supporting                #
 # documentation, and that the name of General Electric not be used in   #
 # advertising or publicity pertaining to distribution of the            #
 # software without specific, written prior permission.                  #
 #                                                                       #
 # General Electric makes no representations about the suitability of    #
 # this software for any purpose.  It is provided ``as is''              #
 # without express or implied warranty.                                  #
 #                                                                       #
 # This work was supported in part by the DARPA Initiative in Concurrent #
 # Engineering (DICE) through DARPA Contracts MDA972-88-C-0047 and       #
 # MDA972-92-C-0027.                                                     #
 #                                                                       #
 # This work was supported in part by the Tri-Services Microwave and     #
 # Millimeter-Wave Advanced Computational Environment (MMACE) program    #
 # under Naval Research Laboratory contract N00014-92-C-2044.            #
 #                                                                       #
 #########################################################################


# File: topLevelAux.tcl
#
# Description:
#	Procedures to handle keyboard traversal in top level windows
#
#	This file supports the `hybrid' focus model, in which top-level windows
#	follow the focus policy of the window manager (often
#	focus-follows-mouse), while non-toplevel widgets are click-to-focus
#	or keyboard-traversal.
#
#	It includes a handler for the <FocusIn> event for top-level windows.
#	If the event reports a `detail' field of `NotifyVirtual', then it
#	indicates that a window manager has directed the focus to the
#	top-level window, and the Tk focus is directed to the `current'
#	widget within that window.
#
# Global variables used:
#c	focus_priv(current,$w)
#		Most recently focused item among the children of toplevel
#		window $w.

 # toplevelAux.tcl,v 1.2 1995/03/21 15:05:05 drs1004 Exp
 # /homes/drs1004/repository/tkaux/toplevelAux.tcl,v
 # toplevelAux.tcl,v
# Revision 1.2  1995/03/21  15:05:05  drs1004
# Patch 1, 0.2b.  Bug fixes suggested by Michael Norrish.
#
# Revision 1.1.1.1  1994/12/07  10:17:29  donald
# First import after some small chanegs.
#
 # Revision 1.12  1994/10/27  18:29:42  kennykb
 # Release 2.0 -- 10-27-94.  To be uploaded to archive sites.
 #
 # Revision 1.11  1993/11/01  18:20:46  kennykb
 # Beta release to be announced on comp.lang.tcl
 #
 # Revision 1.10  1993/10/27  15:52:49  kennykb
 # Package for alpha release to the Net, and for MMACE 931101 release.
 #
 # Revision 1.9  1993/10/20  19:10:47  kennykb
 # Alpha release #1 was thawed for bug fixes in tk 3.3.  Now frozen again at this
 # point.
 #
 # Revision 1.8  1993/10/20  19:06:24  kennykb
 # Repaired copyright notice so that it doesn't look like structured commentary.
 #
 # Revision 1.7  1993/10/14  18:15:42  kennykb
 # Cleaned up alignment of log messages, to avoid problems extracting
 # structured commentary.
 #
 # Revision 1.6  1993/10/14  18:06:59  kennykb
 # Added GE legal notice to head of file in preparation for release.
 #
 # Revision 1.5  1993/10/14  14:02:02  kennykb
 # Alpha release #1 frozen at this point.
 #
 # Revision 1.4  1993/10/14  13:47:46  kennykb
 # Changes to ignore errors resulting from trying to focus a destroyed
 # window (this can happen if the application itself is being destroyed).
 #
 # Revision 1.3  1993/07/21  19:44:36  kennykb
 # Finished cleaning up structured commentary.
 #
 # Revision 1.2  1993/07/20  19:17:12  kennykb
 # Improved structured comments.
 # Changed modules through `g' in the alphabet to follow `:' and `_' naming
 # conventions.
 #
 # Revision 1.1  1993/06/03  15:32:54  kennykb
 # Initial revision
 #

# Procedure:	toplevel_focusIn
#
# Synopsis:
#	Handle the <FocusIn> event on top-level windows.
#
# Usage:
#c	toplevel_focusIn pathName detail
#
# Parameters:
#c	pathName
#		Path name of a toplevel widget (or the root window of the
#		application)
#c	detail
#		Detail field from a FocusIn event.
#
# Return value:
#	None.
#
# Description:
#	toplevel_focusIn is called to process <FocusIn> events on top-level
#	windows.  If the <FocusIn> event has a detail field of NotifyVirtual,
#	it indicates that focus has been directed to the given top-level
#	window by the window manager.  In this case, focus is directed to
#	the currently-focused component within the window.  Other detail
#	fields do nothing.
#
# Notes:
#	Focus is not redirected while a grab is active.
#
# Global variables used:
#c	focus_priv(current,$w)
#		Most recently focused item among the children of toplevel
#		window $w.

proc toplevel_focusIn {w detail} {
	global focus_priv
	if {$detail == "NotifyVirtual"} {
		if {[info exists focus_priv(current,$w)]} {
			set f $focus_priv(current,$w)
		} else {
			set f [focus:first $w]
		}
		if {$f == ""} {
			return
		}
		set g [grab current $w]
		if {$g != ""} {
			return
		}
		if {[lindex $f 0] == [focus]} {
			if {[llength $f] <= 1} return
			if {[lindex $f 1] == [[focus] focus]} return
		}
		after 1 "catch \"focus_goTo $f\""
	}
}

