 #########################################################################
 #                                                                       #
 # Copyright (C) 1993 by General Electric company.  All rights reserved. #
 #                                                                       #
 # Permission to use, copy, modify, and distribute this                  #
 # software and its documentation for any purpose and without            #
 # fee is hereby granted, provided that the above copyright              #
 # notice appear in all copies and that both that copyright              #
 # notice and this permission notice appear in supporting                #
 # documentation, and that the name of General Electric not be used in   #
 # advertising or publicity pertaining to distribution of the            #
 # software without specific, written prior permission.                  #
 #                                                                       #
 # General Electric makes no representations about the suitability of    #
 # this software for any purpose.  It is provided ``as is''              #
 # without express or implied warranty.                                  #
 #                                                                       #
 # This work was supported in part by the DARPA Initiative in Concurrent #
 # Engineering (DICE) through DARPA Contracts MDA972-88-C-0047 and       #
 # MDA972-92-C-0027.                                                     #
 #                                                                       #
 # This work was supported in part by the Tri-Services Microwave and     #
 # Millimeter-Wave Advanced Computational Environment (MMACE) program    #
 # under Naval Research Laboratory contract N00014-92-C-2044.            #
 #                                                                       #
 #########################################################################


# File: errormessage.tcl

# Description:
#	errormessage -- display an error message from a Tcl script

# Global variables:
#	errormessage_priv
#		This variable is used as a synchronization control.  When
#		an error message is displayed, the program does a 
#			`tkwait variable errormessage_priv'
#		When the user dismisses the error message, the variable is
#		set, allowing the program to resume.

 # errormessage.tcl,v 1.3 1995/03/21 15:04:54 drs1004 Exp
 # /homes/drs1004/repository/tkaux/errormessage.tcl,v
 # errormessage.tcl,v
# Revision 1.3  1995/03/21  15:04:54  drs1004
# Patch 1, 0.2b.  Bug fixes suggested by Michael Norrish.
#
# Revision 1.2  1995/01/26  14:06:29  drs1004
# Major revisions for version 0.1bp4.  Lots of changes everywhere,
# the biggest being the use of the hierarchy widget.
#
# Revision 1.1.1.1  1994/12/07  10:17:29  donald
# First import after some small chanegs.
#
 # Revision 1.12  1994/10/27  18:29:42  kennykb
 # Release 2.0 -- 10-27-94.  To be uploaded to archive sites.
 #
 # Revision 1.11  1993/11/01  18:20:46  kennykb
 # Beta release to be announced on comp.lang.tcl
 #
 # Revision 1.10  1993/10/27  15:52:49  kennykb
 # Package for alpha release to the Net, and for MMACE 931101 release.
 #
 # Revision 1.9  1993/10/20  19:10:47  kennykb
 # Alpha release #1 was thawed for bug fixes in tk 3.3.  Now frozen again at this
 # point.
 #
 # Revision 1.8  1993/10/20  18:43:01  kennykb
 # Repaired copyright notice so that it doesn't look like structured commentary.
 #
 # Revision 1.7  1993/10/14  18:15:42  kennykb
 # Cleaned up alignment of log messages, to avoid problems extracting
 # structured commentary.
 #
 # Revision 1.6  1993/10/14  18:06:59  kennykb
 # Added GE legal notice to head of file in preparation for release.
 #
 # Revision 1.5  1993/10/14  14:02:02  kennykb
 # Alpha release #1 frozen at this point.
 #
 # Revision 1.4  1993/10/14  13:33:09  kennykb
 # Changed to use `widget_waitVariable to avoid process hangs when the
 # application is destroyed.
 #
 # Revision 1.3  1993/07/21  19:44:36  kennykb
 # Finished cleaning up structured commentary.
 #
 # Revision 1.2  1993/07/20  19:17:12  kennykb
 # Improved structured comments.
 # Changed modules through `g' in the alphabet to follow `:' and `_' naming
 # conventions.
 #
 # Revision 1.1  1993/06/03  15:27:19  kennykb
 # Initial revision
 #

# Procedure:	errormessage
#
# Synopsis:
#	Display an error message.
#
# Usage:
#c	errormessage pathName text
#
# Parameters:
#c	pathName
#		Path name of a top level window which will be created to
#		hold the error message.
#c	text	
#		Text of the message.
#
# Return value:
#	None.
#
# Description:
#	The errormessage procedure displays an alert message on the screen.
#	The text is supplied by the user; the icon will be a diagonal in a
#	circle.  A single button is provided in the alert box, labeled `OK',
#	which dismisses the box.  The box is a modal dialog; interaction with
#	the user resumes when the button is pressed.
#
# Notes:
#	This is basically a trivial front end to `choicebox.'  Use the
#	latter if a custom look-and-feel is required.
#
# See also:
#c	choicebox
#
#c	tkerror

 # X resources

option add *Errormessage.borderWidth 2 21
option add *Errormessage.relief raised 21
option add *Errormessage*Foreground black 21
option add *Errormessage.top.m.Foreground black 21
option add *Errormessage*Background #ffe4c4  21

proc errormessage {w text} {
	global errormessage_priv
	modalDialog transient choicebox $w \
		-text $text \
		-buttons OK \
		-icon error \
		-textvariable errormessage_priv \
		-withfeedback 0
	widget_waitVariable errormessage_priv
	unset errormessage_priv
	modalDialog.end $w
}
