#############################################################################
#   feedback.tcl,v 1.7 1995/03/21 15:04:32 drs1004 Exp
#    Copyright (C) 1994  Donald Syme
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 1, or (at your option)
#    any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
#    Contact Details:
#	Donald Syme
#	The Computer Laboratory
#	New Musuems Site
#	Pembroke St.
#	Cambridge U.K. CB2 3QG
#
#	email: Donald.Syme@cl.cam.ac.uk
#
#############################################################################

#----------------------------------------------------------------------------
#
# feedback/busy output window
#
# Can be redirected to any label widget using feedback::redirect.
#
# Activate simply by setting the global variables "feedback" and "busy"
#----------------------------------------------------------------------------


proc feedback::InitialisePackage { } {

	global busy 
	global feedback
	global feedback_vals

	global gui_flags
	global busy_vals
	set busy_vals(old_busy) 0

	wm geometry . 1x1
	wm transient .

	pack [frame .f -relief sunken -borderwidth 2]
	pack [fontcheck label .feedback  \
		-font $gui_flags(font,feedback) \
		-height 1 \
		-width 50 \
		-anchor center] \
	    -expand yes -fill x -in .f -padx 5 -pady 50
	update

	set feedback_vals(win) .feedback
	set feedback_vals(altered_feedbacks) ""

	trace variable busy w busy::set_happened
	set busy 0
	trace variable feedback w feedback::set_happened

	set feedback [list . "Loading..."]
}


proc feedback::set_happened {arg1 arg2 arg3 } {
    	global feedback
	global feedback_vals

	# Detect a change in feedback window.  
	# Also detect switches to and from the
	# feedback window .feedback, which has special popup behaviour.

	set new_feedback_window $feedback_vals(win)
	set win [lindex $feedback 0]
	if {$win!="" && $win!="quick"} {
	    set top_of_win [winfo toplevel $win]
	    if {$top_of_win=="."
		|| ![winfo exists $top_of_win.feedback]
		|| ![winfo ismapped $top_of_win.feedback]} {
		set new_feedback_window .feedback
	    } else {
		set new_feedback_window $top_of_win.feedback
	    }
	}
	
	# We know now where we would like to send the feedback, but
	# if it is not mapped we use .feedback instead.  
	# There is an exception to this - when the 
	# "quick" feedback window specification
	# is used (indicating that speed is more important than
	# popping up a whole feedback window) we
	# only want to use a feedback window if it is already available and
	# visible.
	#
	# It really is rather important to have some window which is grabbing
	# events during a busy period, so 
	# when "quick" is specified we should do our best to search
	# for other feedback windows that are visible and use them.
	# Or even better would be have an invisible
	# window to capture input like "blt_busy" does.
	
	if {![winfo exists $new_feedback_window] || ![winfo ismapped $new_feedback_window]} {
	    if {$win=="quick"} {
	        return
	    } else {
	        set new_feedback_window ".feedback"
	    }
	}
	
	# At this point we have definitely decided which
	# feedback window to use (i.e. $new_feedback_window).
	# If this is different to the last one then we
	# have to do a few things, like change who has the grab
	# pop .feedback up/down according to need.
	#
	if {$feedback_vals(win)!=$new_feedback_window} {
	        catch {grab release $feedback_vals(win)}
                if {$feedback_vals(win)==".feedback"} {
		     wm withdraw .
		}
	        grab set $new_feedback_window
	        focus $new_feedback_window
		set feedback_vals(win) $new_feedback_window
	}
	if {$new_feedback_window==".feedback" && [wm state .]=="withdrawn"} {
	    feedback::deiconify
	}
	global busy
	incr busy 1

#	puts "win = \{$win\}, grab = [grab current]"

	set cutoff [expr [winfo width $feedback_vals(win)]/6]
	$feedback_vals(win) config -text [string range [lindex $feedback 1] 0 $cutoff]
	lappend feedback_vals(altered_feedbacks) $feedback_vals(win)
	update idletasks

	after 1 {
	    global busy
	    incr busy -1
	}
}



proc busy::set_happened {arg1 arg2 arg3 } {
	global busy feedback 
	global busy_vals
	global feedback_vals

	global gui_flags
	if {$busy<0} {
	    puts stderr "Warning: $gui_flags(title) internal error: busy set below 0"
	    set busy 0
	    return
	}
	
#	puts "busy_vals(old_busy) = $busy_vals(old_busy), busy = $busy, feedback_vals(win) = $feedback_vals(win), grab current = [grab current]"

	if {$busy_vals(old_busy)==0 && $busy==1} {
    	# If feedback is being sent to .feedback, then 
	# withdraw the window, then update all the geometry information
    	# so we know how big it wants to be, then center the window in the
    	# display and de-iconify it.

	    foreach win [info commands .*] {
		catch {[winfo toplevel $win] config -cursor watch}
	    }
	} 
	if {![info exists busy_vals(old_focus)] && [focus]!="none"} {
	    set busy_vals(old_focus) [focus]
	    focus none
	}
	catch {grab set $feedback_vals(win)}
	if {$busy_vals(old_busy)>0 && $busy == 0} {
	    foreach afw $feedback_vals(altered_feedbacks) {
	        catch {$afw config -text "Ready..."}
            }
	    set feedback_vals(altered_feedbacks) ""
	    foreach win [info commands .*] {
		catch {[winfo toplevel $win] config -cursor {}}
	    }
	    catch {wm withdraw .}
	    catch {grab release $feedback_vals(win)}
	    if [info exists busy_vals(old_focus)] {
	        if {[focus]=="none"} {
	            catch {focus $busy_vals(old_focus)}
		}
		unset busy_vals(old_focus)
	    }
	} 
	set busy_vals(old_busy) $busy
}



proc feedback::deiconify { } {
	      set w .
              if {[wm state $w] != "normal"} {
                wm withdraw $w
                set x [expr [winfo screenwidth $w]/2 - [winfo reqwidth $w]/2 \
                    - [winfo vrootx $w]]
                set y [expr [winfo screenheight $w]/2 - [winfo reqheight $w]/2 \
                    - [winfo vrooty $w]]
                wm geom $w 312x126+$x+$y
                wm deiconify $w
	        raise .
                update idletasks
              }
}
