#############################################################################
#   TkTRS.tcl,v 1.16 1995/03/07 21:39:45 drs1004 Exp
#    Copyright (C) 1994  Donald Syme
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 1, or (at your option)
#    any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
#    Contact Details:
#	Donald Syme
#	The Computer Laboratory
#	New Musuems Site
#	Pembroke St.
#	Cambridge U.K. CB2 3QG
#
#	email: Donald.Syme@cl.cam.ac.uk
#
#############################################################################


proc TkTRS::delayed_Load { } {
	global TkTRS_flags TkTRS_library
	global feedback
	if !$TkTRS_flags(loaded) {
	    set feedback [list {} "Loading the trs library..."]
	    if [hol90] {
	        set feedback [list {} "Loading trs library, 30-60 seconds...  (Note: this may be loaded at startup via the Options menu.)"]
	    }
            hol_load_library trs
	    ML -toplevel 1 "
		    [ml_fun] trs_thmkind_text thmkind = if (thmkind=Axiom) then [ml_string axiom]
		                       else if (thmkind=Definition) then [ml_string definition]
				       else if (thmkind=Theorem) then [ml_string theorem]
				       else [ml_string {}]
	    "
	    ML -toplevel 1 "
		     [ml_fun] foundthms_to_strings (thmkind,(thryname,(thmname,_))) = 
			[ml_list [list [ml_string \{] thmname [ml_string { }] {(trs_thmkind_text thmkind)}  [ml_string { }] thryname [ml_string "\} "]]] 
	    "
            set TkTRS_flags(loaded) 1
	}
}

#----------------------------------------------------------------------------
#
# WIDGET CLASS TkTRS
#
# CONFIGURATION OPTIONS
#	-resultsHandler
#		A command to execute at the end of each search.  The 
#		list of theorems found by the search is appended to the
#		command before it is executed.  If the handler is
#		empty then no command is executed and the results
#		of the search are thrown away.
#
#	-sources
#		A list of theories to select initially to search.
#		Defaults to the empty list.
#
# COMMANDS
#
#----------------------------------------------------------------------------

option add *TkTRS.sources "" widgetDefault
option add *TkTRS.resultsHandler "newwin TheoremsTopLevel -title {Search Results} -thmspecs" widgetDefault
option add *TkTRS.withfeedback 1 widgetDefault

proc TkTRS { w args } {
	global gui_flags 
	global TkTRS_flags
	global feedback
	global busy
	incr busy
	global vals

	set ancestors 0
	set descendants 0
	for {set i 0} {$i<[llength $args]} {incr i} {
	    case [lindex $args $i] -resultsHandler {
	        incr i
	        set vals($w,resultsHandler) [lindex $args $i]
	    } -sources {
	        incr i
	        set sources [lindex $args $i]
	    } -withfeedback {
	        incr i
	        set withfeedback [lindex $args $i]
	    } -descendants {
	        incr i
	        set descendants [lindex $args $i]
	    } -ancestors {
	        incr i
	        set ancestors [lindex $args $i]
	    } default {
	    	error "unrecognized arg [lindex $args $i]"
	    }
	}



	TkTRS::delayed_Load
	toplevel $w -class TkTRS

	if ![info exists vals($w,resultsHandler)] { set vals($w,resultsHandler) [option get $w resultsHandler ResultsHandler] }
	if ![info exists sources] { set sources [option get $w sources Sources] }
	if ![info exists withfeedback] { set withfeedback [option get $w withfeedback WithFeedback] }

	# 2. Do some windowing grunge.
	#

	wm minsize $w 1 1
	wm title $w TkTRS
	wm withdraw $w
	
	set feedback [list {} "Creating TkTRS display..."]
	
	if {$withfeedback} {
	    fontcheck label $w.feedback \
		-height 1 \
		-width 40 \
		-anchor w \
		-relief sunken \
		-font $gui_flags(font,feedback)
	    pack $w.feedback -side bottom -expand no -fill x
	}

	frame $w.controls -borderwidth 2
	pack $w.controls -side bottom
	fontcheck focusable button $w.controls.search \
		-command "TkTRS::start_search $w" \
		-text "Start Search" \
		-width 12 \
		-font $gui_flags(font,buttons)
	pack $w.controls.search -side left -fill x -padx 10 -pady 10
#	fontcheck focusable button $w.controls.help \
#		-command "" \
#		-text "Help" \
#		-width 12 \
#		-font $gui_flags(font,buttons)
#	pack $w.controls.help -side left -fill x -padx 10 -pady 10
	fontcheck focusable button $w.controls.close \
		-command "destroy $w" \
		-text "Close" \
		-width 12 \
		-font $gui_flags(font,buttons)
	pack $w.controls.close -side left -fill x -padx 10 -pady 10
	
	frame $w.sources
	pack $w.sources -side top -fill both -expand yes -padx 10 -pady 10

#	    ParentsFrame $w.sources.parents \
#		-multiselect 1 \
#		-height 150 \
#		-width 400 \
#		-relief sunken \
#		-command "TkTRS::new_sources $w"
#	    pack $w.sources.parents -side right -fill both -expand yes

	    #---------------
	
	
	    pack [frame $w.ancestry] -in $w.sources -side left -fill y -expand yes
	    pack [fontcheck label $w.ancestry.lab -font $gui_flags(font,labels) -text "Don't Search:" -anchor w] -side top -fill x
    	    fontcheck listbox $w.ancestry.list \
		-yscroll "$w.ancestry.scroll set" \
		-relief sunken \
		-export false \
            	-setgrid 1 \
		-font $gui_flags(font,listboxes)

    	    pack [scrollbar $w.ancestry.scroll -relief sunken -command "$w.ancestry.list yview"] -side $gui_flags(scrollbarSide) -fill y
    	    pack $w.ancestry.list -side left -fill y

	    set ancestry [hol_ancestry]
	    eval [list $w.ancestry.list insert] end [lsort $ancestry]

	    #---------------

	    pack [frame $w.sources.controls] -side left -pady 20
	    pack [fontcheck focusable button $w.sources.controls.add \
			-text ">>>" \
			-font $gui_flags(font,buttons) \
			-command "TkTRS::movesources $w $w.ancestry.list $w.sourcelist.list 0 0" \
			-width 14]
	    pack [fontcheck focusable button $w.sources.controls.addparents -text "ancestors >>>" -font $gui_flags(font,buttons) -command "TkTRS::movesources $w $w.ancestry.list $w.sourcelist.list 1 0" -width 14]
	    pack [fontcheck focusable button $w.sources.controls.adddesc -text "descendants >>>" -font $gui_flags(font,buttons) -command "TkTRS::movesources $w $w.ancestry.list $w.sourcelist.list 0 1" -width 14]
	    pack [fontcheck focusable button $w.sources.controls.remove -text "<<<" -font $gui_flags(font,buttons) -command "TkTRS::movesources $w $w.sourcelist.list $w.ancestry.list 0 0" -width 14]
	    pack [fontcheck focusable button $w.sources.controls.removeparents -text "<<< ancestors" -font $gui_flags(font,buttons) -command "TkTRS::movesources $w $w.sourcelist.list $w.ancestry.list 1 0" -width 14]
	    pack [fontcheck focusable button $w.sources.controls.removedesc -text "<<< descendants" -font $gui_flags(font,buttons) -command "TkTRS::movesources $w $w.sourcelist.list $w.ancestry.list 0 1" -width 14]

	    #---------------



	    pack [frame $w.sourcelist] -in $w.sources -side right -fill y -expand yes
	    pack [fontcheck label $w.sourcelist.lab -font $gui_flags(font,labels) -text "Search:" -anchor w]  -side top -fill x

    	    fontcheck listbox $w.sourcelist.list -yscroll "$w.sourcelist.scroll set" \
		-relief sunken \
		-export false \
            	-setgrid 1 \
		-font $gui_flags(font,listboxes)

    	    pack [scrollbar $w.sourcelist.scroll -relief sunken -command "$w.sourcelist.list yview"] -side $gui_flags(scrollbarSide) -fill y
    	    pack $w.sourcelist.list -side left -fill y

	
	pack [frame $w.patt -borderwidth 2] -side top -fill x -padx 10 -pady 10
	pack [fontcheck label $w.patt.lab -font $gui_flags(font,labels) -text "Select a Search Method:" -anchor w] -side top -fill x
	pack [frame $w.patt.f0] -side left -expand yes -fill x
	pack [frame $w.patt.f1] -side right -expand yes -fill x
	set patt_types [list \
		[list conc_matches "Theorems matching:"] \
		[list conc_contains "Theorems containing:"] \
		[list thmname_matches "Theorem names matching:"] \
		[list arb_patt "This TRS pattern:"]]
	set i 0
	set num [llength $patt_types]
	if {$num%2==1} {incr num}
	foreach patt_type_pr $patt_types {
	    set patt_type [lindex $patt_type_pr 0]
	    set patt_type_label [lindex $patt_type_pr 1]
	    frame $w.patt.$patt_type
	    pack $w.patt.$patt_type -side top -expand yes -padx 10 -pady 10 -in $w.patt.f[expr ($i/($num/2))]
	    fontcheck focusable radiobutton $w.$patt_type \
			-font $gui_flags(font,buttons) \
			-text $patt_type_label \
			-anchor w \
			-variable vals($w,patt_type) \
			-value $patt_type \
			-relief flat \
			-command "
				if [focus_update] return
				$w.entry_$patt_type select from 0
				$w.entry_$patt_type select to end
				focus $w.entry_$patt_type"
	    pack $w.$patt_type -side top -fill x -in $w.patt.$patt_type
	    fontcheck entry $w.entry_$patt_type -relief sunken \
		-font $gui_flags(font,textentry) \
		-textvariable vals($w,$patt_type) \
		-width 30
	    pack $w.entry_$patt_type -side bottom -fill x -in $w.patt.$patt_type
	    bind $w.entry_$patt_type <ButtonRelease-1> "+set vals($w,patt_type) $patt_type"
	    incr i
	}
	
	    foreach source $sources {
	        for {set i 0} {$i < [$w.ancestry.list size]} {incr i} {
		    if {[$w.ancestry.list get $i]==$source} {
			$w.ancestry.list select from $i
			$w.ancestry.list select to $i
		    }
		}
                TkTRS::movesources $w $w.ancestry.list $w.sourcelist.list $ancestors $descendants
	    }

	set vals($w,conc_matches) "any:bool"
	set vals($w,conc_contains) "any:*"
	set vals($w,thmname_matches) "*"
	set vals($w,arb_patt) "(conc [hol_term any:bool]) Where (...)"
	global vals($w,patt_type)
	set vals($w,patt_type) conc_matches 
	set old_focus [focus]
	focus_goToFirst $w.controls
	button_setDefault $w.controls.search

	update idletasks
	wm deiconify $w
	tkwait visibility $w

	# 
	# 3. Wait for the search to be done, if no resultsHandler
	# has been specified.
	# (i.e. when a modal dialog box).
	#

	widget_addBinding $w Destroy "unset_vals_for_widget $w"
	focus_goToFirst $w

	incr busy -1
	return $w
}


#----------------------------------------------------------------------------
# TkTRS::movesources
#
#----------------------------------------------------------------------------

proc TkTRS::movesources { w from to ancestors descendants } {
	global feedback
	global busy
	incr busy
	
	set feedback [list $w "Transferring theories..."]
	foreach elem [$from curselection] {
	    set root [$from get $elem]
	    if {$root==""} continue
	    if $ancestors {
		set tomove [ML -type stringlist "[hol_ancestors] [ml_string $root]"]
		lappend tomove $root
	    } elseif $descendants {
		set tomove [ML -type stringlist "[hol_descendants] [ml_string $root]"]
		lappend tomove $root
	    } else {
		set tomove [list $root]
	    }
	    foreach theory $tomove {
	        for {set i 0} {$i < [$from size]} {incr i} {
		    if {[$from get $i]==$theory} {
			$from delete $i
		    }
		}
	    }
	    for {set i 0} {$i < [$to size]} {incr i} {
		if {[lsearch -exact $tomove [$to get $i]]==-1} {
		    lappend tomove [$to get $i]
		}
	    }
	    $to delete 0 end
	    eval [list $to insert end] [lsort $tomove]
	}
	incr busy -1
}


#----------------------------------------------------------------------------
# TkTRS::thmpattern
#
#----------------------------------------------------------------------------


proc TkTRS::thmpattern { w } {
	global vals 
	case $vals($w,patt_type) conc_matches {
	    return "(conc [hol_term $vals($w,conc_matches)])"
	} conc_contains {
	    return "((conc [hol_term any:bool]) Where ([hol_term any:bool] contains [hol_term $vals($w,conc_contains)]))"
	} thmname_matches {
	    return "(thmname [ml_string $vals($w,thmname_matches)])"
	} arb_patt {
	    return "($vals($w,arb_patt))"
	}
}

proc TkTRS::sources { w } {
	set searchpaths ""
#	foreach ancestor [hierarchy::selection $w.sources.parents.hier] {
#	    	lappend searchpaths "(Theory [ml_string $ancestor])\n"
#	}
	for {set i 0} {$i < [$w.sourcelist.list size]} {incr i} {
	    lappend searchpaths "(Theory [ml_string [$w.sourcelist.list get $i]])\n"
	}
	return $searchpaths
}


#----------------------------------------------------------------------------
# TkTRS::start_search
#
#----------------------------------------------------------------------------

proc TkTRS::start_search { w } {
	global feedback
	global busy
	if [focus_update] return

	incr busy

	# 1. Load the trs library if needed.
	
	TkTRS::delayed_Load
	global vals 

	set thmpattern [TkTRS::thmpattern $w]	
	set sources [TkTRS::sources $w]

	if [llength $sources]==0 {
	    errormessage $w.error "Please specify some theories to search."
	}

	set sourceml "(Paths [ml_list $sources])"
	set feedback [list $w "Starting Search..."]
	if [catch {ML -check 1 "concatl ([hol_flatten] (map foundthms_to_strings (full_search \n$thmpattern \n$sourceml)))"} thms] { incr busy -1; errormessage $w.error $thms ; return }

	if {[set vals($w,resultsHandler)] == ""} {
	    global search_results
	    set search_results [lsort $thms]
	} else {
	    if {[llength $thms]==0} {
	        errormessage $w.error "No matching theorems found."    	
	    } else {
	   	eval [set vals($w,resultsHandler)] [list [lsort $thms]]
	    }
	}
	incr busy -1
	
}


#----------------------------------------------------------------------------
#
#----------------------------------------------------------------------------

proc trs { } {
   after 1 {
	catch {destroy .trsdialog}
   	source $TkTRS_library/TkTRS.tcl
   	source $HolRichText_library/TheoremsTopLevel.tcl
   	source $HolRichText_library/TheoremsFrame.tcl
   	newwin TkTRS
   }
}
