#############################################################################
#   InitialisePackage.tcl,v 1.3 1995/03/01 11:32:25 drs1004 Exp
#    Copyright (C) 1994  Donald Syme
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 1, or (at your option)
#    any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
#    Contact Details:
#	Donald Syme
#	The Computer Laboratory
#	New Musuems Site
#	Pembroke St.
#	Cambridge U.K. CB2 3QG
#
#	email: Donald.Syme@cl.cam.ac.uk
#
#############################################################################



proc TkTRS::ProcessArgs { argc argv } {
	global TkTRS_flags

	if {[llength [info commands Preferences_Add]]==1} {
    	    Preferences_Add "TkTRS" "Options related to loading and using the TkTRS Theory Retrieval System are specified here." \
	 	[list \
		    [list TkTRS_flags(loadOnStartup) loadOnStartup "OFF" "Load trs library on startup" "If this option is set then the trs library will be loaded upon startup, instead of when it is first used."] \
	     ]
    	}

}

proc TkTRS::InitialisePackage { } {
	global TkTRS_flags
	global TkTRS_library
	set TkTRS_flags(loaded) 0

	if [hol90] {
	    ML -toplevel 1 "Globals.library_path := \n([ml_string $TkTRS_library/trs90/] \n:: (!Globals.library_path))"
	    ML -toplevel 1 "find_library [ml_string trs]"
	}
	if $TkTRS_flags(loadOnStartup) {
	    TkTRS::delayed_Load
	}
}

