(*--------------------------------------------------------------       *)
(* current_theory_notify.sig,v 1.1 1995/02/28 23:32:00 drs1004 Exp	       *)
(* 								       *)
(* Provides a replacement set of `theory functions`, i.e.	       *)
(* save_thm, new_parent, close_theory, extend_theory and so on.	       *)
(*								       *)
(* Things in this file should be considered pretty volatile, but	*)
(* they will eventually settle down.					*)
(*									*)
(* My hope would be that this functionality will eventually be 		*)
(* incorporated into the base HOL systems.				*)
(*								       *)
(* The repacement functions are operationally equivalent, except       *)
(* that they will also `notify` other interested clients in the system *)
(* of the change that has occured in the theory =>  This can be used     *)
(* to mimic the changes in an interface, even if the operations are    *)
(* performed by a package external to the interface.		       *)
(*								       *)
(* CLIENTS							       *)
(*								       *)
(* There are two types of clients - ML and Tcl =>  		       *)
(*								       *)
(* ML clients are a group of ML functions each of which is called      *)
(* when appropriate =>  An ML client also has a			       *)
(* name (which should be unique amongst clients)		       *)
(* by which it may be removed.					       *)
(*								       *)
(* Tcl clients							       *)
(* are a special class of client which pass calls directly	       *)
(* through to tcl functions with particular names and argument	       *)
(* patterns =>  For instance, for each tcl client of the theory	       *)
(* the function							       *)
(*								       *)
(*	<tclclass>::save_thm_Notify <tclobj> <theory> <thmname>	       *)
(*								       *)
(* will be called each time a theorem is save to the theory =>  Here     *)
(* <tclclass> and <tclobj> are specified when creating the client =>     *)
(* <theory> is the theory to which the theorem was saved, and	       *)
(* <thmname> is the name of the theorem just saved.		       *)
(*								       *)
(* Tcl clients do not have to support all the notification messages    *)
(* (unlike ML clients), but they must indicate which ones they want    *)
(* to recieve.	 						       *)
(*								       *)
(*--------------------------------------------------------------       *)
								        

signature CurrentTheoryNotification_sig = sig
	type client

	val add_client: client -> unit
	val remove_client: string -> unit
	val mk_client: string * 
			(string -> unit) * 	  	(* called when chrrent theory change *)             
			(string -> unit) * 	  	(* called when new parent added to current theory *)
			(bool -> unit) -> client  	(* called when current theory mode change *)        

	val extend_theory: string -> unit
	val new_theory: string -> unit
	val load_theory : string -> unit
	val close_theory : unit -> unit
	val new_parent : string -> unit
	val load_library : {lib:lib, theory:string} -> unit
	
	val test : unit -> bool;
end

signature TclCurrentTheoryNotification_sig = sig
	type client
	val mk_client: string * (* the class *)
		       string   (* additional arguments *)
			-> client
	val add_client: client -> unit
	val remove_client: client -> unit
end	

