#############################################################################
#   InitialisePackage.tcl,v 1.3 1995/03/21 17:42:33 drs1004 Exp
#    Copyright (C) 1994  Donald Syme
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 1, or (at your option)
#    any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
#    Contact Details:
#	Donald Syme
#	The Computer Laboratory
#	New Musuems Site
#	Pembroke St.
#	Cambridge U.K. CB2 3QG
#
#	email: Donald.Syme@cl.cam.ac.uk
#
#############################################################################


#----------------------------------------------------------------------------
# HolRichText::ProcessArgs
#
# 	-norichtext 	turn rich text output off.  Automatically off
#			for hol90.
#
#----------------------------------------------------------------------------

proc HolRichText::ProcessArgs { argc argv } {
	global HolRichText_flags
	set HolRichText_flags(richtext) 1

if {[llength [info commands Preferences_Add]]==1} {
    Preferences_Add "HOL Rich Text" "Preferences related to the formatting of HOL terms may be specified here.  Terms may be displayed in two formats - teletype and RichText.  RichText is presently only available for HOL 88." [list \
	[list HolRichText_flags(interfaceMapping) holRichTextInterfaceMapping ON "Interface Mapping" "Specifies whether TkHolWorkbench should perform its own interface mapping to produce special symbols such as those for set and arithmetic operations."] \
	[list HolRichText_flags(tmpfile) holRichTextTmpFile "/tmp/HolRichText.[exec whoami]" "Temporary Transfer File" ""] \
	[list HolRichText_flags(font,teletype) holRichTextTeletypeFont [list FONT "-Adobe-Courier-Medium-R-Normal-*-*-120-*"] "Teletype - Font" "The font used for teletype term formatting."] \
	[list HolRichText_flags(font,richtext,var) holRichTextVariablesFont [list FONT "-Adobe-New Century Schoolbook-Medium-I-Normal-*-*-120-*"] "HOL Variables - Font" "The font used to display HOL variables."] \
	[list HolRichText_flags(font,richtext,tmsym) holRichTextSymbolsFont [list FONT "-Adobe-Symbol-Medium-R-Normal-*-*-140-*"] "HOL Symbols - Font" "The font used to display HOL symbols."] \
	[list HolRichText_flags(font,richtext,tmbigsym) holRichTextBigSymbolsFont [list FONT "-Adobe-Symbol-Medium-R-Normal-*-*-180-*"] "Large RichText Symbols - Font" "The font used to display large HOL symbols."] \
	[list HolRichText_flags(font,richtext,tmconst) holRichTextConstantsFont [list FONT "-Adobe-New Century Schoolbook-Medium-R-Normal-*-*-120-*"] "HOL Constants - Font" "The font used to display HOL constants."] \
	[list HolRichText_flags(font,richtext,tm) holRichTextMiscFont [list FONT "-Adobe-New Century Schoolbook-Medium-R-Normal-*-*-120-*"] "Other RichText Output - Font" "The font used to display miscellaneous RichText output."] \
	[list HolRichText_flags(font,thmname) holRichTextThmNameFont [list FONT "-Adobe-Helvetica-Medium-R-Normal-*-*-100-*"] "Theorem Names - Font" "The font used to display the theorem name in the header to each theorem."] \
	[list HolRichText_flags(font,thmkind) holRichTextThmTypeFont [list FONT "-Adobe-Helvetica-Medium-O-Normal-*-*-100-*"] "Theorem Type - Font" "The font used to display the theorem type in the header to each theorem."] \
	[list HolRichText_flags(color,teletype) holRichTextTeletypeColor [list COLOR black] "Teletype - Color" "The color used for teletype term formatting."] \
	[list HolRichText_flags(color,richtext,var) holRichTextVariablesColor [list COLOR blue] "HOL Variables - Color" "The color used to display HOL variables."] \
	[list HolRichText_flags(color,richtext,tmsym) holRichTextSymbolsColor [list COLOR black] "HOL Symbols - Color" "The color used to display HOL symbols."] \
	[list HolRichText_flags(color,richtext,tmconst) holRichTextConstantsColor [list COLOR black] "HOL Constants - Color" "The color used to display HOL constants."] \
	[list HolRichText_flags(color,richtext,tm) holRichTextMiscColor [list COLOR black] "Other RichText Output - Color" "The color used to miscellaneous RichText output."] \
	[list HolRichText_flags(color,thmname) holRichTextThmNameColor [list COLOR black] "Theorem Names - Font" "The color used to display theorem name in the header to each theorem."] \
	[list HolRichText_flags(color,thmkind) holRichTextThmTypeColor [list COLOR black] "Theorem Type - Font" "The color used to display the theorem type in the header to each theorem."] \
    ]
}

	for {set arg 0} {$arg < $argc} {incr arg} {
	    if {[lindex $argv $arg]=="-norichtext"} {
	        set HolRichText_flags(richtext) 0
	    }
	}
}


proc HolRichText::InitialisePackage { } {
	global HolRichText_flags
	set HolRichText_flags(loaded) 0
}

