#############################################################################
#   MLsyntax.tcl,v 1.17 1995/04/04 16:39:18 drs1004 Exp
#    Copyright (C) 1994  Donald Syme
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 1, or (at your option)
#    any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
#    Contact Details:
#	Donald Syme
#	The Computer Laboratory
#	New Musuems Site
#	Pembroke St.
#	Cambridge U.K. CB2 3QG
#
#	email: Donald.Syme@cl.cam.ac.uk
#
#############################################################################

#----------------------------------------------------------------------------
#
# Encapsulates most things that vary from one version of HOL to another
#
#----------------------------------------------------------------------------

proc hol88 { } {
    global TkHolSlave_flags
    return $TkHolSlave_flags(hol88)
}

proc hol90 { } {
    global TkHolSlave_flags
    return $TkHolSlave_flags(hol90)
}				       



proc hol_load_library { lib } {
	if [hol88] { ML -log 1 -type void "load_library [ml_string $lib]" }
	if [hol90] { ML_bind  "_" "load_library \{ lib=(find_library [ml_string $lib]), theory=[ml_string -] \}" -log 1 -check 1 }
}

proc hol_type_var { n } {
	set var ""
	if [hol88] {
	    for {set i 0} {$i<$n} {incr i} {
	        set var [set var]*
	    }
        }
	if [hol90] {
	    case $n 1 { return 'a } 2 { return 'b } 3 { return 'c }
        }
	return $va
}


proc hol_prove_induction_thm { } {
	if [hol88] { return prove_induction_thm }
	if [hol90] { return Rec_type_support.prove_induction_thm }
}
proc hol_prove_constructors_one_one { } {
	if [hol88] { return prove_constructors_one_one }
	if [hol90] { return Rec_type_support.prove_constructors_one_one }
}
proc hol_prove_constructors_distinct { } {
	if [hol88] { return prove_constructors_distinct }
	if [hol90] { return Rec_type_support.prove_constructors_distinct }
}
proc hol_prove_cases_thm { } {
	if [hol88] { return prove_cases_thm }
	if [hol90] { return Rec_type_support.prove_cases_thm }
}

proc hol_ancestry { } {
	if [hol88] {
	    return [ML -type stringlist "ancestry ()"]
	}
	if [hol90] {
	    set ancestors [ML -type stringlist "ancestry (current_theory())"]
	    lappend ancestors [ML "current_theory()"]
	    return $ancestors	
	}
}
proc hol_ancestors { } {
	if [hol88] { return "ancestors" }
	if [hol90] { return "ancestry" }
}

proc hol_descendants { } {
	if [hol88] { 
		return "(\\thr. filter (\\desc. mem thr (ancestors desc)) (ancestry ()))"
	}
	if [hol90] { 
		return "(fn thr => filter (fn desc =>  mem thr (ancestry desc)) ((ancestry [ml_string -])@\[current_theory()\]))"
	}
}

proc hol_prompt {  } { 
	global hol_prompt
	return $hol_prompt
}

# The hol prompt as a regular expression. Not correct really....

proc hol_re_prompt {  } {
	global hol_prompt
	if {$hol_prompt=="-"} { return {\-} } else { return $hol_prompt }
}

proc hol_thryext {  } { 
	if [hol88] { return th }
	if [hol90] { return thms }
}


proc hol_term { t } { 
	if [hol88] { return \"$t\" }
	if [hol90] { return "(--`$t`--)" }
}

proc hol_flatten {  } { 
	if [hol88] { return flat }
	if [hol90] { return flatten }
}


#----------------------------------------------------------------------------
#
# Encapsulates most things that vary from one version of ML to another
#
#----------------------------------------------------------------------------

proc ml_list { l } { 
	return \[[join $l [ml_listsep]]\]
}

proc ml_output { } { 
	if [hol88] { return tty_write }
	if [hol90] { return "((curry output) std_out)" }
}
proc ml_int_to_string { } { 
	if [hol88] { return string_of_int }
	if [hol90] { return "Lib.int_to_string" }
}
proc ml_eol { } { 
	if [hol88] { return {\L} }
	if [hol90] { return {\n} }
}

proc ml_file_ext {  } { 
	if [hol88] { return ml }
	if [hol90] { return sml }
}


proc ml_listsep {  } { 
	if [hol88] { return ";" }
	if [hol90] { return , }
}

proc ml_val {  } { 
	if [hol88] { return let }
	if [hol90] { return val }
}

proc ml_letval {  } { 
	if [hol88] { return let }
	if [hol90] { return {let val} }
}

proc ml_letin {  } { 
	if [hol88] { return in }
	if [hol90] { return in }
}

proc ml_letend {  } { 
	if [hol88] { return {} }
	if [hol90] { return end }
}

proc ml_fun {  } { 
	if [hol88] { return letrec }
	if [hol90] { return fun }
}
proc ml_lambda {  } { 
	if [hol88] { return "\\" }
	if [hol90] { return fn }
}
proc ml_dot {  } { 
	if [hol88] { return . }
	if [hol90] { return "=>" }
}

proc ml_string { s } {
	if [hol88] { return `$s` }
	if [hol90] { return "\"$s\"" }
}
proc ml_bool { b } {
	if $b { return true } else { return false }
}
proc ml_frag_quote { s } {
	if [hol88] { error "frag-quotes not supported in hol88!" }
	if [hol90] { return `$s` }
}

proc ml_start_comment { } {
	if [hol88] { return "%<" }
	if [hol90] { return "(*" }
}

proc ml_end_comment { } {
	if [hol88] { return ">%" }
	if [hol90] { return "*)" }
}

proc ml_end_dec { } {
	if [hol88] { return ";;" }
	if [hol90] { return ";" }
}


