(* ############################################################################ *)
(*   conv_to_text.sml,v 1.5 1995/04/04 16:38:51 drs1004 Exp		     *)
(*    Copyright (C) 1994  Donald Syme					     *)
(*									     *)
(*    This program is free software; you can redistribute it and/or modify    *)
(*    it under the terms of the GNU General Public License as published by    *)
(*    the Free Software Foundation; either version 1, or (at your option)     *)
(*    any later version.							     *)
(*									     *)
(*    This program is distributed in the hope that it will be useful,	     *)
(*    but WITHOUT ANY WARRANTY; without even the implied warranty of	     *)
(*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the	     *)
(*    GNU General Public License for more details.			     *)
(*									     *)
(*    You should have received a copy of the GNU General Public License	     *)
(*    along with this program; if not, write to the Free Software	     *)
(*    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.		     *)
(*									     *)
(*    Contact Details:							     *)
(*	Donald Syme							     *)
(*	The Computer Laboratory						     *)
(*	New Musuems Site						     *)
(*	Pembroke St.							     *)
(*	Cambridge U.K. CB2 3QG						     *)
(*									     *)
(*	email: Donald.Syme@cl.cam.ac.uk					     *)
(*									     *)
(* ############################################################################ *)

(*-----------------------------------------------------------------------*)
(* thm_to_hol_rich_text_via_file: thm -> string				*)
(* term_to_hol_rich_text_via_file: thm -> string			*)
(* goal_to_hol_rich_text_via_file: thm -> string			*)
(*									*)
(* thm_to_plain_text_via_file: thm -> string				*)
(* term_to_plain_text_via_file: thm -> string				*)
(* goal_to_plain_text_via_file: thm -> string				*)
(*									*)
(* Pretty prints various things into a file in a tagged format suitable	*)
(* for reading by Tcl, or in a plain HOL pretty print format.		*)
(*									*)
(* Returns the name of the temporary file created under /tmp		*)
(* Desperately needs a better way of generating temporary file names     *)
(*-----------------------------------------------------------------------*)

(*
use "TkHolSlave/concatl.sml";
use "HolRichText/conv_to_text.sml";
*)

local
    fun write_to_file s tmpfilename =
	    let val tmpfile = open_out(tmpfilename) in
	    (output (tmpfile,s);
	     close_out tmpfile;
	     tmpfilename)
	end;

    
    fun arb_goal_to_text (term_to_text,gl_asm_sep,asm_begin,asm_end) (numberAssums,firstOnTop) (asms,tm) = 
	let 
            fun asmconv i asm = 
	        [(if (numberAssums) then (int_to_string i) else ""),
	         " ", asm_begin, (term_to_string asm) , asm_end];
	    fun asmtext i asms = 
		if (null asms) then []
		else 
		    let val text = asmconv i (hd asms) in
		        if (firstOnTop) then 
		            text@(asmtext (i+1) (tl asms))
		        else
		            (asmtext (i+1) (tl asms))@text
		    end
	    val glstring = [(term_to_text tm),gl_asm_sep] in
	concatl (glstring@(asmtext 1 asms))
	end
    
in
    val term_to_hol_rich_text_via_file = write_to_file o term_to_string;;
    val thm_to_hol_rich_text_via_file = write_to_file o thm_to_string;;
    fun goal_to_hol_rich_text_via_file args (gl:goal) tmpfilename =
	write_to_file (arb_goal_to_text (term_to_string,"\n\n","[ "," ]\n") args gl) tmpfilename

    val term_to_plain_text_via_file = write_to_file o term_to_string;
    val thm_to_plain_text_via_file = write_to_file o thm_to_string;
    fun goal_to_plain_text_via_file args (gl:goal) tmpfilename = 
	write_to_file (arb_goal_to_text (term_to_string,"\n\n","[ "," ]\n") args gl) tmpfilename
end;



