#############################################################################
#   TheoremsTopLevel.tcl,v 1.4 1995/04/04 16:38:47 drs1004 Exp
#    Copyright (C) 1994  Donald Syme
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 1, or (at your option)
#    any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
#    Contact Details:
#	Donald Syme
#	The Computer Laboratory
#	New Musuems Site
#	Pembroke St.
#	Cambridge U.K. CB2 3QG
#
#	email: Donald.Syme@cl.cam.ac.uk
#
#############################################################################

#----------------------------------------------------------------------------
#
# WIDGET CLASS TheoremsTopLevel
#
# CONFIGURATION OPTIONS
#	All TheoremsFrame options plus...
#
#	-title
#		The thing on the top of the window.
#
#	-thmspecs
#		A list of theorem specifications to display in the window.
#
#      		Defaults to the empty list.
#
#	-withfeedback
#		Whether a feedback line should be displayed at the bottom
#		of the window.
#
#		Defaults to 1.
#
#	-withtext
#		Whether a frame of text should be displayed underneath the
#		theorems.  This is usually code that generates the theorems.
#
#		Defaults to 0.
#
#	-text
#		The text to display if the -withtext option is given.
#
# THEOREM SPECIFICATIONS
#	See the description of theorem specifications in TheoremsFrame.tcl.
#----------------------------------------------------------------------------


option add *TheoremsTopLevel.withfeedback 1 widgetDefault
option add *TheoremsTopLevel.withtext 0 widgetDefault
option add *TheoremsTopLevel.title Theorems widgetDefault
option add *TheoremsTopLevel.header "Theorems:" widgetDefault
option add *TheoremsTopLevel.text "" widgetDefault

proc TheoremsTopLevel { w args } {
	global gui_flags 

	set passon_args ""
	for {set i 0} {$i<[llength $args]} {incr i} {
	    case [lindex $args $i] -thmspecs {
	        incr i
	        set thmspecs [lindex $args $i]
	    } -withfeedback {
	        incr i
	        set withfeedback [lindex $args $i]
	    } -withtext {
	        incr i
	        set withtext [lindex $args $i]
	    } -text {
	        incr i
	        set text [lindex $args $i]
	    } -title {
	        incr i
	        set title [lindex $args $i]
	    } -header {
	        incr i
	        set header [lindex $args $i]
	    } default {
	    	lappend passon_args [lindex $args $i]
		incr i
	    	lappend passon_args [lindex $args $i]
	    }
	}
	
	# 1. Make the window, lookup its options.
	
	toplevel $w -class TheoremsTopLevel	 
	
	if ![info exists withfeedback] { set withfeedback [option get $w withfeedback WithFeedback] }
	if ![info exists withtext] { set withtext [option get $w withtext WithText] }
	if ![info exists title] { set title [option get $w title Title] }
	if ![info exists header] { set header [option get $w header Header] }
	if ![info exists text] { set text [option get $w text Text] }

	wm minsize $w 1 1
	wm title $w $title

	#
	# 2. Make the internals.
	#
	
	set height [expr {[llength $thmspecs] + 2}]
	if {$height < 5} { set height 5 }
	if {$height > 18} { set height 18 }
	

	if {$withfeedback} {
	    fontcheck label $w.feedback \
		-height 1 \
		-width 40 \
		-anchor w \
		-relief sunken \
		-font $gui_flags(font,feedback)
	    pack $w.feedback -side bottom -expand no -fill x
	}

	pack [frame $w.controls] -pady 5 -side bottom
	pack [fontcheck focusable button $w.controls.close \
		-command "destroy $w" \
		-text "Close" \
		-width 5 \
		-font $gui_flags(font,buttons)]
	if {$header!=""} {
	    pack [label $w.header \
		    -text $header \
		    -font $gui_flags(font,labels) \
		    -anchor w] \
	        -side top -pady 5 -padx 5 -fill x
	}
	    
	if [hol90] { set vals($w,richtext) 0 }
	if [hol88] { set vals($w,richtext) 1 }
	
	eval [list TheoremsFrame $w.thmspecs \
		-height $height \
		-width 70 \
		-richtextvar vals($w,richtext)] $passon_args
	pack $w.thmspecs -expand yes  -fill both -padx 5

	if $withtext {
	    set height [llength [split $text \n]]
	    if {$height > 20} { set height 24 }
	    if {$height < 5} { set height 5 }
	    pack [fontcheck scrollable text $w.text \
		    -font $gui_flags(font,codeentry) \
		    -borderwidth 2 \
		    -relief sunken \
		    -height $height] \
	        -side top \
	        -expand yes \
	        -fill both -padx 10 -pady 10
	    $w.text.b insert 1.0 $text
	}

	tkwait visibility $w
	update
	eval [list TheoremsFrame::addtheorems $w.thmspecs] $thmspecs
	bind $w <Destroy> "unset_vals_for_widget $w"
	
	return $w
	
}





















