


proc HolHelp::ProcessArgs { argc argv } {
	global gui_flags
	global HolHelp_flags

	if {[llength [info commands Preferences_Add]]==1} {
    	    Preferences_Add "HOL Help" "Preferences related to accessing HOL help files are set here." \
	 	[list \
		    [list HolHelp_flags(lal_URL) lalURL "http://lal.cs.byu.edu/lal/hol-documentation.html" "LAL HOL Documentation Root" "This is the root of the WWW location where the Brigham Young University's LAL HOL Documentation can be found.  Some sites, such as the University of Cambridge, have their own local copy of this documentation.  Other sites from the one at BYU (http://lal.cs.byu.edu/lal/hol-documentation.html) include:\n\thttp://www.cl.cam.ac.uk/lal_holdoc/hol-documentation.html\n"] \
		    [list HolHelp_flags(hol90_URL) hol90URL "" "hol90 Documentation URL" "This is the root of the WWW location where the HOL90 documentation resides.  This is usually local to your system and available under your hol90 documentation directory.  If this value is empty then it will be set the first time you reconfigure $gui_flags(title) with hol90 installed."] \
		    [list HolHelp_flags(reuseMosaic) helpReuseMosaic OFF "Co-opt a running Mosaic" "If this is on then TkHolWorkbench will make use of a running Mosaic session instead of spawning a new Mosaic process when a help page is requested."] \
	     ]
    	}
}


proc HolHelp::menu_entries { } {

	global HolHelp_flags
	global gui_flags
	global version

#	if {$HolHelp_flags(hol90HelpLocation)=="" && [hol90]} {
#	    set HolHelp_flags(hol90HelpLocation) ...
#	}

	list \
		[list command "WWW HOL Search..." "TkHelp::www_invoke \$HolHelp_flags(lal_URL)" 0] \
		[list command "hol90 Documentation..." "TkHelp::www_invoke \$HolHelp_flags(hol90_URL)" 0] \
	    	[list sep]						\
		[list command "Mail Error Report" "error {(user error report)}" 5] \
	    	[list sep]						\
		[list command "About $gui_flags(title)..." 		\
			"tk_dialog .about \"About $gui_flags(title)\" \"$gui_flags(title) v$version\n\nby Donald Syme\" info 0 Ok" 0]

}


proc HolHelp::hol90_help { url_ext } {
	global HolHelp_flags
	TkHelp::www_invoke $HolHelp_flags(hol90_URL)/$url_ext
}


