; Written by Thomas Rene Nielsen (trn@imada.ou.dk)
; Notice that these are not public versions, so please don't spread


; global variables used by the identifier functions
(setq defun-frame nil)
(setq var-frame nil)
(setq defun-list nil)
(setq lisp-var-list nil)

; run this hook if you want automatic indention
(add-hook 'return-key-hook 'lisp-auto-indent)

; I'm not sure this works, yet.
(defun lisp-auto-indent ()
  "Automatically indents code if LISP code and in 'emacs-lisp' mode"
  (if (string-equal 'emacs-lisp-mode major-mode)
      (progn (previous-line 1)
	     (lisp-indent-line)
	     (next-line 1)
	     (lisp-indent-line)))
  )



(defun lisp-paren ()
  (interactive)
  (insert "()")
  (backward-char 1)
  (lisp-indent-line)
  )

(add-hook 'mouse-1-down-hook 'defun-list-mouse-action)
(add-hook 'mouse-1-down-hook 'var-list-mouse-action)

; use this hook, if you want every file you load, to be parsed.
;(add-hook 'find-file-hooks 'collect-all-identifiers-buffer)





; The most basic defun form
(defun lisp-make-defun ()
  "Inserts a defun body."
  (interactive)
  (newline 2)
  (insert "(defun  ()")
  (next-line 1)
  (insert ")")
  (lisp-indent-line)
  (previous-line 1)
  (beginning-of-line)
  (forward-word 1)
  (forward-char 1)
  )



(defun lisp-make-setq ()
  "inserts a setq-form."
  (interactive)
  (insert "(setq )")
  (backward-char 1)
  (lisp-indent-line)
  )



(defun lisp-make-let ()
  "inserts a let-form."
  (interactive)
  (insert "(let (())")
  (backward-char 2)
  (lisp-indent-line)
  (let ((this-pos (point)))
    (end-of-line)
    (newline 1)
    (insert ")")
    (goto-char this-pos)) 
  )



; creates the main part of an a-list
(defun lisp-make-alist ()
  "Creates an alist."
  (interactive)
  (insert " '(( . ))")
  (backward-char 5)
  )


; adds more inner parts of a-lists
(defun lisp-make-alist-part ()
  "Makes an alist part : ( . ) and positions cursor."
  (interactive)
  (insert "( . )")
  (backward-char 4)
)

 




(defun lisp-skip-forward ()
  "skips to the next logical place to write in a quote,paran or bracket pair. skips to the other side in an alist ( . )."
  (interactive)
  (let ((this-pos (point)))
    (end-of-line)
    (let ((end-pos (point)))
      (goto-char this-pos)
      ; looking for ']', '.', '"' '(' or ')'
      (if (re-search-forward "[\].\")(]" end-pos t)
	  (if (looking-at-num -1 "[\.]")
	      (forward-char 1)))))
)

(defun lisp-skip-backward ()
  "skips backward to the next logical place to write in a quote,paran or bracket pair. skips to the other side in an alist ( . )."
  (interactive)
  (let ((this-pos (point)))
    (beginning-of-line)
    (let ((start-pos (point)))
      (goto-char this-pos)
      (if (re-search-backward "[\[.\"\(\)]" start-pos t)
	  (if (looking-at "[\.]")
	      (backward-char 1)))))
  )


 
(defun lisp-clear-identifiers ()
  "Clears the lisp identifier lists."
  (interactive)
  (setq defun-list nil)
  (setq lisp-var-list nil)
  (if (frame-live-p defun-frame)
      (open-defun-list2))
  (if (frame-live-p var-frame)
      (open-var-list2))
  )

(defun lisp-collect-defun-only ()
  "Clear the defun list, and collects the function identifiers in the defun."
  (interactive)
  (lisp-clear-identifiers)
  (beginning-of-defun)
  (lisp-collect-identifiers)
  (if (frame-live-p defun-frame)
      (open-defun-list2))
  (if (frame-live-p var-frame)  
      (open-var-list2))
  )


  
  
  
  


(defun lisp-collect-identifiers ()
  "Collects all identifiers on the current logical line or in the current function"
  (interactive)
  (beginning-of-line)
  ; skips empty spaces at the start of the line
  (while (looking-at "[ \t]")
    (forward-char 1))
  ; is this a list paren ?
  (if (looking-at "\(")
      (progn (forward-char 1)
	     (lisp-get-identifiers (get-word))))
)
	
   

(defun lisp-get-identifiers (word)
  ; if the first keyword is 'defun' or 'defmacro'
   (if (or (string-equal "defun" word) (string-equal "defmacro" word))
       (progn (next-word)
	      (insert-defun-list (get-word))
	      (next-word)
	      (while (not (looking-at "\)"))
		(next-word)
		(insert-var-list (get-word)))
	      (forward-char 1)))

   ; if a 'setq' of 'set' part
   (if (or (string-equal "setq" word) (string-equal "set" word))
       (progn (next-word)
	      (while (not (looking-at "\)")) 
		(next-word)
		(skip-remark)
		
		(insert-var-list (get-word))
		(next-word)
		(skip-remark)
		
		(if (looking-at-num -1 " ")
		    (insert-var-list (get-word))
		  (if (looking-at-num -1 "\(")
		      ; call recursive to get lower part as well
		      (progn (lisp-get-identifiers (get-word))
			     (forward-char 1)))))))
   
   (if (or (string-equal "let" word) (string-equal "let*" word)) 
       (progn (next-word)
	      (while (not (looking-at "\)"))  
		(next-word)
		(skip-remark)
	       
		(insert-var-list (get-word))
		(next-word)
		(skip-remark)
		
		(if (looking-at-num -1 " ")
		    (get-word)
		  (if (looking-at-num -1 "\(")
		      (progn (lisp-get-identifiers (get-word))
			     (forward-char 2)))))
	      (forward-char 1)))
   
   
   (if (or (string-equal "defvar" word) (string-equal "defconst" word))
       (progn (next-word)
	      (insert-var-list (get-word)) 
	      (while (not (looking-at "\)")) 
		(next-word)
		(skip-remark)
		
		(if (looking-at "\"")
		    (progn (forward-char 1)
			   (re-search-forward "[\"]" nil t)
			   (while (looking-at-num -2 "[\\]")
			     (re-search-forward "[\"]" nil t)))
		  (if (looking-at-num -1 " ")
		      (insert-var-list (get-word))
		    (if (looking-at-num -1 "\(")
			(progn (lisp-get-identifiers (get-word))
			       (forward-char 1))))))))
	     


 (insert-defun-list word)
 (next-word)
 (while (not (looking-at "\)"))   
   (next-word)
   (skip-remark)
   ; is the next part quoted.
   (if (looking-at "\'")
       (if (looking-at-num 1 "\(")
	   (if (looking-at-num 2 "\(")
	       ; including parens -> alist -> should be skipped
	       (search-forward "))" nil t)
	     (search-forward ")" nil t))
	 (get-word))
     (if (looking-at "\"")
	 ; string ?
	 (progn (forward-char 1)
		(re-search-forward "[\"]" nil t)
		(while (looking-at-num -2 "[\\]")
		  (re-search-forward "[\"]" nil t)))
       (if (looking-at-num -1 "\(")
	   ; recurse to lower parts
	   (progn (next-word)
		  (lisp-get-identifiers (get-word))
		  (forward-char 1))
	 (progn 
	   (insert-var-list (get-word))
	  
	   (next-word))))))
 )


	

(defun skip-remark ()
  "Skips until end of remark."
  (interactive)
  (while (looking-at "\;")
    (end-of-line)
    (next-word))
)



; The next functions are inner parts of the identifier functions
(defun next-word ()
  "Jump past spaces and '(' to next expression."
  (while (looking-at "[ \t\n\(]")
    (forward-char 1))
)



(defun get-word ()
  "get the next word and place cursor after word."
  (let ((temp-string nil))
    (if (or (> (char-after (point)) ?9) (looking-at "[\-\/\*\+]"))
  	(while (looking-at "[^ \)\(\n]") 
	  (setq temp-string (concat temp-string (char-to-string(char-after (point)))))
	  (forward-char 1))
      (while (looking-at "[^ \)\(\n]")
	(forward-char 1))) 
      temp-string)
)
 


(defun insert-defun-list (word)
  "Inserts 'word' in defun-list if 'word' is not there."
  (if (and (not (member word defun-list)) (> (length word) 0))
      (setq defun-list (append defun-list (list word))))
)

(defun insert-var-list (word)
  "Inserts 'word' in var-list if 'word' is not there."
  (if (and (not (member word lisp-var-list)) (> (length word) 0))
      (setq lisp-var-list (append lisp-var-list (list word))))
)



(defun show-var-list ()
  "This function makes a visual var buffer list."
  (let ((temp lisp-var-list))
    (while (not (atom temp))
      (insert (car temp))
      (newline 1)
      (setq temp (cdr temp))))
  (sort-lines nil (point-min) (point-max))
)


(defun open-var-list ()
  "Opens the fast selection var identifier list. 
Call again to close."
  (interactive)
  (if (frame-live-p var-frame)
      (progn (delete-frame var-frame)
	     (kill-buffer "Variable Identifiers"))
    (progn (setq var-frame (make-frame '((name . "Click to copy")(left . 678)(width . 50)(height . 12)(top . 202)(minibuffer . nil)(menu-bar-lines . 0)(visibility . nil))))
    (open-var-list2)))
)


(defun open-var-list2 ()
  "Call open-var-list2 to refresh the var-list."
  (interactive)
  (let ((this-frame (selected-frame))) 
    (select-frame var-frame)
    (switch-to-buffer "Variable Identifiers")
    (setq buffer-read-only nil)
    (erase-buffer)
    (show-var-list)
    (setq buffer-read-only t)
    (modify-frame-parameters var-frame '((visibility . t)))
    (set-mouse-position var-frame 10 5)
    (select-frame this-frame))
)


(defun show-defun-list ()
  "This function makes a visual defun buffer list."
  (let ((temp defun-list))
    (while (not (atom temp))
      (insert (car temp))
      (newline 1)
      (setq temp (cdr temp))))
  (sort-lines nil (point-min) (point-max))
)

; this function opens the lisp function list.
;  Mouse click in the function list, to copy the  functionname to the killring.
(defun open-defun-list ()
  "Opens the fast selection defun identifier list. 
Call again to close."
  (interactive)
  ; if the frame is allready alive, then kill it and recreate
  (if (frame-live-p defun-frame)
      (progn (delete-frame defun-frame)
	     (kill-buffer "Function Identifiers"))
    (progn (setq defun-frame (make-frame '((name . "Click to copy")(left . 678)(width . 50)(height . 12)(minibuffer . nil)(menu-bar-lines . 0)(visibility . nil))))
    (open-defun-list2)))
)

;  Use this function to update the lisp function list.
(defun open-defun-list2 ()
  "Refreshes the defun-list."
  (interactive)
  (let ((this-frame (selected-frame))) 
    (select-frame defun-frame)
    (switch-to-buffer "Function Identifiers")
    (setq buffer-read-only nil)
    (erase-buffer)
    (show-defun-list)
    (setq buffer-read-only t)
    (modify-frame-parameters defun-frame '((visibility . t)))
    (set-mouse-position defun-frame 10 5)
    (select-frame this-frame))
)


;  Parses the whole buffer.
(defun lisp-collect-all-identifiers-buffer ()
  "Collects all the identifiers in the whole buffer."
  (interactive)
  (if (string-equal 'emacs-lisp-mode major-mode)
      (let ((this-pos (point)))
	(goto-char (point-min))
	(lisp-collect-identifiers)
	(end-of-line)
	(while (and (/= 1 (forward-line 1)) (< (point) (point-max)))
	  (lisp-collect-identifiers)
	  (end-of-line))
	(goto-char this-pos)
	(if (frame-live-p defun-frame)
	    (open-defun-list2))
	(if (frame-live-p var-frame)
	    (open-var-list2))))
  )



(defun defun-list-mouse-action ()
  "Tests if the mouse has clicked in the 'defun' frame and copies word
to kill-ring."
  (if (and (frame-live-p defun-frame) (eq defun-frame (selected-frame)))
      (progn (goto-char (position-of-mouse))
	     (beginning-of-line)
	     (let ((start-pos (point)))
	       (end-of-line)
	       (let ((end-pos (point)))
		 (copy-region-as-kill start-pos end-pos)))))
)

 
(defun var-list-mouse-action ()
  "Tests if the mouse has clicked in the 'var' frame and copies word to kill-ring."
  (if (and (frame-live-p var-frame) (eq var-frame (selected-frame)))
      (progn (goto-char (position-of-mouse))
	     (beginning-of-line)
	     (let ((start-pos (point)))
	       (end-of-line)
	       (let ((end-pos (point)))
		 (copy-region-as-kill start-pos end-pos)))))
)

(defun lisp-remark ()
  "Inserts a lisp remark."
  (interactive)
  (insert "; ")
  )





