; Written by Thomas Rene Nielsen

(setq latex-main-frame nil)
(setq latex-sub-frame nil)
(setq latex-group-list nil)
(setq latex-sub-group nil)


(add-hook 'mouse-1-down-hook 'latex-main-mouse-action)
(add-hook 'mouse-1-down-hook 'latex-sub-mouse-action)

(defun tex-paste ()
  "Yanks normal text, but text starting with '@\' will be run as a command."
  (let ((start-pos (point)))
    (yank)
    (let ((end-pos (point)))
      (goto-char start-pos)
      (if (looking-at "@")
	  (if (looking-at-num 1 "[\\]")
	      (let ((command-name (buffer-substring (+ start-pos 2) end-pos)))
		(delete-region start-pos end-pos)
		(funcall (intern command-name))))
	(goto-char end-pos))))
  )


(defun latex-enviroment ()
  "Asks for enviroment name and creates enviroment form."
  (interactive)
  (let ((name (read-string "Enviroment Name : ")))
    (newline 2)
    (insert "\\begin{")
    (insert name)
    (insert "}")
    (newline 2)
    (insert "\\end{")
    (insert name)
    (insert "}")
    (previous-line 1)
    (beginning-of-line))
  )

(defun latex-flushright ()
  "Inserts flushright enviroment."
  (interactive)
  (newline 2)
  (insert "\\begin{flushright}")
  (newline 2)
  (insert "\\end{flushright}")
  (previous-line 1)
  (beginning-of-line)
  )
          

(defun latex-document ()
  "Inserts document enviroment."
  (interactive)
  (newline 2)
  (insert "\\begin{document}")
  (newline 2)
  (insert "\\end{document}")
  (previous-line 1)
  (beginning-of-line)
  )



(defun open-latex-main-list ()
  "Opens latex main list. 
Call again to close."
  (interactive)
  (if (frame-live-p latex-main-frame)
      (progn (delete-frame latex-main-frame)
             (kill-buffer "Latex Main"))
    (progn (setq latex-main-frame (make-frame '((name . "Click to select")(left . 678)(width . 50)(height . 14)(top . 0)(minibuffer . nil)(menu-bar-lines . 0)(visibility . nil))))
    (open-latex-main-list2)))
)


(defun open-latex-main-list2 ()
  "This function actually does the job"
  (interactive)
  (let ((this-frame (selected-frame))) 
    (select-frame latex-main-frame)
    (switch-to-buffer "Latex Main")
    (setq buffer-read-only nil)
    (erase-buffer)
    (get-latex-main-list)
    (erase-buffer)
    (list-latex-main)
    (setq buffer-read-only t)
    (modify-frame-parameters latex-main-frame '((visibility . t)))
    (select-frame this-frame))
)

(defun latex-main-mouse-action ()
  "Tests if the mouse has clicked in the 'latex-main' frame and select subgroup."
  (if (and (frame-live-p latex-main-frame) (eq latex-main-frame (selected-frame)))
      (progn (goto-char (position-of-mouse))
             (beginning-of-line)
             (let ((word (get-latex-word)))
                   (if (not (eq word nil))                     
                       (open-latex-sub-list word)))))
  )



(defun get-latex-main-list ()
  (interactive)
  (switch-to-buffer "Latex Main")
  (erase-buffer)
  (insert-file-contents "~/speciale/latex.dat")
  (setq latex-group-list nil)
  (goto-char (point-min))
  (let ((group-name nil))
    (let ((list-part nil))
      (while (< (point) (point-max))
        (let ((end-pos (get-end-pos)))
          (beginning-of-line)
          (if (not (looking-at "[\;]"))
              (progn (if (search-forward ":" end-pos t)
                         (progn (beginning-of-line)
                                (let ((temp-string nil))
                                  (setq temp-string (get-latex-word))
                                  (forward-char 2)
                                  (setq list-part (append list-part (list(cons temp-string (get-latex-word)))))))
                       
                       (progn (if (not (eq nil group-name))
                                  (setq latex-group-list (append latex-group-list (list (cons group-name (list list-part))))))
                              (setq list-part nil)
                              (setq group-name (get-latex-word)))))))
        (forward-line 1))))
  )




(defun get-latex-word ()
  (interactive)
  (let ((word nil))
    (while (not (looking-at "[\n\:]"))
      (if (not (looking-at "[\t]"))
          (setq word (concat word (char-to-string(char-after (point))))))
      (forward-char 1)) 
    word)
  )


(defun list-latex-main ()
  (interactive)
  (let ((number 0))
    (while (nth number latex-group-list)
      (insert (car (nth number latex-group-list)))
      (newline 1)
      (setq number (+ number 1))))
  )


(defun open-latex-sub-list (group-name)
  "Opens latex sub list. "
  (let ((this-frame (selected-frame))) 
    (if (not (frame-live-p latex-sub-frame))
	(setq latex-sub-frame (make-frame '((name . "Click to copy")(left . 678)(width . 50)(height . 12)(top . 222)(minibuffer . nil)(menu-bar-lines . 0)(visibility . nil)))))
    (select-frame latex-sub-frame)
    (switch-to-buffer "Latex Selection")
    (setq buffer-read-only nil)
    (setq latex-sub-group group-name)
    (erase-buffer)
    (list-latex-sub group-name)
    (setq buffer-read-only t)
    (modify-frame-parameters latex-sub-frame '((visibility . t)))
    (select-frame this-frame)) 
)


(defun latex-sub-mouse-action ()
  "Tests if the mouse has clicked in the 'latex-sub' frame and if so, copies text to kill-ring."
  (if (and (frame-live-p latex-sub-frame) (eq latex-sub-frame (selected-frame)))
      (progn (goto-char (position-of-mouse))
             (beginning-of-line)
             (let ((word (get-latex-word)))
               (if (not (eq nil word))
                   (let ((output (cdr (assoc word (car (cdr (assoc latex-sub-group latex-group-list)))))))
                     (setq buffer-read-only nil)
                     (goto-char (point-max))
                     (newline 1)
                     (insert output)
                     (beginning-of-line)
                     (let ((start-pos (point)))
                       (end-of-line)
                       (let ((end-pos (point)))
                         (copy-region-as-kill start-pos end-pos)))))
; if you like the latex-lists to close after selection
; then uncomment the next four lines.
               ;  (delete-frame latex-sub-frame)
               ;  (delete-frame latex-main-frame)
               ;  (kill-buffer "Latex Selection")
               ;  (kill-buffer "Latex Main")
	       )))
)

(defun list-latex-sub (group-name)
  (interactive)
  (let ((group (car (cdr (assoc group-name latex-group-list)))))
    (let ((number 0))
      (while (nth number group)
      (insert (car (nth number group)))
      (newline 1)
      (setq number (+ number 1)))))
)


(defun tex-quotes ()
  "Inserts a tex quote pair."
  (interactive)
  (insert "``''")
  (backward-char 2)
  )

(defun tex-remark ()
  "Inserts a tex remark."
  (interactive)
  (insert "%")
  )

(defun tex-inline ()
  "Inserts the math 'inline' form and positions cursor."
  (interactive)
  (insert "\\(  \\)")
  (backward-char 3)
  )

(defun tex-displayed ()
 "Inserts the math 'displayed' form and positions cursor."
  (interactive)
  (insert "\\[  \\]")
  (backward-char 3)
  )  

(defun tex-emphasize-text ()
  (interactive)
  (insert "\\em \\/")
  (backward-char 2)
  )



(defun tex-number-range ()
  (interactive)
  (insert "---")
  )



(defun tex-subscript ()
  (interactive)
  (insert "_{}")
  (backward-char 1)
  )



(defun tex-superscript ()
  (interactive)
  (insert "^{}")
  (backward-char 1)
  )

(defun tex-interval-open-open ()
  (interactive)
  (insert "(, )")
  (backward-char 1)
  )


(defun tex-interval-open-closed ()
  (interactive)
  (insert "(, ]")
  (backward-char 1)
  ) 

(defun tex-interval-closed-open ()
  (interactive)
  (insert "[, )")
  (backward-char 1)
  )

(defun tex-interval-closed-closed ()
  (interactive)
  (insert "[, ]")
  (backward-char 1)
  )


(defun tex-skip-forward ()
  "skips to the next logical place to write."
  (interactive)
  (let ((end-pos (get-end-pos)))
    (if (re-search-forward "[]\[\}\\,\)\{\(]" end-pos t)
	(if (looking-at "[\(\)]")
	    (forward-char 1))))
		 
)

(defun tex-skip-backward ()
  "skips backward to the next logical place to write in a quote,paran or bracket pair. skips to the other side in an alist ( . )"
  (interactive)
  (let ((start-pos (get-start-pos)))
    (if (re-search-backward "[]\[\}\{,\)\(]" start-pos t)
	(if (looking-at-num -1 "[\\]")
	    (backward-char 1))))
  )
