; Written by Thomas Rene Nielsen (trn@imada.ou.dk)
; Notice that these are not public versions, so please don't spread


; general stuff
(global-set-key [down-mouse-1] 'mouse-1-down-action)
(global-set-key "\r" 'return-key)
(global-set-key "\n" 'return-key)
(setq main-frame (selected-frame))


; Sets up a couple of hooks
(defun mouse-1-down-action (event)
  "Executes the normal 'mouse-drag-region' command and runs the hook 'mouse-1-down-hook'"
  (interactive "e")
  (progn (mouse-drag-region event)
	 (run-hooks 'mouse-1-down-hook))
)

; last-event-frame s. 455, s. 281

(defun return-key ()
  "Executes the 'newline' as normal and calls the 'return-key-hook'"
  (interactive)
  (progn (newline-and-indent)
	 (run-hooks 'return))
  )

(defun paste ()
  "Pastes with 'yank', but wil run functions in tex too.
See 'tex-paste'"
  (interactive)
  (if (or (string-equal 'ams-latex-mode major-mode) (string-equal 'latex-mode major-mode) (string-equal 'tex-mode major-mode))
      (tex-paste)
    (yank))
  )


(defun paran-body ()
  "make paranteses body"
  (interactive)
  (if (string-equal 'emacs-lisp-mode major-mode)
      (lisp-paren)
    (progn (insert "()")
	   (backward-char 1)))
  )



(defun normal-quotes ()
  "make quote body"
  (interactive)
  (insert-char ?\" 2)
  (backward-char)
)

(defun quote-body ()
  "Inserts normal or tex quote pair, depending on major-mode."
  (interactive)
  (if (or (string-equal 'ams-latex-mode major-mode) (string-equal 'latex-mode major-mode) (string-equal 'tex-mode major-mode))
      (tex-quotes)
    (normal-quotes)) 
  )



(defun brace-body ()
  "make brace pair"
  (interactive)
  (insert "{}")
  (backward-char)
)


(defun bracket-body ()
  "make bracket body"
  (interactive)
  (insert "[]")
  (backward-char)
)



(setq main-frame (selected-frame))


(defun nice-newline ()
  "Moves to new line, below current line, without moving the rest of the current line to the new line"
  (interactive)
  (next-line 1)
  (beginning-of-line)
  (newline 1)
  (previous-line 1)
)


(defun copy-word ()
  "Copies the word at mousepoint to point. Only coping the word directly under
the mousepoint, in words connected with '-' og '_'."
  (interactive)
  (let ((this-pos (point)))
    (let ((this-window (selected-window)))
      (select-window (window-at (car(cdr(mouse-position))) (cdr(cdr(mouse-position)))))
      (goto-char (position-of-mouse))
      (backward-word 1)
      (let ((start-pos (point)))
	(forward-word 1)
	(if (string-equal 'emacs-lisp-mode major-mode)
	    (while (looking-at "-")
	      (forward-word 1)))
	(if (string-equal 'c-mode major-mode)
	    (while (looking-at "_")
	      (forward-word 1)))
	(let ((end-pos (point)))
	  (copy-region-as-kill start-pos end-pos)))
      (select-window this-window))
    (goto-char this-pos))
  (yank)
  )  


(defun position-of-mouse ()
  "Returns the buffer position of the mousepointer in selected window"
  (car (compute-motion (window-start)
		       (cons (car(window-edges)) (car(cdr(window-edges))))
		       (point-max)
		       (cons (car(cdr(mouse-position))) (cdr(cdr(mouse-position))))
		       (window-width)
		       (cons (window-hscroll) 0)
		       (selected-window)))
  )



(defun position-of-cursor ()
  "Returns the screen coordinates of the cursor."
  (let ((temp (compute-motion (window-start)
		       (cons (car(window-edges)) (car(cdr(window-edges))))
		       (point)
		       '(1000 . 1000)
		       (window-width)
		       (cons (window-hscroll) 0)
		       (selected-window))))
    (cons (car (cdr temp)) (car (cdr (cdr temp)))))
  
  )





(defun cursor-list-select ()
  "Selects the list entry at cursor. For use with the File-list, Identifier-list
and Latex-list."
  (interactive)
  (set-mouse-position (selected-frame) (car (position-of-cursor)) (cdr (position-of-cursor)))
  (defun-list-mouse-action)
  (var-list-mouse-action)
  (c-function-list-mouse-action)
  (c-var-list-mouse-action)
  (file-list-mouse-action)
  (latex-main-mouse-action)
  (latex-sub-mouse-action)
  (word-pad-mouse-action)
  )




(defun several-lines-up ()
  "Asks for number of lines to go up, and executes if possible."
  (interactive)
  (previous-line (string-to-number (read-string "Lines to go : ")))
  )

(defun several-lines-down ()
  "Asks for number of lines to go down, and executes if possible."
  (interactive)
  (next-line (string-to-number (read-string "Lines to go : ")))
  )





(defun let-selection ()
  (interactive)
  (if (string-equal 'emacs-lisp-mode major-mode)
      (lisp-make-let)
    (insert "let ")) 
  )


(defun skip-forward ()
  "Skips forward to the next logical place to write, depending on current mode."
  (interactive)
  (if (string-equal 'emacs-lisp-mode major-mode)
      (lisp-skip-forward)
    (if (string-equal 'c-mode major-mode)
	(c-skip-forward)
      (if (or (string-equal 'ams-latex-mode major-mode) (string-equal 'latex-mode major-mode) (string-equal 'tex-mode major-mode))
	  (tex-skip-forward))))
  )

(defun skip-backward ()
  "Skips backward to the previous logical place to write, depending on current mode."
  (interactive)
  (if (string-equal 'emacs-lisp-mode major-mode)
      (lisp-skip-backward)
    (if (string-equal 'c-mode major-mode)
	(c-skip-backward)
      (if (or (string-equal 'ams-latex-mode major-mode) (string-equal 'latex-mode major-mode) (string-equal 'tex-mode major-mode))
	  (tex-skip-backward))))
  )


(defun collect-function ()
  "collects the identifiers i the function , depending on current mode."
  (interactive)
  (if (string-equal 'emacs-lisp-mode major-mode)
      (lisp-collect-defun-only)
    (if (string-equal 'c-mode major-mode)
	(collect-c-identifiers)))
  )

(defun collect-identifiers ()
  "collects the identifiers, depending on current mode."
  (interactive)
  (if (string-equal 'emacs-lisp-mode major-mode)
      (lisp-collect-identifiers)
    (if (string-equal 'c-mode major-mode)
	(collect-c-identifiers)))
  )

(defun clear-identifiers ()
  "Clears the identifiers, depending on current mode."
  (interactive)
  (if (string-equal 'emacs-lisp-mode major-mode)
      (lisp-clear-identifiers)
    (if (string-equal 'c-mode major-mode)
	(clear-c-identifiers)))
  )


(defun open-identifier-list ()
  "Opens the identifier lists, depending on current mode."
  (interactive)
  (if (string-equal 'emacs-lisp-mode major-mode)
      (progn (open-var-list)
	     (open-defun-list))
    (if (string-equal 'c-mode major-mode)
	(progn (open-c-var-list)
	       (open-c-function-list))))
  )

(defun open-var-identifier-list ()
  "Opens the variable list, depending on current mode."
  (interactive)
  (if (string-equal 'emacs-lisp-mode major-mode)
      (open-var-list)
    (if (string-equal 'c-mode major-mode)
	(open-c-var-list)))
  )


 (defun open-function-identifier-list ()
  "Opens the function list, depending on current mode."
  (interactive)
  (if (string-equal 'emacs-lisp-mode major-mode)
      (open-defun-list)
    (if (string-equal 'c-mode major-mode)
	(open-c-function-list)))
  )



(defun collect-all-identifiers-buffer ()
  "collects all identifiers in the buffer,depending on current mode."
   (interactive)
  (if (string-equal 'emacs-lisp-mode major-mode)
      (lisp-collect-all-identifiers-buffer)
    (if (string-equal 'c-mode major-mode)
	(collect-all-c-identifiers-buffer)))
  )


(defun get-start-pos ()
  (let ((this-pos (point)))
    (beginning-of-line)
    (let ((start-pos (point)))
      (goto-char this-pos)
      start-pos))
  )


(defun get-end-pos ()
  (let ((this-pos (point)))
    (end-of-line)
    (let ((end-pos (point)))
      (goto-char this-pos)
      end-pos))
  )



(defun goto-next-frame ()
  "Jumps to the next frame."
  (interactive)
  (set-mouse-position (next-frame) 10 5)
  )

(defun goto-previous-frame ()
  "Jumps to the previous frame."
  (interactive)
  (set-mouse-position (previous-frame) 10 5)
  )




(defun delete-word ()
  "Deletes the word under the cursor."
  (interactive)
  (forward-word 1)
  (backward-kill-word 1)
  )


(defun looking-at-num (num exp)
  "Like 'looking-at', but using num as offset from point."
  (forward-char num)
  (let ((bool (looking-at exp)))
    (backward-char num)
    bool)
  )

(defun insert-remark ()
  "Inserts C, Lisp or tex remark, depending on major-mode."
  (interactive)
  (if (or (string-equal 'ams-latex-mode major-mode) (string-equal 'latex-mode major-mode) (string-equal 'tex-mode major-mode))
      (tex-remark))
  (if (string-equal 'c-mode major-mode)
      (c-remark))
  (if (string-equal 'emacs-lisp-mode major-mode)
      (lisp-remark))
  )



; The following is part of the no-space-mode
(setq no-space-mode nil)


(or (assq 'no-space-mode minor-mode-alist)
    (setq minor-mode-alist
	  (cons '(no-space-mode " No Space") minor-mode-alist)))


(defun no-space-mode (arg)
  "This mode vil switch the space bar off, when the mode is active.
 The mode loses the spaces Dragondictate makes between words.
Most useful when programming. Bind a speak command to the command
'space-bar', to make spaces manually. "
  (interactive "P")
  (setq no-space-mode
	(if (null arg) (not no-space-mode)
	  (> (prefix-numeric-value arg) 0)))
  )


(global-set-key " " 'make-space-bar)


(defun make-space-bar ()
  (interactive)
  (if (not no-space-mode)
      (space-bar))
  )

(defun space-bar ()
  (interactive)
  (insert " ")
  )



; binaery 'search' of lists




(defun top-of-buffer ()
  "Moves to the start of the current buffer."
  (interactive)
  (goto-char (point-min))
  )


(defun middle-of-buffer ()
  "Moves to the middle of the buffer, regarding lines."
  (interactive)
  (goto-line (/ (count-lines (point-min) (point-max)) 2))
  )




