#Import interface
import i2cInterface as Interface
import time

#Turing Machine Variables
tape = []
tapeshown = []
reallength = Interface.config.LEDno			#physical tape length
inittape = []			#initial tape configuration
for x in range(reallength):	
	inittape.append(0)
headposition = reallength/2	#customisable position of head (0 to reallength - 1)
head = headposition		#position head at specified position
state = 0			#state of Turing Machine
symbols = ['Blank (B)', '0', '1']	#types of symbols
symbolno = len(symbols)		#number of symbols

#Turing Machine Operations
def printtape():		#displays 13 squares of tape on LEDs
	global tape
	global head
	global printtime
	global tapeshown

	taperange = range(head - headposition, head + reallength - headposition)	#chosen cells to be displayed depending on head position	
	tapeshown = []
	
	for x in range(len(tape)):
		tapeshown.append(symbols[tape[x]])

	for i in range(reallength):
		
		#if chosen cells are not out of tape's range, display LEDs accordingly
		if (taperange[i] < len(tape) and taperange[i] >= 0):
			Interface.setLED(i,tape[taperange[i]]) 			

		#otherwise turn off LED[i]
		else:
			Interface.setLED(i,0) 

def tapeclear():
	global tape
	global head
	global state

	head = headposition
	tape = []			#initial tape configuration
	for x in range(reallength):	
		tape.append(0)
	state = 0

def initialise():
	global tape
	global inittape
	global head

	head = headposition
	tape = []
	for x in range(reallength):
		tape.append(inittape[x])
	printtape()

def movetaperight(steps = 1):		#steps define number of steps to move tape
	global tape
	global head

	#if head moves out of tape, extend tape
	if (head - steps < 0):	
		tape[:0] = [0]*(steps - head)
		head = 0
	else:
		head = head - steps
	printtape()

def movetapeleft(steps = 1):
	global tape
	global head

	#if head moves out of tape, extend tape
	if (head + steps > len(tape)-1):	
		tape[len(tape):] = [0]*(head + steps - len(tape) + 1)
		head = len(tape)-1
	else:
		head = head + steps
		#print 'y', steps
	printtape()

def write(operation = 0):
	global tape
	global head

	tape[head] = operation
	printtape()

def move(operation = 0, steps = 1):
	if operation == 0:
		pass
	elif operation == 1:
		movetapeleft(steps)
	elif operation == 2:
		movetaperight(steps)

tapeclear()
