import Config as config
import smbus
bus = smbus.SMBus(0)

#VARIABLES
LEDbus = 0	#position of bus number in config.LED
LEDpin = 1	#position of pin number in config.LED

LEDred = 0	#numbers tagged to colours of LED
LEDgreen = 1

LEDon = 0	#convention for turning on/off LED
LEDoff = 1

BusPins = []	#Array of values for bus pins
for x in range(len(config.Bus)):
	BusPins.append([])
	for y in range(8):
		BusPins[x].append(LEDoff)

BusOutput = []	#Output data for bus

#FUNCTIONS
def BusOutputReset():	#Resets bus output data to 0
	global BusOutput
	BusOutput = []
	for x in range(len(config.Bus)):
		BusOutput.append(0)

def BusOutputCalc():	#Calculates bus output data
	global BusOutput
	BusOutputReset()
	for x in range(len(config.Bus)):
		for y in range(len(BusPins[0])):
			BusOutput[x] = BusOutput[x] + (BusPins[x][y])*2**y

def printBus():		#Transfers output data to bus
	for x in range(len(config.Bus)):
		bus.write_byte(config.Bus[x], BusOutput[x])

def setLED(LEDnumber, value):
	if value == 0:
		BusPins[config.LED[LEDnumber][LEDred][LEDbus]][config.LED[LEDnumber][LEDred][LEDpin]] = LEDoff
		BusPins[config.LED[LEDnumber][LEDgreen][LEDbus]][config.LED[LEDnumber][LEDgreen][LEDpin]] = LEDoff

	elif value == 1:
		BusPins[config.LED[LEDnumber][LEDred][LEDbus]][config.LED[LEDnumber][LEDred][LEDpin]] = LEDon
		BusPins[config.LED[LEDnumber][LEDgreen][LEDbus]][config.LED[LEDnumber][LEDgreen][LEDpin]] = LEDoff

	elif value == 2:
		BusPins[config.LED[LEDnumber][LEDred][LEDbus]][config.LED[LEDnumber][LEDred][LEDpin]] = LEDoff
		BusPins[config.LED[LEDnumber][LEDgreen][LEDbus]][config.LED[LEDnumber][LEDgreen][LEDpin]] = LEDon
	BusOutputCalc()
	printBus()

BusOutputCalc()
printBus()