/*
 * Decompiled with CFR 0.152.
 */
package edsac.datatypes;

import edsac.datatypes.LongWord;
import edsac.datatypes.ShortWord;

public class Character {
    static final byte INVALID = -1;
    final String[] PERF_LETTERS = new String[]{"P", "Q", "W", "E", "R", "T", "Y", "U", "I", "O", "J", "pi", "S", "Z", "K", "erase", "blank", "F", "theta", "D", "phi", "H", "N", "M", "delta", "L", "X", "G", "A", "B", "C", "V"};
    final String[] PRINT_LETTERS = new String[]{"P", "Q", "W", "E", "R", "T", "Y", "U", "I", "O", "J", "", "S", "Z", "K", "", "", "F", "", "D", " ", "H", "N", "M", "\n", "L", "X", "G", "A", "B", "C", "V"};
    final String[] PRINT_NUMBERS = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "", "", "\"", "+", "(", "", "", "$", "", ";", " ", "\u00a3", ",", ".", "\n", ")", "/", "#", "-", "?", ":", "="};
    byte value;

    public Character() {
        this.value = 0;
    }

    public Character(byte by) {
        this.value = (byte)(by & 0x1F);
    }

    public Character(LongWord longWord) {
        this.value = (byte)(longWord.longValue() >> 30);
    }

    public Character(ShortWord shortWord) {
        this.value = (byte)(shortWord.intValue() >> 12);
    }

    public Character(char c) {
        switch (c) {
            case '0': 
            case 'P': 
            case 'p': {
                this.value = 0;
                return;
            }
            case '1': 
            case 'Q': 
            case 'q': {
                this.value = 1;
                return;
            }
            case '2': 
            case 'W': 
            case 'w': {
                this.value = (byte)2;
                return;
            }
            case '3': 
            case 'E': 
            case 'e': {
                this.value = (byte)3;
                return;
            }
            case '4': 
            case 'R': 
            case 'r': {
                this.value = (byte)4;
                return;
            }
            case '5': 
            case 'T': 
            case 't': {
                this.value = (byte)5;
                return;
            }
            case '6': 
            case 'Y': 
            case 'y': {
                this.value = (byte)6;
                return;
            }
            case '7': 
            case 'U': 
            case 'u': {
                this.value = (byte)7;
                return;
            }
            case '8': 
            case 'I': 
            case 'i': {
                this.value = (byte)8;
                return;
            }
            case '9': 
            case 'O': 
            case 'o': {
                this.value = (byte)9;
                return;
            }
            case 'J': 
            case 'j': {
                this.value = (byte)10;
                return;
            }
            case '#': {
                this.value = (byte)11;
                return;
            }
            case 'S': 
            case 's': {
                this.value = (byte)12;
                return;
            }
            case 'Z': 
            case 'z': {
                this.value = (byte)13;
                return;
            }
            case 'K': 
            case 'k': {
                this.value = (byte)14;
                return;
            }
            case '*': {
                this.value = (byte)15;
                return;
            }
            case '.': {
                this.value = (byte)16;
                return;
            }
            case 'F': 
            case 'f': {
                this.value = (byte)17;
                return;
            }
            case '@': {
                this.value = (byte)18;
                return;
            }
            case 'D': 
            case 'd': {
                this.value = (byte)19;
                return;
            }
            case '!': {
                this.value = (byte)20;
                return;
            }
            case '+': 
            case 'H': 
            case 'h': {
                this.value = (byte)21;
                return;
            }
            case '-': 
            case 'N': 
            case 'n': {
                this.value = (byte)22;
                return;
            }
            case 'M': 
            case 'm': {
                this.value = (byte)23;
                return;
            }
            case '&': {
                this.value = (byte)24;
                return;
            }
            case 'L': 
            case 'l': {
                this.value = (byte)25;
                return;
            }
            case 'X': 
            case 'x': {
                this.value = (byte)26;
                return;
            }
            case 'G': 
            case 'g': {
                this.value = (byte)27;
                return;
            }
            case 'A': 
            case 'a': {
                this.value = (byte)28;
                return;
            }
            case 'B': 
            case 'b': {
                this.value = (byte)29;
                return;
            }
            case 'C': 
            case 'c': {
                this.value = (byte)30;
                return;
            }
            case 'V': 
            case 'v': {
                this.value = (byte)31;
                return;
            }
        }
        this.value = (byte)-1;
    }

    public byte byteValue() {
        return this.value;
    }

    public char charValue() {
        return (char)this.value;
    }

    public String toString(boolean bl) {
        if (bl) {
            return this.PRINT_LETTERS[this.value & 0x1F];
        }
        return this.PRINT_NUMBERS[this.value & 0x1F];
    }

    public boolean newShift(boolean bl) {
        if (this.value == 11) {
            return true;
        }
        if (this.value == 15) {
            return false;
        }
        return bl;
    }

    public boolean isInvalid() {
        return this.value == -1;
    }

    public String toString() {
        return this.PERF_LETTERS[this.value & 0x1F];
    }
}

