﻿// $Id: SubPixelMaximizer.cs 65 2010-03-18 17:06:22Z cr333 $
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Stereo.GpGpuLib;
using VideoLib.Parameters;

namespace VideoLib.Stereo.GpGpu.StereoNodes
{
	/// <summary>
	/// Finds the lowest cost disparity level in a float-sized cost space and
	/// applies sub-pixel disparity estiamtion using a local quadratic fit.
	/// </summary>
	class SubPixelMaximizer : MaximizerStereoNode
	{
		#region Parameters

		[Parameter(Minimum = 0, Maximum = 2, Default = 1)]
		public float Threshold { get; set; }

		#endregion

		public SubPixelMaximizer() : base() { }
		public SubPixelMaximizer(ExecutionStream stream) : base(stream) { }

		public override void FindSolution(CostSpace costGrid, DepthMap depthMap)
		{
			ManagedMaximizers.RunSubpixelMaxKernel(costGrid, 1.0f / (float)costGrid.GetDepth(), Threshold, depthMap, stream);
		}
	}

	class SubPixelMaximizerFactory : StereoNodeFactory<MaximizerStereoNode>
	{
		public override MaximizerStereoNode Create(ExecutionStream stream)
		{
			return new SubPixelMaximizer(stream);
		}

		public override void CheckValid(InputImageType imageType, CostSpaceType gridType, DepthMapType mapType)
		{
			isValid = (gridType == CostSpaceType.Single);
		}

		public override string Name
		{
			get { return "Sub-pixel winner-take-all"; }
		}
	}
}
