﻿// $Id: NullDownsampler.cs 65 2010-03-18 17:06:22Z cr333 $
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Stereo.GpGpuLib;
using VideoLib.Parameters;

namespace VideoLib.Stereo.GpGpu.StereoNodes
{
	/// <summary>
	/// Does not do any downsampling.
	/// </summary>
	class NullDownsampler : DownsamplerStereoNode
	{
		/// <summary>Gets or sets the factor to downsample the images by</summary>
		[Parameter(Minimum = 1, Maximum = 1, Default = 1, FriendlyName = "Scale factor")]
		public override int DownsamplingFactor { get; set; }

		/// <summary>
		/// Initializes a new instance of the <see cref="NullDownsampler"/> class.
		/// </summary>
		/// <param name="theStream">The execution stream to run this node on.</param>
		public NullDownsampler(ExecutionStream stream) : base(stream) { }

		/// <summary>
		/// Does nothing (except re-reference the sampled images to match the input images)
		/// </summary>
		/// <param name="leftImage">The left image.</param>
		/// <param name="rightImage">The right image.</param>
		/// <param name="dsFactor">Is set to the down-sampling factor actually used</param>
		/// <param name="sampledLeftImage">The downsampled left image output</param>
		/// <param name="sampledRightImage">The downsampled right image output</param>
		public override void DownsampleImages(InputImage leftImage, InputImage rightImage, out int dsFactor,
			out InputImage sampledLeftImage, out InputImage sampledRightImage)
		{
			dsFactor = 1;
			sampledLeftImage = leftImage;
			sampledRightImage = rightImage;
		}
	}

	/// <summary>
	/// Factory that produces a <see cref="NullDownsampler"/>.
	/// </summary>
	class NullDownsamplerFactory : StereoNodeFactory<DownsamplerStereoNode>
	{
		/// <summary>
		/// Creates a <see cref="NullDownsampler"/> to run on the specified execution stream.
		/// </summary>
		/// <param name="stream">The execution stream.</param>
		/// <returns>
		/// An instance of <see cref="DownsamplerStereoNode"/>.
		/// </returns>
		public override DownsamplerStereoNode Create(ExecutionStream stream)
		{
			return new NullDownsampler(stream);
		}

		/// <summary>
		/// Checks if the <see cref="NullDownsampler"/> is compatible with the given datatypes.
		/// </summary>
		/// <param name="imageType">Image datatype.</param>
		/// <param name="gridType">Cost space datatype.</param>
		/// <param name="mapType">Depth map datatype.</param>
		public override void CheckValid(InputImageType imageType, CostSpaceType gridType, DepthMapType mapType)
		{
			isValid = true; // always valid
		}

		/// <summary>
		/// Gets the name of this node.
		/// </summary>
		public override string Name { get { return "No downsampling"; } }

		/// <summary>
		/// Gets the sort key. Should put this node first.
		/// </summary>
		public override string SortKey { get { return "_1_" + Name; } }
	}
}
