﻿// $Id: SadCostComputer.cs 65 2010-03-18 17:06:22Z cr333 $
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Stereo.GpGpuLib;
using VideoLib.Parameters;

namespace VideoLib.Stereo.GpGpu.StereoNodes
{
	/// <summary>
	/// Computes matching costs using squared differences (SD).
	/// </summary>
	class SadCostComputer : CostComputerStereoNode
	{
		#region Parameters

		[Parameter(Minimum = 0.5, Maximum = 20, Default = 5)]
		public float CostGradient { get; set; }

		[Parameter(Minimum = 0.5, Maximum = 20, Default = 5)]
		public float CostLimit { get; set; }

		#endregion

		public SadCostComputer() : base() { }
		public SadCostComputer(ExecutionStream theStream) : base(theStream) { }

		public override CostSpaceType GetCostSpaceType()
		{
			return CostSpaceType.Single;
		}

		protected override void ComputeCostsInner(InputImage leftIm, InputImage rightIm, CostSpace costGrid, int nDisparities)
		{
			ManagedCostComputers.RunSadKernel(leftIm, rightIm, nDisparities, CostGradient, CostLimit, costGrid, stream);
		}
	}

	class SadCostComputerFactory : StereoNodeFactory<CostComputerStereoNode>
	{
		public override CostComputerStereoNode Create(ExecutionStream stream)
		{
			return new SadCostComputer(stream);
		}

		public override void CheckValid(InputImageType imageType, CostSpaceType gridType, DepthMapType mapType)
		{
			isValid = true; // costs are always valid, so that one can always switch them
		}

		public override string Name { get { return "Absolute differences"; } }
		public override string SortKey { get { return "_1_" + Name; } } // put this first
	}
}
