﻿// $Id: MadCostComputer.cs 65 2010-03-18 17:06:22Z cr333 $
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Stereo.GpGpuLib;
using VideoLib.Parameters;

namespace VideoLib.Stereo.GpGpu.StereoNodes
{
	class MadCostComputer : CostComputerStereoNode
	{
		#region Parameters

		[Parameter(Minimum = 0.5, Maximum = 20, Default = 5)]
		public float CostGradient { get; set; }

		[Parameter(Minimum = 0.5, Maximum = 20, Default = 5)]
		public float CostLimit { get; set; }

		#endregion

		public MadCostComputer() : base() { }
		public MadCostComputer(ExecutionStream stream) : base(stream) { }

		public override CostSpaceType GetCostSpaceType()
		{
			return CostSpaceType.Single;
		}

		protected override void ComputeCostsInner(InputImage leftIm, InputImage rightIm, CostSpace costGrid, int nDisparities)
		{
			ManagedCostComputers.RunMadKernel(leftIm, rightIm, nDisparities, CostGradient, CostLimit, costGrid, stream);
		}
	}

	// commented out to hide from UI
	//class MadCostComputerFactory : StereoNodeFactory<CostComputerStereoNode>
	//{
	//    public override CostComputerStereoNode Create(ExecutionStream stream)
	//    {
	//        return new MadCostComputer(stream);
	//    }
	//
	//    public override void CheckValid(InputImageType imageType, CostSpaceType gridType, DepthMapType mapType)
	//    {
	//        isValid = true; // costs are always valid, so that one can always switch them
	//    }
	//
	//    public override string Name { get { return "MAD cost"; } }
	//}
}
