﻿// $Id: CrSdCostComputer.cs 65 2010-03-18 17:06:22Z cr333 $
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Stereo.GpGpuLib;
using VideoLib.Parameters;

namespace VideoLib.Stereo.GpGpu.StereoNodes
{
	/// <summary>
	/// Computes matching costs using squared differences (SD).
	/// </summary>
	class CrSdCostComputer : CostComputerStereoNode
	{
		#region Parameters

		[Parameter(Minimum = 0.1, Maximum = 10, Default = 1)]
		public float CostGradient { get; set; }

		[Parameter(Minimum = 0.5f, Maximum = 100, Default = 25)]
		public float CostLimit { get; set; }

		#endregion

		public CrSdCostComputer() : base() { }
		public CrSdCostComputer(ExecutionStream stream) : base(stream) { }

		public override CostSpaceType GetCostSpaceType()
		{
			return CostSpaceType.Single;
		}

		protected override void ComputeCostsInner(InputImage leftIm, InputImage rightIm, CostSpace costGrid, int nDisparities)
		{
			ManagedCostComputers.RunCrSdKernel(leftIm, rightIm, nDisparities, CostGradient, CostLimit, costGrid, stream);
		}
	}

	class CrSdCostComputerFactory : StereoNodeFactory<CostComputerStereoNode>
	{
		public override CostComputerStereoNode Create(ExecutionStream stream)
		{
			return new CrSdCostComputer(stream);
		}

		public override void CheckValid(InputImageType imageType, CostSpaceType gridType, DepthMapType mapType)
		{
			isValid = true; // costs are always valid, so that one can always switch them
		}

		public override string Name { get { return "Squared differences"; } }
		public override string SortKey { get { return "_3_" + Name; } } // put this third
	}
}
