﻿// $Id: YoonKweonAggregator.cs 65 2010-03-18 17:06:22Z cr333 $
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Stereo.GpGpuLib;
using VideoLib.Parameters;

namespace VideoLib.Stereo.GpGpu.StereoNodes
{
	/// <summary>
	/// Aggregates costs using naive Yoon & Kweon 2006 adaptive support-weights.
	/// </summary>
	class YoonKweonAggregator : AggregatorStereoNode
	{
		#region Parameters

		[Parameter(Minimum = 0, Maximum = 20, Default = 17, FriendlyName = "Window radius")]
		public int Radius { get; set; }

		[Parameter(Minimum = 0, Maximum = 40, Default = 17.5, FriendlyName = "Proximity weight")]
		public float GammaP { get; set; }

		[Parameter(Minimum = 0, Maximum = 20, Default = 5, FriendlyName = "Similarity weight")]
		public float GammaC { get; set; }

		#endregion

		public YoonKweonAggregator() : base() { }
		public YoonKweonAggregator(ExecutionStream stream) : base(stream) { }

		/// <summary>
		/// Aggregates (locally optimizes) the costs.
		/// </summary>
		/// <param name="leftImage">The left input image.</param>
		/// <param name="rightImage">The right input image.</param>
		/// <param name="costGrid">The cost grid.</param>
		public override void AggregateCosts(InputImage leftImage, InputImage rightImage, CostSpace costGrid)
		{
			ManagedAggregators.RunYoonKweonKernel(costGrid, leftImage, rightImage, Radius, GammaP, GammaC, stream);
		}
	}

	class YoonKweonAggregatorFactory : StereoNodeFactory<AggregatorStereoNode>
	{
		public override AggregatorStereoNode Create(ExecutionStream stream)
		{
			return new YoonKweonAggregator(stream);
		}

		public override void CheckValid(InputImageType imageType, CostSpaceType gridType, DepthMapType mapType)
		{
			isValid = (gridType == CostSpaceType.Single); 
		}

		public override string Name
		{
			get { return "Yoon && Kweon aggregation"; }
		}

		public override string SortKey { get { return "_4_" + Name; } } // put this fourth
	}
}
