﻿// $Id: ShiftAggregator.cs 65 2010-03-18 17:06:22Z cr333 $
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Stereo.GpGpuLib;
using VideoLib.Parameters;

namespace VideoLib.Stereo.GpGpu.StereoNodes
{
	/// <summary>
	/// Aggregates costs using shiftable windows.
	/// </summary>
	class ShiftAggregator : AggregatorStereoNode, IDisposable
	{
		#region Parameters

		[Parameter(Minimum = 1, Maximum = 16, Default = 2, FriendlyName = "Box radius")]
		public int BoxFilterHsize { get; set; }

		[Parameter(Minimum = 1, Maximum = 16, Default = 2, FriendlyName = "Shift radius")]
		public int MinFilterHsize { get; set; }

		#endregion

		private CostSpace tempCosts = new CostSpace();

		public ShiftAggregator() : base() { }
		public ShiftAggregator(ExecutionStream stream) : base(stream) { }

		/// <summary>
		/// Aggregates (locally optimizes) the costs.
		/// </summary>
		/// <param name="leftImage">The left input image.</param>
		/// <param name="rightImage">The right input image.</param>
		/// <param name="costGrid">The cost grid.</param>
		public override void AggregateCosts(InputImage leftImage, InputImage rightImage, CostSpace costGrid)
		{
			ManagedAggregators.RunShiftKernel(costGrid, BoxFilterHsize, MinFilterHsize, tempCosts, stream);
		}

		public void Dispose()
		{
			tempCosts.Dispose();
			tempCosts = null;
		}
	}

	class ShiftAggregatorFactory : StereoNodeFactory<AggregatorStereoNode>
	{
		public override AggregatorStereoNode Create(ExecutionStream stream)
		{
			return new ShiftAggregator(stream);
		}

		public override void CheckValid(InputImageType imageType, CostSpaceType gridType, DepthMapType mapType)
		{
			isValid = (gridType == CostSpaceType.Single);
		}

		public override string Name
		{
			get { return "Shiftable windows"; }
		}

		public override string SortKey { get { return "_3_" + Name; } } // put this third
	}
}
