﻿// $Id: DcbGridAggregator.cs 65 2010-03-18 17:06:22Z cr333 $
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using VideoLib.Parameters;
using Stereo.GpGpuLib;

namespace VideoLib.Stereo.GpGpu.StereoNodes
{
	/// <summary>
	/// Aggregates cost using the dual-cross-bilateral grid.
	/// </summary>
	class DcbGridAggregator : AggregatorStereoNode, IDisposable
	{
		#region Parameters

		[Parameter(Minimum = 5, Maximum = 20, Default = 10, FriendlyName = "Lightness sigma")]
		public int SigmaC { get; set; }

		[Parameter(Minimum = 5, Maximum = 20, Default = 10, FriendlyName = "Spatial sigma")]
		public int SigmaS { get; set; }

		#endregion

		private InputImage gridTexture = new InputImage();

		public DcbGridAggregator() : base() { }
		public DcbGridAggregator(ExecutionStream stream) : base(stream) { }

		/// <summary>
		/// Aggregates (locally optimizes) the costs.
		/// </summary>
		/// <param name="leftImage">The left input image.</param>
		/// <param name="rightImage">The right input image.</param>
		/// <param name="costGrid">The cost grid.</param>
		public override void AggregateCosts(InputImage leftImage, InputImage rightImage, CostSpace costGrid)
		{
			ManagedAggregators.RunDcbGridKernel(costGrid, leftImage, rightImage, gridTexture, SigmaS, SigmaC, stream);
		}

		public void Dispose()
		{
			gridTexture.Dispose();
			gridTexture = null;
		}
	}

	class DcbGridAggregatorFactory : StereoNodeFactory<AggregatorStereoNode>
	{
		public override AggregatorStereoNode Create(ExecutionStream stream)
		{
			return new DcbGridAggregator(stream);
		}

		public override void CheckValid(InputImageType imageType, CostSpaceType gridType, DepthMapType mapType)
		{
			isValid = (gridType == CostSpaceType.Single);
		}

		public override string Name
		{
			get { return "DCB grid aggregation"; }
		}

		public override string SortKey { get { return "_5_" + Name; } } // put this fifth
	}
}
