﻿// $Id: DcbGrid2Aggregator.cs 65 2010-03-18 17:06:22Z cr333 $
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using VideoLib.Parameters;
using Stereo.GpGpuLib;

namespace VideoLib.Stereo.GpGpu.StereoNodes
{
	/// <summary>
	/// Aggregates cost using the dual-cross-bilateral grid.
	/// </summary>
	class DcbGrid2Aggregator : AggregatorStereoNode, IDisposable
	{
		#region Parameters

		[Parameter(Minimum = 5, Maximum = 20, Default = 10, FriendlyName = "Lightness sigma")]
		public int SigmaC1 { get; set; }

		[Parameter(Minimum = 5, Maximum = 20, Default = 10, FriendlyName = "Hue sigma")]
		public int SigmaC2 { get; set; }

		[Parameter(Minimum = 5, Maximum = 20, Default = 10, FriendlyName = "Spatial sigma")]
		public int SigmaS { get; set; }

		#endregion

		private TiledGrids grids = new TiledGrids();

		public DcbGrid2Aggregator() : base() { }
		public DcbGrid2Aggregator(ExecutionStream stream) : base(stream) { }

		/// <summary>
		/// Aggregates (locally optimizes) the costs.
		/// </summary>
		/// <param name="leftImage">The left input image.</param>
		/// <param name="rightImage">The right input image.</param>
		/// <param name="costGrid">The cost grid.</param>
		public override void AggregateCosts(InputImage leftImage, InputImage rightImage, CostSpace costGrid)
		{
			ManagedAggregators.RunDcbGrid2Kernel(costGrid, leftImage, rightImage, grids, SigmaS, SigmaC1, SigmaC2, stream);
		}

		public void Dispose()
		{
			grids.Dispose();
			grids = null;
		}
	}

	class DcbGrid2AggregatorFactory : StereoNodeFactory<AggregatorStereoNode>
	{
		public override AggregatorStereoNode Create(ExecutionStream stream)
		{
			return new DcbGrid2Aggregator(stream);
		}

		public override void CheckValid(InputImageType imageType, CostSpaceType gridType, DepthMapType mapType)
		{
			isValid = (gridType == CostSpaceType.Single);
		}

		public override string Name
		{
			get { return "Dichromatic DCB grid"; }
		}

		public override string SortKey { get { return "_5_" + Name; } } // put this fifth
	}
}
