﻿// $Id: LeftRightStereoProgram.cs 65 2010-03-18 17:06:22Z cr333 $
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.IO;
using System.Drawing;
using StereoLibTester;

namespace LeftRightStereo
{
	public class LeftRightStereoProgram
	{
		public static void Main(string[] args)
		{
			if (args.Length < 3)
			{
				Console.WriteLine("Usage: LeftRightStereo left_im_path right_im_path n_disparities " +
					"[left_disp_output_path] [right_disp_output_path] [technique_name]");
				return;
			}

			// inputs
			string leftFilename = args[0]; // "../../../data/teddy/left.png";
			string rightFilename = args[1]; // "../../../data/teddy/right.png";
			int numDisparities = Int32.Parse(args[2]);
			string leftDispFilename  = (args.Length > 3 ? args[3] : "disp-left.png");
			string rightDispFilename = (args.Length > 4 ? args[4] : "disp-right.png");
			string techniqueName     = (args.Length > 5 ? args[5] : "dcbgrid");

			//-------------------------------------------------------------------------------------

			Console.WriteLine("Running LeftRightStereo");
			Console.WriteLine("-----------------------");
			Console.WriteLine("Left image  : {0}", leftFilename);
			Console.WriteLine("Right image : {0}", rightFilename);
			Console.WriteLine("Disparities : {0}", numDisparities);
			Console.WriteLine("Technique   : {0}", techniqueName);
			Console.WriteLine();
				
			//-------------------------------------------------------------------------------------

			string leftFlippedFilename = Path.Combine(Path.GetTempPath(), "left-flipped.png");
			string rightFlippedFilename = Path.Combine(Path.GetTempPath(), "right-flipped.png");
			string rightFlippedDispFilename = Path.Combine(Path.GetTempPath(), "disp-right-flipped.png");

			// flip left image
			FlipImage(leftFilename, leftFlippedFilename);

			// flip right image
			FlipImage(rightFilename, rightFlippedFilename);

			// run left-right stereo
			StereoLibTesterProgram.Main(new string[] { leftFilename, rightFilename, numDisparities.ToString(), leftDispFilename, techniqueName });

			// run right-left stereo
			StereoLibTesterProgram.Main(new string[] { rightFlippedFilename, leftFlippedFilename, numDisparities.ToString(), rightFlippedDispFilename, techniqueName });

			// flip disparity image
			FlipImage(rightFlippedDispFilename, rightDispFilename);

			//// clean up: delete flipped images (throws IOException?!)
			//File.Delete(leftFlippedFilename);
			//File.Delete(rightFlippedFilename);
			//File.Delete(rightFlippedDispFilename);
		}

		private static void FlipImage(string filename, string flippedFilename)
		{
			using (Bitmap bitmap = new Bitmap(filename))
			{
				bitmap.RotateFlip(RotateFlipType.RotateNoneFlipX);
				bitmap.Save(flippedFilename);
			}
		}
	}
}
