﻿// $Id: LeftOnlyStereoProgram.cs 65 2010-03-18 17:06:22Z cr333 $
using System;
using System.Collections.Generic;
using System.Linq;
using System.Drawing;
using System.Text;
using System.IO;
using StereoLibTester;
using VideoLib;
using VideoLib.Scheduling;
using VideoLib.Sources;
using VideoLib.LibAv;
using VideoLib.Frames;
using CrossChecker;
using VideoLib.Sinks;

namespace LeftOnlyStereo
{
	public class LeftOnlyStereoProgram
	{
		public static void Main(string[] args)
		{
			if (args.Length < 5)
			{
				Console.WriteLine("Usage: LeftOnlyStereo input_dir num_disparities disparity_scale out_im_path technique_name");
				return;
			}

			// inputs
			string dataPath = args[0]; // "../../../data/teddy/";
			int numDisparities = Int32.Parse(args[1]); // 64
			int dispScale = Int32.Parse(args[2]); // 4
			string leftDispFilename = args[3];
			string techniqueName = args[4];

			// derived inputs
			string outputPath = Path.Combine(dataPath, techniqueName);
			string leftImageFilename = Path.Combine(dataPath, "left.png");
			string rightImageFilename = Path.Combine(dataPath, "right.png");
			//string maskAllFilename = Path.Combine(dataPath, "mask-all.png");
			//string maskNonoccFilename = Path.Combine(dataPath, "mask-nonocc.png");
			//string maskDiscFilename = Path.Combine(dataPath, "mask-disc.png");
			string groundTruthFilename = Path.Combine(dataPath, "true.png");
			Directory.CreateDirectory(outputPath);

			//-------------------------------------------------------------------------------------

			Console.WriteLine("Running LeftOnlyStereo");
			Console.WriteLine("----------------------");
			Console.WriteLine("Left image  : {0}", leftImageFilename);
			Console.WriteLine("Right image : {0}", rightImageFilename);
			Console.WriteLine("Disparities : {0}", numDisparities);
			Console.WriteLine("Scale       : {0}", dispScale);
			Console.WriteLine("Output Image: {0}", leftDispFilename);
			Console.WriteLine("Technique   : {0}", techniqueName);
			Console.WriteLine();

			//-------------------------------------------------------------------------------------

			// run left-right stereo
			StereoLibTesterProgram.Main(new string[] { leftImageFilename, rightImageFilename, numDisparities.ToString(), leftDispFilename, techniqueName });

			// post-process image
			RescaleAndSaveAsGIF(leftDispFilename, numDisparities, dispScale);
		}

		private static void RescaleAndSaveAsGIF(string filename, int numDisparities, int dispScale)
		{
			string outputFilename = Path.ChangeExtension(filename, "gif");

			// set up topology and scheduler ------------------------------------------------------
			Topology topology = Topology.MainInstance;
			Scheduler scheduler = new SimpleDequeScheduler(topology);

			// convert to float map and back to image
			topology.Connect(
				new ImageSequenceSource(filename) { LastNumber = 0 },
				new LibAvConvert(PixelFormat.RGB24),
				new GreyToFloatNode() { ScaleFactor = numDisparities / 255.0f },
				//new GreyToFloatNode(),
				new FloatToGreyNode() { ScaleFactor = dispScale },
				//new FloatToGreyNode(),
				new ImageSequenceSink(outputFilename)
			);

			// start the scheduler ----------------------------------------------------------------
			scheduler.Setup();
			scheduler.StartWorkers(1);
			scheduler.Join();
		}
	}
}
