﻿// $Id: DeSaturationProgram.cs 65 2010-03-18 17:06:22Z cr333 $
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Drawing;
using System.Drawing.Imaging;

namespace DeSaturateImage
{
	class DeSaturationProgram
	{
		static Color CreateColor(float r, float g, float b)
		{
			return Color.FromArgb(
				Math.Max(0, Math.Min(255, (int)(255.0f * r + 0.5f))),
				Math.Max(0, Math.Min(255, (int)(255.0f * g + 0.5f))),
				Math.Max(0, Math.Min(255, (int)(255.0f * b + 0.5f)))
			);
		}

		static void Main(string[] args)
		{
			// image names
			string inputFile = "left.png";
			string deChromaFile = "left-dechroma.png";

			Bitmap input = new Bitmap(inputFile);
			Bitmap deChroma = new Bitmap(input.Width, input.Height, PixelFormat.Format24bppRgb);

			for (int y = 0; y < input.Height; y++)
			{
				for (int x = 0; x < input.Width; x++)
				{
					// input pixel colour
					Color inputSrgb = input.GetPixel(x, y);
					float r = inputSrgb.R / 255.0f;
					float g = inputSrgb.G / 255.0f;
					float b = inputSrgb.B / 255.0f;

					// convert sRGB to linear RGB
					float lin_r = (float)(r <= 0.04045f ? r / 12.92f : Math.Pow((r + 0.055f) / 1.055f, 2.4f));
					float lin_g = (float)(g <= 0.04045f ? g / 12.92f : Math.Pow((g + 0.055f) / 1.055f, 2.4f));
					float lin_b = (float)(b <= 0.04045f ? b / 12.92f : Math.Pow((b + 0.055f) / 1.055f, 2.4f));

					// convert linear RGB to CIEXYZ
					float cie_x = 0.4124564f * lin_r + 0.3575761f * lin_g + 0.1804375f * lin_b;
					float cie_y = 0.2126729f * lin_r + 0.7151522f * lin_g + 0.0721750f * lin_b;
					float cie_z = 0.0193339f * lin_r + 0.1191920f * lin_g + 0.9503041f * lin_b;

					// convert CIEXYZ to CIELAB
					float cie_x_n = cie_x / 0.95047f;
					float cie_y_n = cie_y;
					float cie_z_n = cie_z / 1.08883f;
					float tmp_f_x = (cie_x_n > 216.0f / 24389.0f ? (float)Math.Pow(cie_x_n, 1.0f / 3.0f) : (24389.0f / 27.0f * cie_x_n + 16.0f) / 116.0f);
					float tmp_f_y = (cie_y_n > 216.0f / 24389.0f ? (float)Math.Pow(cie_y_n, 1.0f / 3.0f) : (24389.0f / 27.0f * cie_y_n + 16.0f) / 116.0f);
					float tmp_f_z = (cie_z_n > 216.0f / 24389.0f ? (float)Math.Pow(cie_z_n, 1.0f / 3.0f) : (24389.0f / 27.0f * cie_z_n + 16.0f) / 116.0f);
					float cie_l = 116.0f * tmp_f_y - 16.0f;
					float cie_a = 500.0f * (tmp_f_x - tmp_f_y);
					float cie_b = 200.0f * (tmp_f_y - tmp_f_z);

					// convert CIELAB to CIELCH
					float cie_c = (float)Math.Sqrt(cie_a * cie_a + cie_b * cie_b);
					float cie_h = (float)Math.Atan2(cie_b, cie_a);

					// and back ...........................

					cie_c = 60.0f;

					// convert CIELCH to CIELAB
					float new_cie_l = cie_l;
					float new_cie_a = cie_c * (float)Math.Cos(cie_h);
					float new_cie_b = cie_c * (float)Math.Sin(cie_h);

					// convert CIELAB to CIEXYZ
					float tmp_e = 216.0f / 24389.0f;
					float tmp_k = 24389.0f / 27.0f;
					float tmp_e_1_3 = (float)Math.Pow(tmp_e, 1.0f / 3.0f); // cube root of e
					tmp_f_y = (new_cie_l + 16.0f) / 116.0f;
					tmp_f_x = new_cie_a / 500.0f + tmp_f_y;
					tmp_f_z = tmp_f_y - new_cie_b / 200.0f;
					float new_cie_x = (Math.Pow(tmp_f_x, 3) > tmp_e ? (float)Math.Pow(tmp_f_x, 3.0f) : (116.0f * tmp_f_x - 16.0f) / tmp_k);
					float new_cie_y = (tmp_f_y > tmp_e_1_3 ? (float)Math.Pow(tmp_f_y, 3.0f) : (116.0f * tmp_f_y - 16.0f) / tmp_k);
					float new_cie_z = (tmp_f_z > tmp_e_1_3 ? (float)Math.Pow(tmp_f_z, 3.0f) : (116.0f * tmp_f_z - 16.0f) / tmp_k);
					new_cie_x *= 0.95047f;
					new_cie_z *= 1.08883f;

					// convert CIEXYZ to linear RGB
					float new_lin_r = 3.2404542f * new_cie_x - 1.5371385f * new_cie_y - 0.4985314f * new_cie_z;
					float new_lin_g = -0.9692660f * new_cie_x + 1.8760108f * new_cie_y + 0.0415560f * new_cie_z;
					float new_lin_b = 0.0556434f * new_cie_x - 0.2040259f * new_cie_y + 1.0572252f * new_cie_z;

					// convert linear RGB to sRGB
					float new_r = (new_lin_r <= 0.0031308f ? new_lin_r * 12.92f : 1.055f * (float)Math.Pow(new_lin_r, 1.0 / 2.4) - 0.055f);
					float new_g = (new_lin_g <= 0.0031308f ? new_lin_g * 12.92f : 1.055f * (float)Math.Pow(new_lin_g, 1.0 / 2.4) - 0.055f);
					float new_b = (new_lin_b <= 0.0031308f ? new_lin_b * 12.92f : 1.055f * (float)Math.Pow(new_lin_b, 1.0 / 2.4) - 0.055f);

					deChroma.SetPixel(x, y, CreateColor(new_r, new_g, new_b));
				}
			}

			deChroma.Save(deChromaFile, ImageFormat.Png);
		}
	}
}
