﻿using System;
using System.Windows.Forms;
using VideoLib;
using VideoLib.Scheduling;
using System.Threading;
using System.Security.Permissions;

namespace RealTimeStereoTestViewer
{
    static class Program
    {
        static MainFlexForm form = null;

        /// <summary>
        /// The main entry point for the application.
        /// </summary>
        [STAThread]
        static void Main()
        {
            Application.EnableVisualStyles();
            Application.SetCompatibleTextRenderingDefault(false);
#if !DEBUG
            RegisterUnhandledExceptionEventHandler();
            Application.ThreadException += new ThreadExceptionEventHandler(Application_ThreadException);
#endif
            form = new MainFlexForm();
            Application.Run(form);
#if !DEBUG
            Application.ThreadException -= Application_ThreadException;
#endif
        }

        [SecurityPermission(SecurityAction.Demand, Flags = SecurityPermissionFlag.ControlAppDomain)]
        public static void RegisterUnhandledExceptionEventHandler()
        {
            AppDomain currentDomain = AppDomain.CurrentDomain;
            currentDomain.UnhandledException += new UnhandledExceptionEventHandler(AppDomain_UnhandledException);
        }

        static void Application_ThreadException(object sender, ThreadExceptionEventArgs args)
        {
            Exception e = args.Exception;
            MessageBox.Show(
                String.Format("{0}: {1}\n\n{2}\n\n(Application.ThreadException)", e.GetType().Name, e.Message, e),
                String.Format("Error: {0}", e.GetType()), MessageBoxButtons.OK, MessageBoxIcon.Error);
            form.BeginInvoke(new Action(delegate() { form.Close(); }));
        }

        static void AppDomain_UnhandledException(object sender, UnhandledExceptionEventArgs args)
        {
            Exception e = (Exception)args.ExceptionObject;
            MessageBox.Show(
                String.Format("{0}: {1}\n\n{2}\n\n(AppDomain.UnhandledException)", e.GetType().Name, e.Message, e),
                String.Format("Error: {0}", e.GetType()), MessageBoxButtons.OK, MessageBoxIcon.Error);
            form.BeginInvoke(new Action(delegate() { form.Close(); }));
        }

    }
}
