﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using VideoLib;
using VideoLib.Frames;
using VideoLib.Parameters;

namespace RealTimeStereoTestViewer
{
    public class ImageShiftNode : Node
    {
        /// <summary>
        /// Creates an instance of <code>ImageShiftNode</code>
        /// </summary>
        public ImageShiftNode()
        {
            ParameterReflector.ApplyDefaults(this);

	        AddInputPin("in");
	        AddOutputPin("out");
        }

        public unsafe override void Process()
        {
            // Get input frames
            Frame fIn = GetInputFrame("in");
            if (PassOnEndOfStreamFrame(fIn))
                return;

            // Get the input bitmap data
            BitmapFrame input = CastFrameTo<BitmapFrame>(fIn);

            BitmapFrame output = new BitmapFrame(input.Width, input.Height, input.Format);
            output.SequenceNumber = input.SequenceNumber;

            int bytesPerPixel = input.Stride / input.Width;

            // Copy in the data, and fill edge values with 0
            if (Shift < input.Width)
            {
                if (Shift > 0)
                    for (int y = 0; y < input.Height; ++y)
                    {
                        Array.Clear(output.Data, output.Stride * y, Shift * bytesPerPixel);

                        Array.Copy(input.Data, input.Stride * y,
                            output.Data, output.Stride * y + Shift * bytesPerPixel,
                            (input.Width - Shift) * bytesPerPixel);
                    }
                else
                    for (int y = 0; y < input.Height; ++y)
                    {
                        Array.Clear(output.Data, output.Stride * y + (input.Width + Shift) * bytesPerPixel, -Shift * bytesPerPixel);

                        Array.Copy(input.Data, input.Stride * y - Shift * bytesPerPixel,
                            output.Data, output.Stride * y,
                            (input.Width + Shift) * bytesPerPixel);
                    }
            }

            // Send off the frame
            PushFrame(output);
        }

        #region Parameters
        [Parameter(Minimum = -40, Maximum = 40, Default = 0)]
        public int Shift { get; set; }
        #endregion
    }
}
