﻿// $Id: FloatToGreyNode.cs 65 2010-03-18 17:06:22Z cr333 $
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using VideoLib;
using VideoLib.Frames;
using System.Drawing.Imaging;
using System.Drawing;

namespace RealTimeStereoTestViewer
{
	public class FloatToGreyNode : Node
	{
		public float ScaleFactor { get; set; }

		public FloatToGreyNode()
			: base()
		{
			ScaleFactor = 1.0f;

			AddInputPin("in");
			AddOutputPin("out");
		}

		public override void Process()
		{
			// get input bitmap
			Frame frame = GetInputFrame("in");
			if (PassOnEndOfStreamFrame(frame)) return;
			BitmapFrame inputFrame = CastFrameTo<BitmapFrame>(frame);

			// check pixel format
			if (inputFrame.Format != VideoLib.Frames.PixelFormat.Float)
				throw new FrameNotSupportedException(inputFrame);

			// convert to array of floats
			BitmapFrame outputFrame = new BitmapFrame(inputFrame.Width, inputFrame.Height, VideoLib.Frames.PixelFormat.Grey8) { SequenceNumber = inputFrame.SequenceNumber };
			unsafe
			{
				fixed (byte* pInByte = inputFrame.Data, pOut = outputFrame.Data)
				{
					float* pIn = (float*)pInByte;
					for (int y = 0; y < inputFrame.Height; y++)
					{
						for (int x = 0; x < inputFrame.Width; x++)
						{
							pOut[y * outputFrame.Stride + x] = (byte)(Math.Max(0, Math.Min(255, 0.5f + ScaleFactor * pIn[y * inputFrame.Width + x])));
						}
					}
				}
			}

			PushFrame(outputFrame);
		}
	}
}
